/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.indexsegment.mutable;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.request.context.RequestContextUtils;
import org.apache.pinot.segment.local.aggregator.ValueAggregator;
import org.apache.pinot.segment.local.aggregator.ValueAggregatorFactory;
import org.apache.pinot.segment.local.dedup.PartitionDedupMetadataManager;
import org.apache.pinot.segment.local.realtime.impl.RealtimeSegmentConfig;
import org.apache.pinot.segment.local.realtime.impl.RealtimeSegmentStatsHistory;
import org.apache.pinot.segment.local.realtime.impl.dictionary.BaseOffHeapMutableDictionary;
import org.apache.pinot.segment.local.realtime.impl.geospatial.MutableH3Index;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.NativeMutableFSTIndex;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.NativeMutableTextIndex;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.RealtimeLuceneIndexRefreshState;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.RealtimeLuceneTextIndex;
import org.apache.pinot.segment.local.realtime.impl.nullvalue.MutableNullValueVector;
import org.apache.pinot.segment.local.segment.index.datasource.ImmutableDataSource;
import org.apache.pinot.segment.local.segment.index.datasource.MutableDataSource;
import org.apache.pinot.segment.local.segment.store.TextIndexUtils;
import org.apache.pinot.segment.local.segment.virtualcolumn.VirtualColumnContext;
import org.apache.pinot.segment.local.segment.virtualcolumn.VirtualColumnProvider;
import org.apache.pinot.segment.local.segment.virtualcolumn.VirtualColumnProviderFactory;
import org.apache.pinot.segment.local.upsert.PartitionUpsertMetadataManager;
import org.apache.pinot.segment.local.upsert.RecordInfo;
import org.apache.pinot.segment.local.utils.FixedIntArrayOffHeapIdMap;
import org.apache.pinot.segment.local.utils.GeometrySerializer;
import org.apache.pinot.segment.local.utils.IdMap;
import org.apache.pinot.segment.local.utils.IngestionUtils;
import org.apache.pinot.segment.local.utils.TableConfigUtils;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.MutableSegment;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.IndexingOverrides;
import org.apache.pinot.segment.spi.index.creator.H3IndexConfig;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.index.mutable.MutableDictionary;
import org.apache.pinot.segment.spi.index.mutable.MutableForwardIndex;
import org.apache.pinot.segment.spi.index.mutable.MutableInvertedIndex;
import org.apache.pinot.segment.spi.index.mutable.MutableJsonIndex;
import org.apache.pinot.segment.spi.index.mutable.MutableTextIndex;
import org.apache.pinot.segment.spi.index.mutable.ThreadSafeMutableRoaringBitmap;
import org.apache.pinot.segment.spi.index.mutable.provider.MutableIndexContext;
import org.apache.pinot.segment.spi.index.mutable.provider.MutableIndexProvider;
import org.apache.pinot.segment.spi.index.reader.BloomFilterReader;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.InvertedIndexReader;
import org.apache.pinot.segment.spi.index.reader.JsonIndexReader;
import org.apache.pinot.segment.spi.index.reader.RangeIndexReader;
import org.apache.pinot.segment.spi.index.reader.TextIndexReader;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2;
import org.apache.pinot.segment.spi.memory.PinotDataBufferMemoryManager;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.spi.config.table.ColumnPartitionConfig;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.SegmentPartitionConfig;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.config.table.ingestion.AggregationConfig;
import org.apache.pinot.spi.data.DimensionFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.MetricFieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.PrimaryKey;
import org.apache.pinot.spi.stream.RowMetadata;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.FixedIntArray;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.roaringbitmap.BatchIterator;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableSegmentImpl
implements MutableSegment {
    private static final String RECORD_ID_MAP = "__recordIdMap__";
    private static final int EXPECTED_COMPRESSION = 1000;
    private static final int MIN_ROWS_TO_INDEX = 1000000;
    private static final int MIN_RECORD_ID_MAP_CACHE_SIZE = 10000;
    private final Logger _logger;
    private final long _startTimeMillis = System.currentTimeMillis();
    private final ServerMetrics _serverMetrics;
    private final String _realtimeTableName;
    private final String _segmentName;
    private final Schema _schema;
    private final String _timeColumnName;
    private final int _capacity;
    private final SegmentMetadata _segmentMetadata;
    private final boolean _offHeap;
    private final PinotDataBufferMemoryManager _memoryManager;
    private final RealtimeSegmentStatsHistory _statsHistory;
    private final String _partitionColumn;
    private final PartitionFunction _partitionFunction;
    private final boolean _nullHandlingEnabled;
    private final Map<String, IndexContainer> _indexContainerMap = new HashMap<String, IndexContainer>();
    private final IdMap<FixedIntArray> _recordIdMap;
    private volatile int _numDocsIndexed = 0;
    private final int _numKeyColumns;
    private final Collection<FieldSpec> _physicalFieldSpecs;
    private final Collection<DimensionFieldSpec> _physicalDimensionFieldSpecs;
    private final Collection<MetricFieldSpec> _physicalMetricFieldSpecs;
    private final Collection<String> _physicalTimeColumnNames;
    private final List<FieldConfig> _fieldConfigList;
    private volatile long _lastIndexedTimeMs = Long.MIN_VALUE;
    private volatile long _latestIngestionTimeMs = Long.MIN_VALUE;
    private RealtimeLuceneIndexRefreshState.RealtimeLuceneReaders _realtimeLuceneReaders;
    private final Map<String, FieldSpec> _newlyAddedColumnsFieldMap = new ConcurrentHashMap<String, FieldSpec>();
    private final Map<String, FieldSpec> _newlyAddedPhysicalColumnsFieldMap = new ConcurrentHashMap<String, FieldSpec>();
    private final UpsertConfig.Mode _upsertMode;
    private final String _upsertComparisonColumn;
    private final PartitionUpsertMetadataManager _partitionUpsertMetadataManager;
    private final PartitionDedupMetadataManager _partitionDedupMetadataManager;
    private final ThreadSafeMutableRoaringBitmap _validDocIds;

    public MutableSegmentImpl(RealtimeSegmentConfig config, @Nullable ServerMetrics serverMetrics) {
        this._serverMetrics = serverMetrics;
        this._realtimeTableName = config.getTableNameWithType();
        this._segmentName = config.getSegmentName();
        this._schema = config.getSchema();
        this._timeColumnName = config.getTimeColumnName();
        this._fieldConfigList = config.getFieldConfigList();
        this._capacity = config.getCapacity();
        SegmentZKMetadata segmentZKMetadata = config.getSegmentZKMetadata();
        this._segmentMetadata = new SegmentMetadataImpl(TableNameBuilder.extractRawTableName((String)this._realtimeTableName), segmentZKMetadata.getSegmentName(), this._schema, segmentZKMetadata.getCreationTime()){

            public int getTotalDocs() {
                return MutableSegmentImpl.this._numDocsIndexed;
            }

            public long getLastIndexedTimestamp() {
                return MutableSegmentImpl.this._lastIndexedTimeMs;
            }

            public long getLatestIngestionTimestamp() {
                return MutableSegmentImpl.this._latestIngestionTimeMs;
            }
        };
        this._offHeap = config.isOffHeap();
        this._memoryManager = config.getMemoryManager();
        this._statsHistory = config.getStatsHistory();
        this._partitionColumn = config.getPartitionColumn();
        this._partitionFunction = config.getPartitionFunction();
        this._nullHandlingEnabled = config.isNullHandlingEnabled();
        Collection allFieldSpecs = this._schema.getAllFieldSpecs();
        ArrayList<FieldSpec> physicalFieldSpecs = new ArrayList<FieldSpec>(allFieldSpecs.size());
        ArrayList<DimensionFieldSpec> physicalDimensionFieldSpecs = new ArrayList<DimensionFieldSpec>(this._schema.getDimensionNames().size());
        ArrayList<MetricFieldSpec> physicalMetricFieldSpecs = new ArrayList<MetricFieldSpec>(this._schema.getMetricNames().size());
        ArrayList<String> physicalTimeColumnNames = new ArrayList<String>();
        for (FieldSpec fieldSpec : allFieldSpecs) {
            if (fieldSpec.isVirtualColumn()) continue;
            physicalFieldSpecs.add(fieldSpec);
            FieldSpec.FieldType fieldType = fieldSpec.getFieldType();
            if (fieldType == FieldSpec.FieldType.DIMENSION) {
                physicalDimensionFieldSpecs.add((DimensionFieldSpec)fieldSpec);
                continue;
            }
            if (fieldType == FieldSpec.FieldType.METRIC) {
                physicalMetricFieldSpecs.add((MetricFieldSpec)fieldSpec);
                continue;
            }
            if (fieldType != FieldSpec.FieldType.DATE_TIME && fieldType != FieldSpec.FieldType.TIME) continue;
            physicalTimeColumnNames.add(fieldSpec.getName());
        }
        this._physicalFieldSpecs = Collections.unmodifiableCollection(physicalFieldSpecs);
        this._physicalDimensionFieldSpecs = Collections.unmodifiableCollection(physicalDimensionFieldSpecs);
        this._physicalMetricFieldSpecs = Collections.unmodifiableCollection(physicalMetricFieldSpecs);
        this._physicalTimeColumnNames = Collections.unmodifiableCollection(physicalTimeColumnNames);
        this._numKeyColumns = this._physicalDimensionFieldSpecs.size() + this._physicalTimeColumnNames.size();
        this._logger = LoggerFactory.getLogger((String)(MutableSegmentImpl.class.getName() + "_" + this._segmentName + "_" + config.getStreamName()));
        Set<String> noDictionaryColumns = config.getNoDictionaryColumns();
        Set<String> invertedIndexColumns = config.getInvertedIndexColumns();
        Set<String> textIndexColumns = config.getTextIndexColumns();
        Set<String> fstIndexColumns = config.getFSTIndexColumns();
        Set<String> jsonIndexColumns = config.getJsonIndexColumns();
        Map<String, H3IndexConfig> h3IndexConfigs = config.getH3IndexConfigs();
        int avgNumMultiValues = config.getAvgNumMultiValues();
        this._recordIdMap = this.enableMetricsAggregationIfPossible(config, noDictionaryColumns);
        Map<Object, Object> metricsAggregators = Collections.emptyMap();
        if (this._recordIdMap != null) {
            metricsAggregators = MutableSegmentImpl.getMetricsAggregators(config);
        }
        for (FieldSpec fieldSpec : this._physicalFieldSpecs) {
            MutableH3Index h3Index;
            Object textIndex;
            Object properties;
            String column;
            boolean isDictionary = !this.isNoDictionaryColumn(noDictionaryColumns, invertedIndexColumns, fieldSpec, column = fieldSpec.getName());
            MutableIndexContext.Common context = MutableIndexContext.builder().withFieldSpec(fieldSpec).withMemoryManager(this._memoryManager).withDictionary(isDictionary).withCapacity(this._capacity).offHeap(this._offHeap).withSegmentName(this._segmentName).build();
            PartitionFunction partitionFunction = null;
            ConcurrentHashMap.KeySetView partitions = null;
            if (column.equals(this._partitionColumn)) {
                partitionFunction = this._partitionFunction;
                partitions = ConcurrentHashMap.newKeySet();
                partitions.add(config.getPartitionId());
            }
            FieldSpec.DataType storedType = fieldSpec.getDataType().getStoredType();
            boolean isFixedWidthColumn = storedType.isFixedWidth();
            MutableIndexProvider indexProvider = IndexingOverrides.getMutableIndexProvider();
            MutableForwardIndex forwardIndex = indexProvider.newForwardIndex(context.forForwardIndex(avgNumMultiValues));
            MutableDictionary dictionary = null;
            if (isDictionary) {
                int dictionaryColumnSize = isFixedWidthColumn ? storedType.size() : this._statsHistory.getEstimatedAvgColSize(column);
                int estimatedCardinality = (int)((double)this._statsHistory.getEstimatedCardinality(column) * 1.1);
                dictionary = indexProvider.newDictionary(context.forDictionary(dictionaryColumnSize, estimatedCardinality));
                noDictionaryColumns.remove(column);
            }
            MutableInvertedIndex invertedIndexReader = invertedIndexColumns.contains(column) ? indexProvider.newInvertedIndex(context.forInvertedIndex()) : null;
            NativeMutableFSTIndex fstIndex = null;
            if (this._fieldConfigList != null && fstIndexColumns.contains(column)) {
                for (FieldConfig fieldConfig : this._fieldConfigList) {
                    if (!fieldConfig.getName().equals(column) || !TextIndexUtils.isFstTypeNative((Map<String, String>)(properties = fieldConfig.getProperties()))) continue;
                    fstIndex = new NativeMutableFSTIndex(column);
                }
            }
            if (textIndexColumns.contains(column)) {
                boolean useNativeTextIndex = false;
                if (this._fieldConfigList != null) {
                    properties = this._fieldConfigList.iterator();
                    while (properties.hasNext()) {
                        Map properties2;
                        FieldConfig fieldConfig = properties.next();
                        if (!fieldConfig.getName().equals(column) || !TextIndexUtils.isFstTypeNative(properties2 = fieldConfig.getProperties())) continue;
                        useNativeTextIndex = true;
                    }
                }
                if (useNativeTextIndex) {
                    textIndex = new NativeMutableTextIndex(column);
                } else {
                    RealtimeLuceneTextIndex luceneTextIndex = new RealtimeLuceneTextIndex(column, new File(config.getConsumerDir()), this._segmentName);
                    if (this._realtimeLuceneReaders == null) {
                        this._realtimeLuceneReaders = new RealtimeLuceneIndexRefreshState.RealtimeLuceneReaders(this._segmentName);
                    }
                    this._realtimeLuceneReaders.addReader(luceneTextIndex);
                    textIndex = luceneTextIndex;
                }
            } else {
                textIndex = null;
            }
            MutableJsonIndex jsonIndex = jsonIndexColumns.contains(column) ? indexProvider.newJsonIndex(context.forJsonIndex()) : null;
            try {
                H3IndexConfig h3IndexConfig = h3IndexConfigs.get(column);
                h3Index = h3IndexConfig != null ? new MutableH3Index(h3IndexConfig.getResolution()) : null;
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Failed to initiate H3 index for column: %s", column), e);
            }
            MutableNullValueVector nullValueVector = this._nullHandlingEnabled ? new MutableNullValueVector() : null;
            Pair columnAggregatorPair = metricsAggregators.getOrDefault(column, Pair.of((Object)column, null));
            String sourceColumn = (String)columnAggregatorPair.getLeft();
            ValueAggregator valueAggregator = (ValueAggregator)columnAggregatorPair.getRight();
            this._indexContainerMap.put(column, new IndexContainer(fieldSpec, partitionFunction, partitions, new NumValuesInfo(), forwardIndex, dictionary, invertedIndexReader, null, (MutableTextIndex)textIndex, fstIndex, jsonIndex, h3Index, null, nullValueVector, sourceColumn, valueAggregator));
        }
        if (this._realtimeLuceneReaders != null) {
            RealtimeLuceneIndexRefreshState realtimeLuceneIndexRefreshState = RealtimeLuceneIndexRefreshState.getInstance();
            realtimeLuceneIndexRefreshState.addRealtimeReadersToQueue(this._realtimeLuceneReaders);
        }
        this._upsertMode = config.getUpsertMode();
        this._partitionDedupMetadataManager = config.getPartitionDedupMetadataManager();
        if (this.isUpsertEnabled()) {
            Preconditions.checkState((!this.isAggregateMetricsEnabled() ? 1 : 0) != 0, (Object)"Metrics aggregation and upsert cannot be enabled together");
            this._partitionUpsertMetadataManager = config.getPartitionUpsertMetadataManager();
            this._validDocIds = new ThreadSafeMutableRoaringBitmap();
            String upsertComparisonColumn = config.getUpsertComparisonColumn();
            this._upsertComparisonColumn = upsertComparisonColumn != null ? upsertComparisonColumn : this._timeColumnName;
        } else {
            this._partitionUpsertMetadataManager = null;
            this._validDocIds = null;
            this._upsertComparisonColumn = null;
        }
    }

    private boolean isNoDictionaryColumn(Set<String> noDictionaryColumns, Set<String> invertedIndexColumns, FieldSpec fieldSpec, String column) {
        FieldSpec.DataType dataType = fieldSpec.getDataType();
        if (noDictionaryColumns.contains(column)) {
            if (fieldSpec instanceof DimensionFieldSpec && this.isAggregateMetricsEnabled() && (dataType == FieldSpec.DataType.STRING || dataType == FieldSpec.DataType.BYTES)) {
                this._logger.info("Aggregate metrics is enabled. Will create dictionary in consuming segment for column {} of type {}", (Object)column, (Object)dataType);
                return false;
            }
            return (fieldSpec.isSingleValueField() || fieldSpec.getDataType().isFixedWidth()) && !invertedIndexColumns.contains(column);
        }
        return false;
    }

    public SegmentPartitionConfig getSegmentPartitionConfig() {
        if (this._partitionColumn != null) {
            return new SegmentPartitionConfig(Collections.singletonMap(this._partitionColumn, new ColumnPartitionConfig(this._partitionFunction.getName(), this._partitionFunction.getNumPartitions())));
        }
        return null;
    }

    @Deprecated
    public long getMinTime() {
        Long minTime = IngestionUtils.extractTimeValue(this._indexContainerMap.get((Object)this._timeColumnName)._minValue);
        if (minTime != null) {
            return minTime;
        }
        return Long.MAX_VALUE;
    }

    @Deprecated
    public long getMaxTime() {
        Long maxTime = IngestionUtils.extractTimeValue(this._indexContainerMap.get((Object)this._timeColumnName)._maxValue);
        if (maxTime != null) {
            return maxTime;
        }
        return Long.MIN_VALUE;
    }

    public void addExtraColumns(Schema newSchema) {
        for (String columnName : newSchema.getColumnNames()) {
            if (this._schema.getColumnNames().contains(columnName)) continue;
            FieldSpec fieldSpec = newSchema.getFieldSpecFor(columnName);
            this._newlyAddedColumnsFieldMap.put(columnName, fieldSpec);
            if (fieldSpec.isVirtualColumn()) continue;
            this._newlyAddedPhysicalColumnsFieldMap.put(columnName, fieldSpec);
        }
        this._logger.info("Newly added columns: " + this._newlyAddedColumnsFieldMap);
    }

    public boolean index(GenericRow row, @Nullable RowMetadata rowMetadata) throws IOException {
        boolean canTakeMore;
        int numDocsIndexed = this._numDocsIndexed;
        RecordInfo recordInfo = null;
        if (this.isDedupEnabled() || this.isUpsertEnabled()) {
            recordInfo = this.getRecordInfo(row, numDocsIndexed);
        }
        if (this.isDedupEnabled() && this._partitionDedupMetadataManager.checkRecordPresentOrUpdate(recordInfo.getPrimaryKey(), (IndexSegment)this)) {
            if (this._serverMetrics != null) {
                this._serverMetrics.addMeteredTableValue(this._realtimeTableName, (AbstractMetrics.Meter)ServerMeter.REALTIME_DEDUP_DROPPED, 1L);
            }
            return true;
        }
        if (this.isUpsertEnabled()) {
            GenericRow updatedRow = this._partitionUpsertMetadataManager.updateRecord(row, recordInfo);
            this.updateDictionary(updatedRow);
            this.addNewRow(numDocsIndexed, updatedRow);
            canTakeMore = numDocsIndexed++ < this._capacity;
            this._partitionUpsertMetadataManager.addRecord(this, recordInfo);
        } else {
            this.updateDictionary(row);
            int docId = this.getOrCreateDocId();
            if (docId == numDocsIndexed) {
                this.addNewRow(numDocsIndexed, row);
                canTakeMore = numDocsIndexed++ < this._capacity;
            } else {
                assert (this.isAggregateMetricsEnabled());
                this.aggregateMetrics(row, docId);
                canTakeMore = true;
            }
        }
        this._numDocsIndexed = numDocsIndexed;
        this._lastIndexedTimeMs = System.currentTimeMillis();
        if (rowMetadata != null) {
            this._latestIngestionTimeMs = Math.max(this._latestIngestionTimeMs, rowMetadata.getIngestionTimeMs());
        }
        return canTakeMore;
    }

    private boolean isUpsertEnabled() {
        return this._upsertMode != UpsertConfig.Mode.NONE;
    }

    private boolean isDedupEnabled() {
        return this._partitionDedupMetadataManager != null;
    }

    private RecordInfo getRecordInfo(GenericRow row, int docId) {
        PrimaryKey primaryKey = row.getPrimaryKey(this._schema.getPrimaryKeyColumns());
        if (this.isUpsertEnabled()) {
            Object upsertComparisonValue = row.getValue(this._upsertComparisonColumn);
            Preconditions.checkState((boolean)(upsertComparisonValue instanceof Comparable), (String)"Upsert comparison column: %s must be comparable", (Object)this._upsertComparisonColumn);
            return new RecordInfo(primaryKey, docId, (Comparable)upsertComparisonValue);
        }
        return new RecordInfo(primaryKey, docId, null);
    }

    private void updateDictionary(GenericRow row) {
        for (Map.Entry<String, IndexContainer> entry : this._indexContainerMap.entrySet()) {
            IndexContainer indexContainer = entry.getValue();
            MutableDictionary dictionary = indexContainer._dictionary;
            if (dictionary == null) continue;
            Object value = row.getValue(entry.getKey());
            if (value == null) {
                this.recordIndexingError("DICTIONARY");
                continue;
            }
            if (indexContainer._fieldSpec.isSingleValueField()) {
                indexContainer._dictId = dictionary.index(value);
            } else {
                indexContainer._dictIds = dictionary.index((Object[])value);
            }
            indexContainer._minValue = dictionary.getMinVal();
            indexContainer._maxValue = dictionary.getMaxVal();
        }
    }

    private void addNewRow(int docId, GenericRow row) {
        block31: for (Map.Entry<String, IndexContainer> entry : this._indexContainerMap.entrySet()) {
            Object textIndex;
            FieldSpec.DataType dataType;
            Object value;
            String column = entry.getKey();
            IndexContainer indexContainer = entry.getValue();
            if (indexContainer._valueAggregator != null) {
                value = row.getValue(indexContainer._sourceColumn);
                indexContainer._numValuesInfo.updateSVEntry();
                MutableForwardIndex forwardIndex = indexContainer._forwardIndex;
                FieldSpec fieldSpec = indexContainer._fieldSpec;
                dataType = fieldSpec.getDataType();
                value = indexContainer._valueAggregator.getInitialAggregatedValue(value);
                switch (dataType.getStoredType()) {
                    case INT: {
                        forwardIndex.setInt(docId, ((Number)value).intValue());
                        continue block31;
                    }
                    case LONG: {
                        forwardIndex.setLong(docId, ((Number)value).longValue());
                        continue block31;
                    }
                    case FLOAT: {
                        forwardIndex.setFloat(docId, ((Number)value).floatValue());
                        continue block31;
                    }
                    case DOUBLE: {
                        forwardIndex.setDouble(docId, ((Number)value).doubleValue());
                        continue block31;
                    }
                }
                throw new UnsupportedOperationException("Unsupported data type: " + dataType + " for aggregation: " + column);
            }
            if (this._nullHandlingEnabled && row.isNullValue(column)) {
                indexContainer._nullValueVector.setNull(docId);
            }
            if ((value = row.getValue(column)) == null) continue;
            FieldSpec fieldSpec = indexContainer._fieldSpec;
            if (fieldSpec.isSingleValueField()) {
                MutableH3Index h3Index;
                MutableJsonIndex jsonIndex;
                int partition;
                if (column.equals(this._partitionColumn) && indexContainer._partitions.add(partition = this._partitionFunction.getPartition(value))) {
                    this._logger.warn("Found new partition: {} from partition column: {}, value: {}", new Object[]{partition, column, value});
                    if (this._serverMetrics != null) {
                        this._serverMetrics.addMeteredTableValue(this._realtimeTableName, (AbstractMetrics.Meter)ServerMeter.REALTIME_PARTITION_MISMATCH, 1L);
                    }
                }
                indexContainer._numValuesInfo.updateSVEntry();
                MutableForwardIndex forwardIndex = indexContainer._forwardIndex;
                int dictId = indexContainer._dictId;
                if (dictId >= 0) {
                    forwardIndex.setDictId(docId, dictId);
                    MutableInvertedIndex invertedIndex = indexContainer._invertedIndex;
                    if (invertedIndex != null) {
                        try {
                            invertedIndex.add(dictId, docId);
                        }
                        catch (Exception e) {
                            this.recordIndexingError(FieldConfig.IndexType.INVERTED, e);
                        }
                    }
                } else {
                    FieldSpec.DataType dataType2 = fieldSpec.getDataType();
                    switch (dataType2.getStoredType()) {
                        case INT: {
                            forwardIndex.setInt(docId, ((Integer)value).intValue());
                            break;
                        }
                        case LONG: {
                            forwardIndex.setLong(docId, ((Long)value).longValue());
                            break;
                        }
                        case FLOAT: {
                            forwardIndex.setFloat(docId, ((Float)value).floatValue());
                            break;
                        }
                        case DOUBLE: {
                            forwardIndex.setDouble(docId, ((Double)value).doubleValue());
                            break;
                        }
                        case BIG_DECIMAL: {
                            forwardIndex.setBigDecimal(docId, (BigDecimal)value);
                            break;
                        }
                        case STRING: {
                            forwardIndex.setString(docId, (String)value);
                            break;
                        }
                        case BYTES: {
                            forwardIndex.setBytes(docId, (byte[])value);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Unsupported data type: " + dataType2 + " for no-dictionary column: " + column);
                        }
                    }
                    if (!this.isAggregateMetricsEnabled() || fieldSpec.getFieldType() != FieldSpec.FieldType.METRIC) {
                        Comparable comparable = dataType2 == FieldSpec.DataType.BYTES ? new ByteArray((byte[])value) : (Comparable)value;
                        if (indexContainer._minValue == null) {
                            indexContainer._minValue = comparable;
                            indexContainer._maxValue = comparable;
                        } else {
                            if (comparable.compareTo(indexContainer._minValue) < 0) {
                                indexContainer._minValue = comparable;
                            }
                            if (comparable.compareTo(indexContainer._maxValue) > 0) {
                                indexContainer._maxValue = comparable;
                            }
                        }
                    }
                }
                if ((textIndex = (Object)indexContainer._textIndex) != null) {
                    try {
                        textIndex.add((String)value);
                    }
                    catch (Exception e) {
                        this.recordIndexingError(FieldConfig.IndexType.TEXT, e);
                    }
                }
                if ((jsonIndex = indexContainer._jsonIndex) != null) {
                    try {
                        jsonIndex.add((String)value);
                    }
                    catch (Exception e) {
                        this.recordIndexingError(FieldConfig.IndexType.JSON, e);
                    }
                }
                if ((h3Index = indexContainer._h3Index) == null) continue;
                try {
                    h3Index.add(GeometrySerializer.deserialize((byte[])value));
                }
                catch (Exception e) {
                    this.recordIndexingError(FieldConfig.IndexType.H3, e);
                }
                continue;
            }
            int[] dictIds = indexContainer._dictIds;
            if (dictIds != null) {
                indexContainer._numValuesInfo.updateMVEntry(dictIds.length);
                indexContainer._forwardIndex.setDictIdMV(docId, dictIds);
                MutableInvertedIndex invertedIndex = indexContainer._invertedIndex;
                if (invertedIndex == null) continue;
                textIndex = dictIds;
                int jsonIndex = ((int[])textIndex).length;
                for (int h3Index = 0; h3Index < jsonIndex; ++h3Index) {
                    int dictId = textIndex[h3Index];
                    try {
                        invertedIndex.add(dictId, docId);
                        continue;
                    }
                    catch (Exception e) {
                        this.recordIndexingError(FieldConfig.IndexType.INVERTED, e);
                    }
                }
                continue;
            }
            dataType = fieldSpec.getDataType();
            switch (dataType.getStoredType()) {
                case INT: {
                    Object[] values = (Object[])value;
                    int[] intValues = new int[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        intValues[i] = (Integer)values[i];
                    }
                    indexContainer._forwardIndex.setIntMV(docId, intValues);
                    indexContainer._numValuesInfo.updateMVEntry(intValues.length);
                    continue block31;
                }
                case LONG: {
                    Object[] values = (Object[])value;
                    long[] longValues = new long[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        longValues[i] = (Long)values[i];
                    }
                    indexContainer._forwardIndex.setLongMV(docId, longValues);
                    indexContainer._numValuesInfo.updateMVEntry(longValues.length);
                    continue block31;
                }
                case FLOAT: {
                    Object[] values = (Object[])value;
                    float[] floatValues = new float[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        floatValues[i] = ((Float)values[i]).floatValue();
                    }
                    indexContainer._forwardIndex.setFloatMV(docId, floatValues);
                    indexContainer._numValuesInfo.updateMVEntry(floatValues.length);
                    continue block31;
                }
                case DOUBLE: {
                    Object[] values = (Object[])value;
                    double[] doubleValues = new double[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        doubleValues[i] = (Double)values[i];
                    }
                    indexContainer._forwardIndex.setDoubleMV(docId, doubleValues);
                    indexContainer._numValuesInfo.updateMVEntry(doubleValues.length);
                    continue block31;
                }
            }
            throw new UnsupportedOperationException("Unsupported data type: " + dataType + " for MV no-dictionary column: " + column);
        }
    }

    private void recordIndexingError(FieldConfig.IndexType indexType, Exception exception) {
        this._logger.error("failed to index value with {}", (Object)indexType, (Object)exception);
        if (this._serverMetrics != null) {
            String metricKeyName = this._realtimeTableName + "-" + indexType + "-indexingError";
            this._serverMetrics.addMeteredTableValue(metricKeyName, (AbstractMetrics.Meter)ServerMeter.INDEXING_FAILURES, 1L);
        }
    }

    private void recordIndexingError(String indexType) {
        this._logger.error("failed to index value with {}", (Object)indexType);
        if (this._serverMetrics != null) {
            String metricKeyName = this._realtimeTableName + "-" + indexType + "-indexingError";
            this._serverMetrics.addMeteredTableValue(metricKeyName, (AbstractMetrics.Meter)ServerMeter.INDEXING_FAILURES, 1L);
        }
    }

    private void aggregateMetrics(GenericRow row, int docId) {
        block16: for (MetricFieldSpec metricFieldSpec : this._physicalMetricFieldSpecs) {
            IndexContainer indexContainer = this._indexContainerMap.get(metricFieldSpec.getName());
            Object value = row.getValue(indexContainer._sourceColumn);
            MutableForwardIndex forwardIndex = indexContainer._forwardIndex;
            FieldSpec.DataType dataType = metricFieldSpec.getDataType();
            ValueAggregator valueAggregator = indexContainer._valueAggregator;
            switch (valueAggregator.getAggregatedValueType()) {
                case DOUBLE: {
                    switch (dataType) {
                        case INT: {
                            Double oldDoubleValue = Integer.valueOf(forwardIndex.getInt(docId)).doubleValue();
                            Double newDoubleValue = valueAggregator.applyRawValue(oldDoubleValue, value);
                            forwardIndex.setInt(docId, newDoubleValue.intValue());
                            continue block16;
                        }
                        case LONG: {
                            Double oldDoubleValue = Long.valueOf(forwardIndex.getLong(docId)).doubleValue();
                            Double newDoubleValue = valueAggregator.applyRawValue(oldDoubleValue, value);
                            forwardIndex.setLong(docId, newDoubleValue.longValue());
                            continue block16;
                        }
                        case FLOAT: {
                            Double oldDoubleValue = Float.valueOf(forwardIndex.getFloat(docId)).doubleValue();
                            Double newDoubleValue = valueAggregator.applyRawValue(oldDoubleValue, value);
                            forwardIndex.setFloat(docId, newDoubleValue.floatValue());
                            continue block16;
                        }
                        case DOUBLE: {
                            Double oldDoubleValue = forwardIndex.getDouble(docId);
                            Double newDoubleValue = valueAggregator.applyRawValue(oldDoubleValue, value);
                            forwardIndex.setDouble(docId, newDoubleValue.doubleValue());
                            continue block16;
                        }
                    }
                    throw new UnsupportedOperationException(String.format("Aggregation type %s of %s not supported for %s", valueAggregator.getAggregatedValueType(), valueAggregator.getAggregationType(), dataType));
                }
                case LONG: {
                    switch (dataType) {
                        case INT: {
                            Long oldLongValue = Integer.valueOf(forwardIndex.getInt(docId)).longValue();
                            Long newLongValue = valueAggregator.applyRawValue(oldLongValue, value);
                            forwardIndex.setInt(docId, newLongValue.intValue());
                            continue block16;
                        }
                        case LONG: {
                            Long oldLongValue = forwardIndex.getLong(docId);
                            Long newLongValue = valueAggregator.applyRawValue(oldLongValue, value);
                            forwardIndex.setLong(docId, newLongValue.longValue());
                            continue block16;
                        }
                        case FLOAT: {
                            Long oldLongValue = Float.valueOf(forwardIndex.getFloat(docId)).longValue();
                            Long newLongValue = valueAggregator.applyRawValue(oldLongValue, value);
                            forwardIndex.setFloat(docId, newLongValue.floatValue());
                            continue block16;
                        }
                        case DOUBLE: {
                            Long oldLongValue = Double.valueOf(forwardIndex.getDouble(docId)).longValue();
                            Long newLongValue = valueAggregator.applyRawValue(oldLongValue, value);
                            forwardIndex.setDouble(docId, newLongValue.doubleValue());
                            continue block16;
                        }
                    }
                    throw new UnsupportedOperationException(String.format("Aggregation type %s of %s not supported for %s", valueAggregator.getAggregatedValueType(), valueAggregator.getAggregationType(), dataType));
                }
            }
            throw new UnsupportedOperationException(String.format("Aggregation type %s of %s not supported for %s", valueAggregator.getAggregatedValueType(), valueAggregator.getAggregationType(), dataType));
        }
    }

    public int getNumDocsIndexed() {
        return this._numDocsIndexed;
    }

    public String getSegmentName() {
        return this._segmentName;
    }

    public SegmentMetadata getSegmentMetadata() {
        return this._segmentMetadata;
    }

    public Set<String> getColumnNames() {
        return Sets.union((Set)this._schema.getColumnNames(), this._newlyAddedColumnsFieldMap.keySet());
    }

    public Set<String> getPhysicalColumnNames() {
        HashSet<String> physicalColumnNames = new HashSet<String>();
        for (FieldSpec fieldSpec : this._physicalFieldSpecs) {
            physicalColumnNames.add(fieldSpec.getName());
        }
        return Sets.union(physicalColumnNames, this._newlyAddedPhysicalColumnsFieldMap.keySet());
    }

    public DataSource getDataSource(String column) {
        FieldSpec fieldSpec = this._schema.getFieldSpecFor(column);
        if (fieldSpec == null || fieldSpec.isVirtualColumn()) {
            if (fieldSpec == null) {
                fieldSpec = this._newlyAddedColumnsFieldMap.get(column);
                Preconditions.checkNotNull((Object)fieldSpec, (Object)("FieldSpec for " + column + " should not be null. Potentially invalid column name specified."));
            }
            VirtualColumnContext virtualColumnContext = new VirtualColumnContext(fieldSpec, this._numDocsIndexed);
            VirtualColumnProvider virtualColumnProvider = VirtualColumnProviderFactory.buildProvider(virtualColumnContext);
            return new ImmutableDataSource(virtualColumnProvider.buildMetadata(virtualColumnContext), virtualColumnProvider.buildColumnIndexContainer(virtualColumnContext));
        }
        return this._indexContainerMap.get(column).toDataSource();
    }

    public List<StarTreeV2> getStarTrees() {
        return null;
    }

    @Nullable
    public ThreadSafeMutableRoaringBitmap getValidDocIds() {
        return this._validDocIds;
    }

    public GenericRow getRecord(int docId, GenericRow reuse) {
        for (Map.Entry<String, IndexContainer> entry : this._indexContainerMap.entrySet()) {
            Object value;
            String column = entry.getKey();
            IndexContainer indexContainer = entry.getValue();
            try {
                value = MutableSegmentImpl.getValue(docId, indexContainer._forwardIndex, indexContainer._dictionary, indexContainer._numValuesInfo._maxNumValuesPerMVEntry);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Caught exception while reading value for docId: %d, column: %s", docId, column), e);
            }
            if (this._nullHandlingEnabled && indexContainer._nullValueVector.isNull(docId)) {
                reuse.putDefaultNullValue(column, value);
                continue;
            }
            reuse.putValue(column, value);
        }
        return reuse;
    }

    public Object getValue(int docId, String column) {
        try {
            IndexContainer indexContainer = this._indexContainerMap.get(column);
            return MutableSegmentImpl.getValue(docId, indexContainer._forwardIndex, indexContainer._dictionary, indexContainer._numValuesInfo._maxNumValuesPerMVEntry);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Caught exception while reading value for docId: %d, column: %s", docId, column), e);
        }
    }

    private static Object getValue(int docId, MutableForwardIndex forwardIndex, @Nullable MutableDictionary dictionary, int maxNumMultiValues) {
        if (dictionary != null) {
            if (forwardIndex.isSingleValue()) {
                int dictId = forwardIndex.getDictId(docId);
                return dictionary.get(dictId);
            }
            int[] dictIds = new int[maxNumMultiValues];
            int numValues = forwardIndex.getDictIdMV(docId, dictIds);
            Object[] value = new Object[numValues];
            for (int i = 0; i < numValues; ++i) {
                value[i] = dictionary.get(dictIds[i]);
            }
            return value;
        }
        if (forwardIndex.isSingleValue()) {
            switch (forwardIndex.getStoredType()) {
                case INT: {
                    return forwardIndex.getInt(docId);
                }
                case LONG: {
                    return forwardIndex.getLong(docId);
                }
                case FLOAT: {
                    return Float.valueOf(forwardIndex.getFloat(docId));
                }
                case DOUBLE: {
                    return forwardIndex.getDouble(docId);
                }
                case BIG_DECIMAL: {
                    return forwardIndex.getBigDecimal(docId);
                }
                case STRING: {
                    return forwardIndex.getString(docId);
                }
                case BYTES: {
                    return forwardIndex.getBytes(docId);
                }
            }
            throw new IllegalStateException();
        }
        switch (forwardIndex.getStoredType()) {
            case INT: {
                int[] intValues = forwardIndex.getIntMV(docId);
                int numValues = intValues.length;
                Object[] value = new Object[numValues];
                for (int i = 0; i < numValues; ++i) {
                    value[i] = intValues[i];
                }
                return value;
            }
            case LONG: {
                long[] longValues = forwardIndex.getLongMV(docId);
                int numValues = longValues.length;
                Object[] value = new Object[numValues];
                for (int i = 0; i < numValues; ++i) {
                    value[i] = longValues[i];
                }
                return value;
            }
            case FLOAT: {
                float[] floatValues = forwardIndex.getFloatMV(docId);
                int numValues = floatValues.length;
                Object[] value = new Object[numValues];
                for (int i = 0; i < numValues; ++i) {
                    value[i] = Float.valueOf(floatValues[i]);
                }
                return value;
            }
            case DOUBLE: {
                double[] doubleValues = forwardIndex.getDoubleMV(docId);
                int numValues = doubleValues.length;
                Object[] value = new Object[numValues];
                for (int i = 0; i < numValues; ++i) {
                    value[i] = doubleValues[i];
                }
                return value;
            }
        }
        throw new IllegalStateException("No support for MV no dictionary column of type " + forwardIndex.getStoredType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this._logger.info("Trying to close RealtimeSegmentImpl : {}", (Object)this._segmentName);
        if (this._partitionUpsertMetadataManager != null) {
            this._partitionUpsertMetadataManager.removeSegment((IndexSegment)this);
        }
        if (this._partitionDedupMetadataManager != null) {
            this._partitionDedupMetadataManager.removeSegment((IndexSegment)this);
        }
        if (this._offHeap && this._numDocsIndexed > 0) {
            int numSeconds = (int)((System.currentTimeMillis() - this._startTimeMillis) / 1000L);
            long totalMemBytes = this._memoryManager.getTotalAllocatedBytes();
            this._logger.info("Segment used {} bytes of memory for {} rows consumed in {} seconds", new Object[]{totalMemBytes, this._numDocsIndexed, numSeconds});
            RealtimeSegmentStatsHistory.SegmentStats segmentStats = new RealtimeSegmentStatsHistory.SegmentStats();
            for (Map.Entry<String, IndexContainer> entry : this._indexContainerMap.entrySet()) {
                String column = entry.getKey();
                BaseOffHeapMutableDictionary dictionary = (BaseOffHeapMutableDictionary)entry.getValue()._dictionary;
                if (dictionary == null) continue;
                RealtimeSegmentStatsHistory.ColumnStats columnStats = new RealtimeSegmentStatsHistory.ColumnStats();
                columnStats.setCardinality(dictionary.length());
                columnStats.setAvgColumnSize(dictionary.getAvgValueSize());
                segmentStats.setColumnStats(column, columnStats);
            }
            segmentStats.setNumRowsConsumed(this._numDocsIndexed);
            segmentStats.setNumRowsIndexed(this._numDocsIndexed);
            segmentStats.setMemUsedBytes(totalMemBytes);
            segmentStats.setNumSeconds(numSeconds);
            this._statsHistory.addSegmentStats(segmentStats);
        }
        if (this._realtimeLuceneReaders != null) {
            this._realtimeLuceneReaders.getLock().lock();
            try {
                this._realtimeLuceneReaders.setSegmentDestroyed();
                this._realtimeLuceneReaders.clearRealtimeReaderList();
            }
            finally {
                this._realtimeLuceneReaders.getLock().unlock();
            }
        }
        for (IndexContainer indexContainer : this._indexContainerMap.values()) {
            indexContainer.close();
        }
        if (this._recordIdMap != null) {
            try {
                this._recordIdMap.close();
            }
            catch (IOException e) {
                this._logger.error("Failed to close the record id map. Continuing with error.", (Throwable)e);
            }
        }
        try {
            this._memoryManager.close();
        }
        catch (IOException e) {
            this._logger.error("Failed to close the memory manager", (Throwable)e);
        }
    }

    public int[] getSortedDocIdIterationOrderWithSortedColumn(String column) {
        IndexContainer indexContainer = this._indexContainerMap.get(column);
        MutableDictionary dictionary = indexContainer._dictionary;
        int numDocsIndexed = this._numDocsIndexed;
        int numValues = dictionary.length();
        int[] dictIds = new int[numValues];
        for (int i = 0; i < numValues; ++i) {
            dictIds[i] = i;
        }
        IntArrays.quickSort((int[])dictIds, (arg_0, arg_1) -> ((MutableDictionary)dictionary).compare(arg_0, arg_1));
        MutableInvertedIndex invertedIndex = indexContainer._invertedIndex;
        int[] docIds = new int[numDocsIndexed];
        int[] batch = new int[256];
        int docIdIndex = 0;
        for (int dictId : dictIds) {
            MutableRoaringBitmap bitmap = (MutableRoaringBitmap)invertedIndex.getDocIds(dictId);
            BatchIterator iterator = bitmap.getBatchIterator();
            while (iterator.hasNext()) {
                int limit = iterator.nextBatch(batch);
                System.arraycopy(batch, 0, docIds, docIdIndex, limit);
                docIdIndex += limit;
            }
        }
        Preconditions.checkState((numDocsIndexed == docIdIndex ? 1 : 0) != 0, (String)"The number of documents indexed: %s is not equal to the number of sorted documents: %s", (int)numDocsIndexed, (int)docIdIndex);
        return docIds;
    }

    private int getOrCreateDocId() {
        if (!this.isAggregateMetricsEnabled()) {
            return this._numDocsIndexed;
        }
        int i = 0;
        int[] dictIds = new int[this._numKeyColumns];
        for (FieldSpec fieldSpec : this._physicalDimensionFieldSpecs) {
            dictIds[i++] = this._indexContainerMap.get((Object)fieldSpec.getName())._dictId;
        }
        for (String string : this._physicalTimeColumnNames) {
            dictIds[i++] = this._indexContainerMap.get((Object)string)._dictId;
        }
        return this._recordIdMap.put(new FixedIntArray(dictIds));
    }

    private IdMap<FixedIntArray> enableMetricsAggregationIfPossible(RealtimeSegmentConfig config, Set<String> noDictionaryColumns) {
        if (!config.aggregateMetrics() && CollectionUtils.isEmpty(config.getIngestionAggregationConfigs())) {
            this._logger.info("Metrics aggregation is disabled.");
            return null;
        }
        for (FieldSpec fieldSpec : this._physicalMetricFieldSpecs) {
            String metric = fieldSpec.getName();
            if (!noDictionaryColumns.contains(metric)) {
                this._logger.warn("Metrics aggregation cannot be turned ON in presence of dictionary encoded metrics, eg: {}", (Object)metric);
                return null;
            }
            if (fieldSpec.isSingleValueField()) continue;
            this._logger.warn("Metrics aggregation cannot be turned ON in presence of multi-value metric columns, eg: {}", (Object)metric);
            return null;
        }
        for (FieldSpec fieldSpec : this._physicalDimensionFieldSpecs) {
            String dimension = fieldSpec.getName();
            if (noDictionaryColumns.contains(dimension)) {
                this._logger.warn("Metrics aggregation cannot be turned ON in presence of no-dictionary dimensions, eg: {}", (Object)dimension);
                return null;
            }
            if (fieldSpec.isSingleValueField()) continue;
            this._logger.warn("Metrics aggregation cannot be turned ON in presence of multi-value dimension columns, eg: {}", (Object)dimension);
            return null;
        }
        for (String string : this._physicalTimeColumnNames) {
            if (!noDictionaryColumns.contains(string)) continue;
            this._logger.warn("Metrics aggregation cannot be turned ON in presence of no-dictionary datetime/time columns, eg: {}", (Object)string);
            return null;
        }
        int estimatedRowsToIndex = this._statsHistory.isEmpty() ? Math.max(config.getCapacity() / 1000, 1000000) : Math.max(this._statsHistory.getEstimatedRowsToIndex(), 1000000);
        int n = Math.max(estimatedRowsToIndex / 1000, 10000);
        this._logger.info("Initializing metrics update: estimatedRowsToIndex:{}, cacheSize:{}", (Object)estimatedRowsToIndex, (Object)n);
        return new FixedIntArrayOffHeapIdMap(estimatedRowsToIndex, n, this._numKeyColumns, this._memoryManager, RECORD_ID_MAP);
    }

    private boolean isAggregateMetricsEnabled() {
        return this._recordIdMap != null;
    }

    private static Map<String, Pair<String, ValueAggregator>> getMetricsAggregators(RealtimeSegmentConfig segmentConfig) {
        if (segmentConfig.aggregateMetrics()) {
            return MutableSegmentImpl.fromAggregateMetrics(segmentConfig);
        }
        if (!CollectionUtils.isEmpty(segmentConfig.getIngestionAggregationConfigs())) {
            return MutableSegmentImpl.fromAggregationConfig(segmentConfig);
        }
        return Collections.emptyMap();
    }

    private static Map<String, Pair<String, ValueAggregator>> fromAggregateMetrics(RealtimeSegmentConfig segmentConfig) {
        Preconditions.checkState((boolean)CollectionUtils.isEmpty(segmentConfig.getIngestionAggregationConfigs()), (Object)"aggregateMetrics cannot be enabled if AggregationConfig is set");
        HashMap<String, Pair<String, ValueAggregator>> columnNameToAggregator = new HashMap<String, Pair<String, ValueAggregator>>();
        for (String metricName : segmentConfig.getSchema().getMetricNames()) {
            columnNameToAggregator.put(metricName, (Pair<String, ValueAggregator>)Pair.of((Object)metricName, (Object)ValueAggregatorFactory.getValueAggregator(AggregationFunctionType.SUM)));
        }
        return columnNameToAggregator;
    }

    private static Map<String, Pair<String, ValueAggregator>> fromAggregationConfig(RealtimeSegmentConfig segmentConfig) {
        HashMap<String, Pair<String, ValueAggregator>> columnNameToAggregator = new HashMap<String, Pair<String, ValueAggregator>>();
        Preconditions.checkState((!segmentConfig.aggregateMetrics() ? 1 : 0) != 0, (Object)"aggregateMetrics cannot be enabled if AggregationConfig is set");
        for (AggregationConfig config : segmentConfig.getIngestionAggregationConfigs()) {
            ExpressionContext expressionContext = RequestContextUtils.getExpression((String)config.getAggregationFunction());
            Preconditions.checkState((expressionContext.getType() == ExpressionContext.Type.FUNCTION ? 1 : 0) != 0, (String)"aggregation function must be a function: %s", (Object)config);
            FunctionContext functionContext = expressionContext.getFunction();
            TableConfigUtils.validateIngestionAggregation(functionContext.getFunctionName());
            Preconditions.checkState((functionContext.getArguments().size() == 1 ? 1 : 0) != 0, (String)"aggregation function can only have one argument: %s", (Object)config);
            ExpressionContext argument = (ExpressionContext)functionContext.getArguments().get(0);
            Preconditions.checkState((argument.getType() == ExpressionContext.Type.IDENTIFIER ? 1 : 0) != 0, (String)"aggregator function argument must be a identifier: %s", (Object)config);
            AggregationFunctionType functionType = AggregationFunctionType.getAggregationFunctionType((String)functionContext.getFunctionName());
            columnNameToAggregator.put(config.getColumnName(), (Pair<String, ValueAggregator>)Pair.of((Object)argument.getLiteral(), (Object)ValueAggregatorFactory.getValueAggregator(functionType)));
        }
        return columnNameToAggregator;
    }

    private class IndexContainer
    implements Closeable {
        final FieldSpec _fieldSpec;
        final PartitionFunction _partitionFunction;
        final Set<Integer> _partitions;
        final NumValuesInfo _numValuesInfo;
        final MutableForwardIndex _forwardIndex;
        final MutableDictionary _dictionary;
        final MutableInvertedIndex _invertedIndex;
        final RangeIndexReader _rangeIndex;
        final MutableH3Index _h3Index;
        final MutableTextIndex _textIndex;
        final MutableTextIndex _fstIndex;
        final MutableJsonIndex _jsonIndex;
        final BloomFilterReader _bloomFilter;
        final MutableNullValueVector _nullValueVector;
        final String _sourceColumn;
        final ValueAggregator _valueAggregator;
        volatile Comparable _minValue;
        volatile Comparable _maxValue;
        int _dictId = Integer.MIN_VALUE;
        int[] _dictIds;

        IndexContainer(@Nullable FieldSpec fieldSpec, @Nullable PartitionFunction partitionFunction, Set<Integer> partitions, NumValuesInfo numValuesInfo, @Nullable MutableForwardIndex forwardIndex, @Nullable MutableDictionary dictionary, @Nullable MutableInvertedIndex invertedIndex, @Nullable RangeIndexReader rangeIndex, @Nullable MutableTextIndex textIndex, @Nullable MutableTextIndex fstIndex, @Nullable MutableJsonIndex jsonIndex, @Nullable MutableH3Index h3Index, @Nullable BloomFilterReader bloomFilter, @Nullable MutableNullValueVector nullValueVector, @Nullable String sourceColumn, ValueAggregator valueAggregator) {
            this._fieldSpec = fieldSpec;
            this._partitionFunction = partitionFunction;
            this._partitions = partitions;
            this._numValuesInfo = numValuesInfo;
            this._forwardIndex = forwardIndex;
            this._dictionary = dictionary;
            this._invertedIndex = invertedIndex;
            this._rangeIndex = rangeIndex;
            this._h3Index = h3Index;
            this._textIndex = textIndex;
            this._fstIndex = fstIndex;
            this._jsonIndex = jsonIndex;
            this._bloomFilter = bloomFilter;
            this._nullValueVector = nullValueVector;
            this._sourceColumn = sourceColumn;
            this._valueAggregator = valueAggregator;
        }

        DataSource toDataSource() {
            return new MutableDataSource(this._fieldSpec, MutableSegmentImpl.this._numDocsIndexed, this._numValuesInfo._numValues, this._numValuesInfo._maxNumValuesPerMVEntry, this._partitionFunction, this._partitions, this._minValue, this._maxValue, (ForwardIndexReader)this._forwardIndex, (Dictionary)this._dictionary, (InvertedIndexReader)this._invertedIndex, this._rangeIndex, (TextIndexReader)this._textIndex, (TextIndexReader)this._fstIndex, (JsonIndexReader)this._jsonIndex, this._h3Index, this._bloomFilter, this._nullValueVector);
        }

        @Override
        public void close() {
            String column = this._fieldSpec.getName();
            try {
                this._forwardIndex.close();
            }
            catch (Exception e) {
                MutableSegmentImpl.this._logger.error("Caught exception while closing forward index for column: {}, continuing with error", (Object)column, (Object)e);
            }
            if (this._dictionary != null) {
                try {
                    this._dictionary.close();
                }
                catch (Exception e) {
                    MutableSegmentImpl.this._logger.error("Caught exception while closing dictionary for column: {}, continuing with error", (Object)column, (Object)e);
                }
            }
            if (this._invertedIndex != null) {
                try {
                    this._invertedIndex.close();
                }
                catch (Exception e) {
                    MutableSegmentImpl.this._logger.error("Caught exception while closing inverted index for column: {}, continuing with error", (Object)column, (Object)e);
                }
            }
            if (this._rangeIndex != null) {
                try {
                    this._rangeIndex.close();
                }
                catch (Exception e) {
                    MutableSegmentImpl.this._logger.error("Caught exception while closing range index for column: {}, continuing with error", (Object)column, (Object)e);
                }
            }
            if (this._textIndex != null) {
                try {
                    this._textIndex.close();
                }
                catch (Exception e) {
                    MutableSegmentImpl.this._logger.error("Caught exception while closing text index for column: {}, continuing with error", (Object)column, (Object)e);
                }
            }
            if (this._fstIndex != null) {
                try {
                    this._fstIndex.close();
                }
                catch (Exception e) {
                    MutableSegmentImpl.this._logger.error("Caught exception while closing fst index for column: {}, continuing with error", (Object)column, (Object)e);
                }
            }
            if (this._jsonIndex != null) {
                try {
                    this._jsonIndex.close();
                }
                catch (Exception e) {
                    MutableSegmentImpl.this._logger.error("Caught exception while closing json index for column: {}, continuing with error", (Object)column, (Object)e);
                }
            }
            if (this._h3Index != null) {
                try {
                    this._h3Index.close();
                }
                catch (Exception e) {
                    MutableSegmentImpl.this._logger.error("Caught exception while closing H3 index for column: {}, continuing with error", (Object)column, (Object)e);
                }
            }
            if (this._bloomFilter != null) {
                try {
                    this._bloomFilter.close();
                }
                catch (Exception e) {
                    MutableSegmentImpl.this._logger.error("Caught exception while closing bloom filter for column: {}, continuing with error", (Object)column, (Object)e);
                }
            }
        }
    }

    private static class NumValuesInfo {
        volatile int _numValues = 0;
        volatile int _maxNumValuesPerMVEntry = -1;

        private NumValuesInfo() {
        }

        void updateSVEntry() {
            ++this._numValues;
        }

        void updateMVEntry(int numValuesInMVEntry) {
            this._numValues += numValuesInMVEntry;
            this._maxNumValuesPerMVEntry = Math.max(this._maxNumValuesPerMVEntry, numValuesInMVEntry);
        }
    }
}

