/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.dictionary;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.pinot.segment.local.realtime.impl.dictionary.BaseOnHeapMutableDictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class LongOnHeapMutableDictionary
extends BaseOnHeapMutableDictionary {
    private volatile long _min = Long.MAX_VALUE;
    private volatile long _max = Long.MIN_VALUE;

    public int index(Object value) {
        Long longValue = (Long)value;
        this.updateMinMax(longValue);
        return this.indexValue(longValue);
    }

    public int[] index(Object[] values) {
        int numValues = values.length;
        int[] dictIds = new int[numValues];
        for (int i = 0; i < numValues; ++i) {
            Long longValue = (Long)values[i];
            this.updateMinMax(longValue);
            dictIds[i] = this.indexValue(longValue);
        }
        return dictIds;
    }

    public int compare(int dictId1, int dictId2) {
        return Long.compare(this.getLongValue(dictId1), this.getLongValue(dictId2));
    }

    public IntSet getDictIdsInRange(String lower, String upper, boolean includeLower, boolean includeUpper) {
        int numValues = this.length();
        if (numValues == 0) {
            return IntSets.EMPTY_SET;
        }
        IntOpenHashSet dictIds = new IntOpenHashSet();
        if (lower.equals("*")) {
            long upperValue = Long.parseLong(upper);
            if (includeUpper) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    long value = this.getLongValue(dictId);
                    if (value > upperValue) continue;
                    dictIds.add(dictId);
                }
            } else {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    long value = this.getLongValue(dictId);
                    if (value >= upperValue) continue;
                    dictIds.add(dictId);
                }
            }
        } else if (upper.equals("*")) {
            long lowerValue = Long.parseLong(lower);
            if (includeLower) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    long value = this.getLongValue(dictId);
                    if (value < lowerValue) continue;
                    dictIds.add(dictId);
                }
            } else {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    long value = this.getLongValue(dictId);
                    if (value <= lowerValue) continue;
                    dictIds.add(dictId);
                }
            }
        } else {
            long lowerValue = Long.parseLong(lower);
            long upperValue = Long.parseLong(upper);
            if (includeLower && includeUpper) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    long value = this.getLongValue(dictId);
                    if (value < lowerValue || value > upperValue) continue;
                    dictIds.add(dictId);
                }
            } else if (includeLower) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    long value = this.getLongValue(dictId);
                    if (value < lowerValue || value >= upperValue) continue;
                    dictIds.add(dictId);
                }
            } else if (includeUpper) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    long value = this.getLongValue(dictId);
                    if (value <= lowerValue || value > upperValue) continue;
                    dictIds.add(dictId);
                }
            } else {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    long value = this.getLongValue(dictId);
                    if (value <= lowerValue || value >= upperValue) continue;
                    dictIds.add(dictId);
                }
            }
        }
        return dictIds;
    }

    public Long getMinVal() {
        return this._min;
    }

    public Long getMaxVal() {
        return this._max;
    }

    public long[] getSortedValues() {
        int numValues = this.length();
        long[] sortedValues = new long[numValues];
        for (int dictId = 0; dictId < numValues; ++dictId) {
            sortedValues[dictId] = this.getLongValue(dictId);
        }
        Arrays.sort(sortedValues);
        return sortedValues;
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.LONG;
    }

    public int indexOf(String stringValue) {
        return this.getDictId(Long.valueOf(stringValue));
    }

    public int indexOf(long longValue) {
        return this.getDictId(longValue);
    }

    public int getIntValue(int dictId) {
        return (int)this.getLongValue(dictId);
    }

    public long getLongValue(int dictId) {
        return (Long)this.get(dictId);
    }

    public float getFloatValue(int dictId) {
        return this.getLongValue(dictId);
    }

    public double getDoubleValue(int dictId) {
        return this.getLongValue(dictId);
    }

    public BigDecimal getBigDecimalValue(int dictId) {
        return BigDecimal.valueOf(this.getLongValue(dictId));
    }

    public String getStringValue(int dictId) {
        return Long.toString(this.getLongValue(dictId));
    }

    private void updateMinMax(long value) {
        if (value < this._min) {
            this._min = value;
        }
        if (value > this._max) {
            this._max = value;
        }
    }
}

