/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.fwd;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.pinot.segment.local.io.writer.impl.FixedByteSingleValueMultiColWriter;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.spi.data.FieldSpec;

public class SingleValueSortedForwardIndexCreator
implements ForwardIndexCreator {
    private final FixedByteSingleValueMultiColWriter _writer;
    private final int[] _minDocIds;
    private final int[] _maxDocIds;
    private int _nextDocId = 0;

    public SingleValueSortedForwardIndexCreator(File outputDir, String column, int cardinality) throws Exception {
        File indexFile = new File(outputDir, column + ".sv.sorted.fwd");
        this._writer = new FixedByteSingleValueMultiColWriter(indexFile, cardinality, 2, new int[]{4, 4});
        this._minDocIds = new int[cardinality];
        this._maxDocIds = new int[cardinality];
        Arrays.fill(this._minDocIds, Integer.MAX_VALUE);
        Arrays.fill(this._maxDocIds, Integer.MIN_VALUE);
    }

    public boolean isDictionaryEncoded() {
        return true;
    }

    public boolean isSingleValue() {
        return true;
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.INT;
    }

    public void putDictId(int dictId) {
        int docId;
        if (this._minDocIds[dictId] > (docId = this._nextDocId++)) {
            this._minDocIds[dictId] = docId;
        }
        if (this._maxDocIds[dictId] < docId) {
            this._maxDocIds[dictId] = docId;
        }
    }

    public void close() throws IOException {
        int cardinality = this._maxDocIds.length;
        try (FixedByteSingleValueMultiColWriter closeable = this._writer;){
            for (int i = 0; i < cardinality; ++i) {
                this._writer.setInt(i, 0, this._minDocIds[i]);
                this._writer.setInt(i, 1, this._maxDocIds[i]);
            }
        }
    }
}

