/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.nullvalue;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class NullValueVectorCreator
implements Closeable {
    private final MutableRoaringBitmap _nullBitmap = new MutableRoaringBitmap();
    private final File _nullValueVectorFile;

    public NullValueVectorCreator(File indexDir, String columnName) {
        this._nullValueVectorFile = new File(indexDir, columnName + ".bitmap.nullvalue");
    }

    public void setNull(int docId) {
        this._nullBitmap.add(docId);
    }

    public void seal() throws IOException {
        if (!this._nullBitmap.isEmpty()) {
            try (DataOutputStream outputStream = new DataOutputStream(new FileOutputStream(this._nullValueVectorFile));){
                this._nullBitmap.serialize((DataOutput)outputStream);
            }
        }
    }

    @VisibleForTesting
    ImmutableRoaringBitmap getNullBitmap() {
        return this._nullBitmap;
    }

    @Override
    public void close() {
    }
}

