/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.stats;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.creator.ColumnStatistics;
import org.apache.pinot.segment.spi.creator.StatsCollectorConfig;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.segment.spi.partition.PartitionFunctionFactory;
import org.apache.pinot.spi.data.FieldSpec;

public abstract class AbstractColumnStatisticsCollector
implements ColumnStatistics {
    protected static final int INITIAL_HASH_SET_SIZE = 1000;
    protected final FieldSpec _fieldSpec;
    private final Map<String, String> _partitionFunctionConfig;
    private final PartitionFunction _partitionFunction;
    private final int _numPartitions;
    private final Set<Integer> _partitions;
    protected int _totalNumberOfEntries = 0;
    protected int _maxNumberOfMultiValues = 0;
    protected boolean _sorted = true;
    private Comparable _previousValue = null;

    public AbstractColumnStatisticsCollector(String column, StatsCollectorConfig statsCollectorConfig) {
        this._fieldSpec = statsCollectorConfig.getFieldSpecForColumn(column);
        Preconditions.checkArgument((this._fieldSpec != null ? 1 : 0) != 0, (String)"Failed to find column: %s", (Object)column);
        if (!this._fieldSpec.isSingleValueField()) {
            this._sorted = false;
        }
        String partitionFunctionName = statsCollectorConfig.getPartitionFunctionName(column);
        this._numPartitions = statsCollectorConfig.getNumPartitions(column);
        this._partitionFunctionConfig = statsCollectorConfig.getPartitionFunctionConfig(column);
        this._partitionFunction = partitionFunctionName != null ? PartitionFunctionFactory.getPartitionFunction((String)partitionFunctionName, (int)this._numPartitions, this._partitionFunctionConfig) : null;
        this._partitions = this._partitionFunction != null ? new HashSet<Integer>() : null;
    }

    public int getMaxNumberOfMultiValues() {
        return this._maxNumberOfMultiValues;
    }

    protected void addressSorted(Comparable entry) {
        if (this._sorted) {
            this._sorted = this._previousValue == null || entry.compareTo(this._previousValue) >= 0;
            this._previousValue = entry;
        }
    }

    public boolean isSorted() {
        return this._sorted;
    }

    public abstract void collect(Object var1);

    public int getLengthOfShortestElement() {
        return -1;
    }

    public int getLengthOfLargestElement() {
        return -1;
    }

    public abstract void seal();

    public PartitionFunction getPartitionFunction() {
        return this._partitionFunction;
    }

    public int getNumPartitions() {
        return this._numPartitions;
    }

    @Nullable
    public Map<String, String> getPartitionFunctionConfig() {
        return this._partitionFunctionConfig;
    }

    @Nullable
    public Set<Integer> getPartitions() {
        return this._partitions;
    }

    protected void updatePartition(Object value) {
        if (this._partitionFunction != null) {
            this._partitions.add(this._partitionFunction.getPartition(value));
        }
    }

    void updateTotalNumberOfEntries(Object[] entries) {
        this._totalNumberOfEntries += entries.length;
    }

    public int getTotalNumberOfEntries() {
        return this._totalNumberOfEntries;
    }
}

