/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader;

import org.apache.pinot.segment.local.segment.index.loader.IndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.bloomfilter.BloomFilterHandler;
import org.apache.pinot.segment.local.segment.index.loader.invertedindex.FSTIndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.invertedindex.H3IndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.invertedindex.InvertedIndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.invertedindex.JsonIndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.invertedindex.RangeIndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.invertedindex.TextIndexHandler;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreatorProvider;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.store.ColumnIndexType;
import org.apache.pinot.segment.spi.store.SegmentDirectory;

public class IndexHandlerFactory {
    private static final IndexHandler NO_OP_HANDLER = new IndexHandler(){

        @Override
        public void updateIndices(SegmentDirectory.Writer segmentWriter, IndexCreatorProvider indexCreatorProvider) {
        }

        @Override
        public boolean needUpdateIndices(SegmentDirectory.Reader segmentReader) {
            return false;
        }
    };

    private IndexHandlerFactory() {
    }

    public static IndexHandler getIndexHandler(ColumnIndexType type, SegmentMetadataImpl segmentMetadata, IndexLoadingConfig indexLoadingConfig) {
        switch (type) {
            case INVERTED_INDEX: {
                return new InvertedIndexHandler((SegmentMetadata)segmentMetadata, indexLoadingConfig);
            }
            case RANGE_INDEX: {
                return new RangeIndexHandler((SegmentMetadata)segmentMetadata, indexLoadingConfig);
            }
            case TEXT_INDEX: {
                return new TextIndexHandler((SegmentMetadata)segmentMetadata, indexLoadingConfig);
            }
            case FST_INDEX: {
                return new FSTIndexHandler((SegmentMetadata)segmentMetadata, indexLoadingConfig);
            }
            case JSON_INDEX: {
                return new JsonIndexHandler((SegmentMetadata)segmentMetadata, indexLoadingConfig);
            }
            case H3_INDEX: {
                return new H3IndexHandler((SegmentMetadata)segmentMetadata, indexLoadingConfig);
            }
            case BLOOM_FILTER: {
                return new BloomFilterHandler((SegmentMetadata)segmentMetadata, indexLoadingConfig);
            }
        }
        return NO_OP_HANDLER;
    }
}

