/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.invertedindex;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.segment.index.loader.IndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.LoaderUtils;
import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.segment.local.utils.GeometrySerializer;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.creator.GeoSpatialIndexCreatorProvider;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.creator.IndexCreatorProvider;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.creator.GeoSpatialIndexCreator;
import org.apache.pinot.segment.spi.index.creator.H3IndexConfig;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.store.ColumnIndexType;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H3IndexHandler
implements IndexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(H3IndexHandler.class);
    private final SegmentMetadata _segmentMetadata;
    private final Map<String, H3IndexConfig> _h3Configs;

    public H3IndexHandler(SegmentMetadata segmentMetadata, IndexLoadingConfig indexLoadingConfig) {
        this._segmentMetadata = segmentMetadata;
        this._h3Configs = indexLoadingConfig.getH3IndexConfigs();
    }

    @Override
    public boolean needUpdateIndices(SegmentDirectory.Reader segmentReader) {
        String segmentName = this._segmentMetadata.getName();
        HashSet<String> columnsToAddIdx = new HashSet<String>(this._h3Configs.keySet());
        Set existingColumns = segmentReader.toSegmentDirectory().getColumnsWithIndex(ColumnIndexType.H3_INDEX);
        for (String column : existingColumns) {
            if (columnsToAddIdx.remove(column)) continue;
            LOGGER.info("Need to remove existing H3 index from segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        for (String column : columnsToAddIdx) {
            ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(column);
            if (!this.shouldCreateH3Index(columnMetadata)) continue;
            LOGGER.info("Need to create new H3 index for segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        return false;
    }

    @Override
    public void updateIndices(SegmentDirectory.Writer segmentWriter, IndexCreatorProvider indexCreatorProvider) throws Exception {
        HashSet<String> columnsToAddIdx = new HashSet<String>(this._h3Configs.keySet());
        String segmentName = this._segmentMetadata.getName();
        Set existingColumns = segmentWriter.toSegmentDirectory().getColumnsWithIndex(ColumnIndexType.H3_INDEX);
        for (String column : existingColumns) {
            if (columnsToAddIdx.remove(column)) continue;
            LOGGER.info("Removing existing H3 index from segment: {}, column: {}", (Object)segmentName, (Object)column);
            segmentWriter.removeIndex(column, ColumnIndexType.H3_INDEX);
            LOGGER.info("Removed existing H3 index from segment: {}, column: {}", (Object)segmentName, (Object)column);
        }
        for (String column : columnsToAddIdx) {
            ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(column);
            if (!this.shouldCreateH3Index(columnMetadata)) continue;
            this.createH3IndexForColumn(segmentWriter, columnMetadata, (GeoSpatialIndexCreatorProvider)indexCreatorProvider);
        }
    }

    private boolean shouldCreateH3Index(ColumnMetadata columnMetadata) {
        return columnMetadata != null;
    }

    private void createH3IndexForColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata, GeoSpatialIndexCreatorProvider indexCreatorProvider) throws Exception {
        File indexDir = this._segmentMetadata.getIndexDir();
        String segmentName = this._segmentMetadata.getName();
        String columnName = columnMetadata.getColumnName();
        File inProgress = new File(indexDir, columnName + ".h3.idx.inprogress");
        File h3IndexFile = new File(indexDir, columnName + ".h3.idx");
        if (!inProgress.exists()) {
            FileUtils.touch((File)inProgress);
        } else {
            FileUtils.deleteQuietly((File)h3IndexFile);
        }
        LOGGER.info("Creating new H3 index for segment: {}, column: {}", (Object)segmentName, (Object)columnName);
        Preconditions.checkState((columnMetadata.getDataType() == FieldSpec.DataType.BYTES ? 1 : 0) != 0, (Object)"H3 index can only be applied to BYTES columns");
        if (columnMetadata.hasDictionary()) {
            this.handleDictionaryBasedColumn(segmentWriter, columnMetadata, indexCreatorProvider);
        } else {
            this.handleNonDictionaryBasedColumn(segmentWriter, columnMetadata, indexCreatorProvider);
        }
        if (this._segmentMetadata.getVersion() == SegmentVersion.v3) {
            LoaderUtils.writeIndexToV3Format(segmentWriter, columnName, h3IndexFile, ColumnIndexType.H3_INDEX);
        }
        FileUtils.deleteQuietly((File)inProgress);
        LOGGER.info("Created H3 index for segment: {}, column: {}", (Object)segmentName, (Object)columnName);
    }

    private void handleDictionaryBasedColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata, GeoSpatialIndexCreatorProvider indexCreatorProvider) throws IOException {
        File indexDir = this._segmentMetadata.getIndexDir();
        String columnName = columnMetadata.getColumnName();
        try (ForwardIndexReader<?> forwardIndexReader = LoaderUtils.getForwardIndexReader((SegmentDirectory.Reader)segmentWriter, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();
             BaseImmutableDictionary dictionary = LoaderUtils.getDictionary((SegmentDirectory.Reader)segmentWriter, columnMetadata);
             GeoSpatialIndexCreator h3IndexCreator = indexCreatorProvider.newGeoSpatialIndexCreator(IndexCreationContext.builder().withIndexDir(indexDir).withColumnMetadata(columnMetadata).build().forGeospatialIndex(this._h3Configs.get(columnName)));){
            int numDocs = columnMetadata.getTotalDocs();
            for (int i = 0; i < numDocs; ++i) {
                int dictId = forwardIndexReader.getDictId(i, readerContext);
                h3IndexCreator.add(GeometrySerializer.deserialize(dictionary.getBytesValue(dictId)));
            }
            h3IndexCreator.seal();
        }
    }

    private void handleNonDictionaryBasedColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata, GeoSpatialIndexCreatorProvider indexCreatorProvider) throws Exception {
        File indexDir = this._segmentMetadata.getIndexDir();
        String columnName = columnMetadata.getColumnName();
        try (ForwardIndexReader<?> forwardIndexReader = LoaderUtils.getForwardIndexReader((SegmentDirectory.Reader)segmentWriter, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();
             GeoSpatialIndexCreator h3IndexCreator = indexCreatorProvider.newGeoSpatialIndexCreator(IndexCreationContext.builder().withIndexDir(indexDir).withColumnMetadata(columnMetadata).build().forGeospatialIndex(this._h3Configs.get(columnName)));){
            int numDocs = columnMetadata.getTotalDocs();
            for (int i = 0; i < numDocs; ++i) {
                h3IndexCreator.add(GeometrySerializer.deserialize(forwardIndexReader.getBytes(i, readerContext)));
            }
            h3IndexCreator.seal();
        }
    }
}

