/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.bloom;

import com.google.common.base.Preconditions;
import org.apache.pinot.segment.local.segment.index.readers.bloom.OffHeapGuavaBloomFilterReader;
import org.apache.pinot.segment.local.segment.index.readers.bloom.OnHeapGuavaBloomFilterReader;
import org.apache.pinot.segment.spi.index.reader.BloomFilterReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;

public class BloomFilterReaderFactory {
    private static final int TYPE_VALUE_OFFSET = 0;
    private static final int VERSION_OFFSET = 4;
    private static final int HEADER_SIZE = 8;

    private BloomFilterReaderFactory() {
    }

    public static BloomFilterReader getBloomFilterReader(PinotDataBuffer dataBuffer, boolean onHeap) {
        int typeValue = dataBuffer.getInt(0);
        int version = dataBuffer.getInt(4);
        Preconditions.checkState((typeValue == 1 && version == 1 ? 1 : 0) != 0, (String)"Unsupported bloom filter type value: %s and version: %s", (int)typeValue, (int)version);
        PinotDataBuffer bloomFilterDataBuffer = dataBuffer.view(8L, dataBuffer.size());
        return onHeap ? new OnHeapGuavaBloomFilterReader(bloomFilterDataBuffer) : new OffHeapGuavaBloomFilterReader(bloomFilterDataBuffer);
    }
}

