/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.readers;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.index.reader.NullValueVectorReader;

public class PinotSegmentColumnReader
implements Closeable {
    private final ForwardIndexReader _forwardIndexReader;
    private final ForwardIndexReaderContext _forwardIndexReaderContext;
    private final Dictionary _dictionary;
    private final NullValueVectorReader _nullValueVectorReader;
    private final int[] _dictIdBuffer;

    public PinotSegmentColumnReader(IndexSegment indexSegment, String column) {
        DataSource dataSource = indexSegment.getDataSource(column);
        Preconditions.checkArgument((dataSource != null ? 1 : 0) != 0, (String)"Failed to find data source for column: %s", (Object)column);
        this._forwardIndexReader = dataSource.getForwardIndex();
        this._forwardIndexReaderContext = this._forwardIndexReader.createContext();
        this._dictionary = dataSource.getDictionary();
        this._nullValueVectorReader = dataSource.getNullValueVector();
        this._dictIdBuffer = (int[])(this._forwardIndexReader.isSingleValue() ? null : new int[dataSource.getDataSourceMetadata().getMaxNumValuesPerMVEntry()]);
    }

    public PinotSegmentColumnReader(ForwardIndexReader forwardIndexReader, @Nullable Dictionary dictionary, @Nullable NullValueVectorReader nullValueVectorReader, int maxNumValuesPerMVEntry) {
        this._forwardIndexReader = forwardIndexReader;
        this._forwardIndexReaderContext = this._forwardIndexReader.createContext();
        this._dictionary = dictionary;
        this._nullValueVectorReader = nullValueVectorReader;
        this._dictIdBuffer = (int[])(this._forwardIndexReader.isSingleValue() ? null : new int[maxNumValuesPerMVEntry]);
    }

    public boolean isSingleValue() {
        return this._forwardIndexReader.isSingleValue();
    }

    public boolean hasDictionary() {
        return this._dictionary != null;
    }

    public Dictionary getDictionary() {
        return this._dictionary;
    }

    public int getDictId(int docId) {
        return this._forwardIndexReader.getDictId(docId, this._forwardIndexReaderContext);
    }

    public Object getValue(int docId) {
        if (this._dictionary != null) {
            if (this._forwardIndexReader.isSingleValue()) {
                return this._dictionary.get(this._forwardIndexReader.getDictId(docId, this._forwardIndexReaderContext));
            }
            int numValues = this._forwardIndexReader.getDictIdMV(docId, this._dictIdBuffer, this._forwardIndexReaderContext);
            Object[] values = new Object[numValues];
            for (int i = 0; i < numValues; ++i) {
                values[i] = this._dictionary.get(this._dictIdBuffer[i]);
            }
            return values;
        }
        assert (this._forwardIndexReader.isSingleValue());
        switch (this._forwardIndexReader.getStoredType()) {
            case INT: {
                return this._forwardIndexReader.getInt(docId, this._forwardIndexReaderContext);
            }
            case LONG: {
                return this._forwardIndexReader.getLong(docId, this._forwardIndexReaderContext);
            }
            case FLOAT: {
                return Float.valueOf(this._forwardIndexReader.getFloat(docId, this._forwardIndexReaderContext));
            }
            case DOUBLE: {
                return this._forwardIndexReader.getDouble(docId, this._forwardIndexReaderContext);
            }
            case BIG_DECIMAL: {
                return this._forwardIndexReader.getBigDecimal(docId, this._forwardIndexReaderContext);
            }
            case STRING: {
                return this._forwardIndexReader.getString(docId, this._forwardIndexReaderContext);
            }
            case BYTES: {
                return this._forwardIndexReader.getBytes(docId, this._forwardIndexReaderContext);
            }
        }
        throw new IllegalStateException();
    }

    public boolean isNull(int docId) {
        return this._nullValueVectorReader != null && this._nullValueVectorReader.isNull(docId);
    }

    @Override
    public void close() throws IOException {
        if (this._forwardIndexReaderContext != null) {
            this._forwardIndexReaderContext.close();
        }
    }
}

