/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils;

public class FPOrdering {
    private FPOrdering() {
    }

    public static long ordinalOf(double value) {
        if (value == Double.POSITIVE_INFINITY) {
            return -1L;
        }
        if (value == Double.NEGATIVE_INFINITY || Double.isNaN(value)) {
            return 0L;
        }
        long bits = Double.doubleToLongBits(value);
        bits = (bits & Long.MIN_VALUE) == Long.MIN_VALUE ? (bits == Long.MIN_VALUE ? Long.MIN_VALUE : bits ^ 0xFFFFFFFFFFFFFFFFL) : (bits ^= Long.MIN_VALUE);
        return bits;
    }

    public static long ordinalOf(float value) {
        if (value == Float.POSITIVE_INFINITY) {
            return 0xFFFFFFFFL;
        }
        if (value == Float.NEGATIVE_INFINITY || Float.isNaN(value)) {
            return 0L;
        }
        int bits = Float.floatToIntBits(value);
        bits = (bits & Integer.MIN_VALUE) == Integer.MIN_VALUE ? (bits == Integer.MIN_VALUE ? Integer.MIN_VALUE : ~bits) : (bits ^= Integer.MIN_VALUE);
        return (long)bits & 0xFFFFFFFFL;
    }
}

