/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst.automaton;

import java.io.Serializable;
import org.apache.pinot.segment.local.utils.nativefst.automaton.State;

public class Transition
implements Serializable,
Cloneable {
    static final long serialVersionUID = 40001L;
    public char _min;
    public char _max;
    public State _to;

    public Transition(char c, State to) {
        this._min = c;
        this._max = c;
        this._to = to;
    }

    public Transition(char min, char max, State to) {
        if (max < min) {
            char t = max;
            max = min;
            min = t;
        }
        this._min = min;
        this._max = max;
        this._to = to;
    }

    static void appendCharString(char c, StringBuilder b) {
        if (c >= '!' && c <= '~' && c != '\\' && c != '\"') {
            b.append(c);
        } else {
            b.append("\\u");
            String s = Integer.toHexString(c);
            if (c < '\u0010') {
                b.append("000").append(s);
            } else if (c < '\u0100') {
                b.append("00").append(s);
            } else if (c < '\u1000') {
                b.append("0").append(s);
            } else {
                b.append(s);
            }
        }
    }

    public State getDest() {
        return this._to;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Transition) {
            Transition t = (Transition)obj;
            return t._min == this._min && t._max == this._max && t._to == this._to;
        }
        return false;
    }

    public int hashCode() {
        return this._min * 2 + this._max * 3;
    }

    public Transition clone() {
        try {
            return (Transition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        Transition.appendCharString(this._min, b);
        if (this._min != this._max) {
            b.append("-");
            Transition.appendCharString(this._max, b);
        }
        b.append(" -> ").append(this._to._number);
        return b.toString();
    }
}

