/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.metrics;

import java.util.concurrent.atomic.LongAdder;

public final class MeanMetric {
    private final LongAdder counter = new LongAdder();
    private final LongAdder sum = new LongAdder();

    public void inc(long n) {
        this.counter.increment();
        this.sum.add(n);
    }

    public long count() {
        long count = this.counter.sum();
        assert (count >= 0L) : "Count of MeanMetric must always be non-negative; got " + count;
        return count;
    }

    public long sum() {
        return this.sum.sum();
    }

    public double mean() {
        long count = this.count();
        if (count > 0L) {
            return (double)this.sum.sum() / (double)count;
        }
        return 0.0;
    }
}

