/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.trino.sql.tree;

import coral.shading.com.google.common.collect.ImmutableList;
import coral.shading.io.trino.sql.tree.AstVisitor;
import coral.shading.io.trino.sql.tree.Expression;
import coral.shading.io.trino.sql.tree.Node;
import coral.shading.io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class NotExpression
extends Expression {
    private final Expression value;

    public NotExpression(Expression value) {
        this(Optional.empty(), value);
    }

    public NotExpression(NodeLocation location, Expression value) {
        this(Optional.of(location), value);
    }

    private NotExpression(Optional<NodeLocation> location, Expression value) {
        super(location);
        Objects.requireNonNull(value, "value is null");
        this.value = value;
    }

    public Expression getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitNotExpression(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of(this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotExpression that = (NotExpression)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean shallowEquals(Node other) {
        return NotExpression.sameClass(this, other);
    }
}

