/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.trino.sql.tree;

import coral.shading.com.google.common.base.MoreObjects;
import coral.shading.com.google.common.collect.ImmutableList;
import coral.shading.io.trino.sql.tree.AstVisitor;
import coral.shading.io.trino.sql.tree.Expression;
import coral.shading.io.trino.sql.tree.Identifier;
import coral.shading.io.trino.sql.tree.Node;
import coral.shading.io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Property
extends Node {
    private final Identifier name;
    private final Expression value;

    public Property(Identifier name, Expression value) {
        this(Optional.empty(), name, value);
    }

    public Property(NodeLocation location, Identifier name, Expression value) {
        this(Optional.of(location), name, value);
    }

    private Property(Optional<NodeLocation> location, Identifier name, Expression value) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.value = Objects.requireNonNull(value, "value is null");
    }

    public Identifier getName() {
        return this.name;
    }

    public Expression getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitProperty(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of(this.name, this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Property other = (Property)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("value", this.value).toString();
    }
}

