/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class JdbcSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(JdbcSplit.class).instanceSize());
    private final Optional<String> additionalPredicate;
    private final TupleDomain<JdbcColumnHandle> dynamicFilter;

    public JdbcSplit(Optional<String> additionalPredicate) {
        this(additionalPredicate, (TupleDomain<JdbcColumnHandle>)TupleDomain.all());
    }

    @JsonCreator
    public JdbcSplit(@JsonProperty(value="additionalPredicate") Optional<String> additionalPredicate, @JsonProperty(value="dynamicFilter") TupleDomain<JdbcColumnHandle> dynamicFilter) {
        this.additionalPredicate = Objects.requireNonNull(additionalPredicate, "additionalPredicate is null");
        this.dynamicFilter = Objects.requireNonNull(dynamicFilter, "dynamicFilter is null");
    }

    public JdbcSplit withDynamicFilter(TupleDomain<JdbcColumnHandle> dynamicFilter) {
        return new JdbcSplit(this.additionalPredicate, dynamicFilter);
    }

    @JsonProperty
    public Optional<String> getAdditionalPredicate() {
        return this.additionalPredicate;
    }

    @JsonProperty
    public TupleDomain<JdbcColumnHandle> getDynamicFilter() {
        return this.dynamicFilter;
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public List<HostAddress> getAddresses() {
        return ImmutableList.of();
    }

    public Object getInfo() {
        return this;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf(this.additionalPredicate, SizeOf::estimatedSizeOf) + this.dynamicFilter.getRetainedSizeInBytes(JdbcColumnHandle::getRetainedSizeInBytes);
    }
}

