/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.phoenix5;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.plugin.jdbc.DefaultJdbcMetadata;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcNamedRelationHandle;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.mapping.IdentifierMapping;
import io.trino.plugin.phoenix5.MetadataUtil;
import io.trino.plugin.phoenix5.PhoenixClient;
import io.trino.plugin.phoenix5.PhoenixErrorCode;
import io.trino.plugin.phoenix5.PhoenixOutputTableHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.AggregationApplicationResult;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorTableSchema;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SortingProperty;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ComputedStatistics;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.phoenix.util.SchemaUtil;

public class PhoenixMetadata
extends DefaultJdbcMetadata {
    public static final String DEFAULT_SCHEMA = "default";
    private static final String ROWKEY = "ROWKEY";
    private final PhoenixClient phoenixClient;
    private final IdentifierMapping identifierMapping;

    @Inject
    public PhoenixMetadata(PhoenixClient phoenixClient, IdentifierMapping identifierMapping) {
        super((JdbcClient)phoenixClient, false);
        this.phoenixClient = Objects.requireNonNull(phoenixClient, "phoenixClient is null");
        this.identifierMapping = Objects.requireNonNull(identifierMapping, "identifierMapping is null");
    }

    public JdbcTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        return this.phoenixClient.getTableHandle(session, schemaTableName).map(JdbcTableHandle::asPlainTable).map(JdbcNamedRelationHandle::getRemoteTableName).map(remoteTableName -> new JdbcTableHandle(schemaTableName, new RemoteTableName(remoteTableName.getCatalogName(), Optional.ofNullable(MetadataUtil.toTrinoSchemaName(remoteTableName.getSchemaName().orElse(null))), remoteTableName.getTableName()), Optional.empty())).orElse(null);
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        List sortingProperties = (List)tableHandle.getSortOrder().map(properties -> (ImmutableList)properties.stream().map(item -> new SortingProperty((Object)item.getColumn(), item.getSortOrder())).collect(ImmutableList.toImmutableList())).orElse(ImmutableList.of());
        return new ConnectorTableProperties(TupleDomain.all(), Optional.empty(), Optional.empty(), Optional.empty(), sortingProperties);
    }

    public ConnectorTableSchema getTableSchema(ConnectorSession session, ConnectorTableHandle table) {
        JdbcTableHandle handle = (JdbcTableHandle)table;
        return new ConnectorTableSchema(PhoenixMetadata.getSchemaTableName((JdbcTableHandle)handle), (List)this.getColumnMetadata(session, handle).stream().map(ColumnMetadata::getColumnSchema).collect(ImmutableList.toImmutableList()));
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        JdbcTableHandle handle = (JdbcTableHandle)table;
        return new ConnectorTableMetadata(PhoenixMetadata.getSchemaTableName((JdbcTableHandle)handle), this.getColumnMetadata(session, handle), this.phoenixClient.getTableProperties(session, handle));
    }

    private List<ColumnMetadata> getColumnMetadata(ConnectorSession session, JdbcTableHandle handle) {
        return (List)this.phoenixClient.getColumns(session, handle).stream().filter(column -> !ROWKEY.equalsIgnoreCase(column.getColumnName())).map(JdbcColumnHandle::getColumnMetadata).collect(ImmutableList.toImmutableList());
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        Preconditions.checkArgument((boolean)properties.isEmpty(), (Object)"Can't have properties for schema creation");
        if (DEFAULT_SCHEMA.equalsIgnoreCase(schemaName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Can't create 'default' schema which maps to Phoenix empty schema");
        }
        this.phoenixClient.execute(session, String.format("CREATE SCHEMA %s", SchemaUtil.getEscapedArgument((String)this.toRemoteSchemaName(session, schemaName))));
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        if (DEFAULT_SCHEMA.equalsIgnoreCase(schemaName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Can't drop 'default' schema which maps to Phoenix empty schema");
        }
        this.phoenixClient.execute(session, String.format("DROP SCHEMA %s", SchemaUtil.getEscapedArgument((String)this.toRemoteSchemaName(session, schemaName))));
    }

    private String toRemoteSchemaName(ConnectorSession session, String schemaName) {
        String string;
        block8: {
            Connection connection = this.phoenixClient.getConnection(session);
            try {
                string = this.identifierMapping.toRemoteSchemaName(session.getIdentity(), connection, schemaName);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_METADATA_ERROR, "Couldn't get casing for the schema name", (Throwable)e);
                }
            }
            connection.close();
        }
        return string;
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        this.phoenixClient.beginCreateTable(session, tableMetadata);
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorTableLayout> layout, RetryMode retryMode) {
        if (retryMode != RetryMode.NO_RETRIES) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support query retries");
        }
        return this.phoenixClient.beginCreateTable(session, tableMetadata);
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    public boolean supportsMissingColumnsOnInsert() {
        return true;
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, RetryMode retryMode) {
        if (retryMode != RetryMode.NO_RETRIES) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support query retries");
        }
        JdbcTableHandle handle = (JdbcTableHandle)tableHandle;
        Optional<String> rowkeyColumn = this.phoenixClient.getColumns(session, handle).stream().map(JdbcColumnHandle::getColumnName).filter(ROWKEY::equalsIgnoreCase).findFirst();
        List columnHandles = (List)columns.stream().map(JdbcColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        RemoteTableName remoteTableName = handle.asPlainTable().getRemoteTableName();
        return new PhoenixOutputTableHandle(remoteTableName.getSchemaName().orElse(null), remoteTableName.getTableName(), (List)columnHandles.stream().map(JdbcColumnHandle::getColumnName).collect(ImmutableList.toImmutableList()), (List)columnHandles.stream().map(JdbcColumnHandle::getColumnType).collect(ImmutableList.toImmutableList()), Optional.of((List)columnHandles.stream().map(JdbcColumnHandle::getJdbcTypeHandle).collect(ImmutableList.toImmutableList())), rowkeyColumn);
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        if (column.getComment() != null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support adding columns with comments");
        }
        JdbcTableHandle handle = (JdbcTableHandle)tableHandle;
        RemoteTableName remoteTableName = handle.asPlainTable().getRemoteTableName();
        this.phoenixClient.execute(session, String.format("ALTER TABLE %s ADD %s %s", MetadataUtil.getEscapedTableName(remoteTableName.getSchemaName().orElse(null), remoteTableName.getTableName()), this.phoenixClient.quoted(column.getName()), this.phoenixClient.toWriteMapping(session, column.getType()).getDataType()));
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        JdbcTableHandle handle = (JdbcTableHandle)tableHandle;
        JdbcColumnHandle columnHandle = (JdbcColumnHandle)column;
        RemoteTableName remoteTableName = handle.asPlainTable().getRemoteTableName();
        this.phoenixClient.execute(session, String.format("ALTER TABLE %s DROP COLUMN %s", MetadataUtil.getEscapedTableName(remoteTableName.getSchemaName().orElse(null), remoteTableName.getTableName()), this.phoenixClient.quoted(columnHandle.getColumnName())));
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        boolean hasRowkey = this.getColumnHandles(session, tableHandle).values().stream().map(JdbcColumnHandle.class::cast).map(JdbcColumnHandle::getColumnName).anyMatch(ROWKEY::equals);
        if (hasRowkey) {
            JdbcTableHandle jdbcHandle = (JdbcTableHandle)tableHandle;
            RemoteTableName remoteTableName = jdbcHandle.asPlainTable().getRemoteTableName();
            this.phoenixClient.execute(session, String.format("DROP SEQUENCE %s", MetadataUtil.getEscapedTableName(remoteTableName.getSchemaName().orElse(null), remoteTableName.getTableName() + "_sequence")));
        }
        this.phoenixClient.dropTable(session, (JdbcTableHandle)tableHandle);
    }

    public void truncateTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support truncating tables");
    }

    public Optional<AggregationApplicationResult<ConnectorTableHandle>> applyAggregation(ConnectorSession session, ConnectorTableHandle table, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        return Optional.empty();
    }
}

