/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.phoenix5;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.phoenix5.PhoenixConfig;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;
import javax.inject.Inject;

public final class PhoenixSessionProperties
implements SessionPropertiesProvider {
    public static final String MAX_SCANS_PER_SPLIT = "max_scans_per_split";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public PhoenixSessionProperties(PhoenixConfig phoenixConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.integerProperty((String)MAX_SCANS_PER_SPLIT, (String)"Maximum number of HBase scans per split", (Integer)phoenixConfig.getMaxScansPerSplit(), PhoenixSessionProperties::validateScansPerSplit, (boolean)false));
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    private static void validateScansPerSplit(int maxScansPerSplit) {
        if (maxScansPerSplit < 1) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be greater than 0: %s", MAX_SCANS_PER_SPLIT, maxScansPerSplit));
        }
        if (maxScansPerSplit > 1000) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s cannot exceed %s: %s", MAX_SCANS_PER_SPLIT, 1000, maxScansPerSplit));
        }
    }
}

