/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.msdcommon.datamodel;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.helix.msdcommon.datamodel.MetadataStoreRoutingData;
import org.apache.helix.msdcommon.exception.InvalidRoutingDataException;
import org.apache.helix.msdcommon.util.ZkValidationUtil;

public class TrieRoutingData
implements MetadataStoreRoutingData {
    private static final String DELIMITER = "/";
    private final TrieNode _rootNode;

    public TrieRoutingData(Map<String, List<String>> routingData) throws InvalidRoutingDataException {
        if (routingData == null || routingData.isEmpty()) {
            throw new InvalidRoutingDataException("routingData cannot be null or empty");
        }
        if (!this.containsShardingKey(routingData)) {
            throw new InvalidRoutingDataException("routingData needs at least 1 sharding key");
        }
        if (this.isRootShardingKey(routingData)) {
            Map.Entry<String, List<String>> entry = routingData.entrySet().iterator().next();
            this._rootNode = new TrieNode(Collections.emptyMap(), DELIMITER, true, entry.getKey());
        } else {
            this._rootNode = new TrieNode(new HashMap<String, TrieNode>(), DELIMITER, false, "");
            this.constructTrie(routingData);
        }
    }

    @Override
    public Map<String, String> getAllMappingUnderPath(String path) throws IllegalArgumentException {
        if (!ZkValidationUtil.isPathValid(path)) {
            throw new IllegalArgumentException("Provided path is not a valid Zookeeper path: " + path);
        }
        TrieNode curNode = this.getLongestPrefixNodeAlongPath(path);
        if (!curNode.getPath().equals(path)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        ArrayDeque<TrieNode> nodeStack = new ArrayDeque<TrieNode>();
        nodeStack.push(curNode);
        while (!nodeStack.isEmpty()) {
            curNode = (TrieNode)nodeStack.pop();
            if (curNode.isShardingKey()) {
                resultMap.put(curNode.getPath(), curNode.getRealmAddress());
                continue;
            }
            for (TrieNode child : curNode.getChildren().values()) {
                nodeStack.push(child);
            }
        }
        return resultMap;
    }

    @Override
    public String getMetadataStoreRealm(String path) throws IllegalArgumentException, NoSuchElementException {
        if (!ZkValidationUtil.isPathValid(path)) {
            throw new IllegalArgumentException("Provided path is not a valid Zookeeper path: " + path);
        }
        TrieNode node = this.getLongestPrefixNodeAlongPath(path);
        if (!node.isShardingKey()) {
            throw new NoSuchElementException("No sharding key found within the provided path. Path: " + path);
        }
        return node.getRealmAddress();
    }

    @Override
    public String getShardingKeyInPath(String path) throws IllegalArgumentException, NoSuchElementException {
        if (!ZkValidationUtil.isPathValid(path)) {
            throw new IllegalArgumentException("Provided path is not a valid Zookeeper path: " + path);
        }
        TrieNode node = this.getLongestPrefixNodeAlongPath(path);
        if (!node.isShardingKey()) {
            throw new NoSuchElementException("No sharding key found within the provided path. Path: " + path);
        }
        return node.getPath();
    }

    @Override
    public boolean isShardingKeyInsertionValid(String shardingKey) {
        if (!ZkValidationUtil.isPathValid(shardingKey)) {
            throw new IllegalArgumentException("Provided shardingKey is not a valid Zookeeper path: " + shardingKey);
        }
        TrieNode node = this.getLongestPrefixNodeAlongPath(shardingKey);
        return !node.isShardingKey() && !node.getPath().equals(shardingKey);
    }

    @Override
    public boolean containsKeyRealmPair(String shardingKey, String realmAddress) {
        if (!ZkValidationUtil.isPathValid(shardingKey)) {
            throw new IllegalArgumentException("Provided shardingKey is not a valid Zookeeper path: " + shardingKey);
        }
        TrieNode node = this.getLongestPrefixNodeAlongPath(shardingKey);
        return node.getPath().equals(shardingKey) && node.getRealmAddress().equals(realmAddress);
    }

    private TrieNode getLongestPrefixNodeAlongPath(String path) {
        if (path.equals(DELIMITER)) {
            return this._rootNode;
        }
        TrieNode curNode = this._rootNode;
        for (String pathSection : path.substring(1).split(DELIMITER, 0)) {
            TrieNode nextNode = curNode.getChildren().get(pathSection);
            if (nextNode == null) {
                return curNode;
            }
            curNode = nextNode;
        }
        return curNode;
    }

    private boolean containsShardingKey(Map<String, List<String>> routingData) {
        for (Map.Entry<String, List<String>> entry : routingData.entrySet()) {
            if (entry.getValue().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean isRootShardingKey(Map<String, List<String>> routingData) {
        Iterator<List<String>> iterator;
        if (routingData.size() == 1 && (iterator = routingData.values().iterator()).hasNext()) {
            List<String> shardingKeys = iterator.next();
            return shardingKeys.size() == 1 && shardingKeys.get(0).equals(DELIMITER);
        }
        return false;
    }

    private void constructTrie(Map<String, List<String>> routingData) throws InvalidRoutingDataException {
        for (Map.Entry<String, List<String>> entry : routingData.entrySet()) {
            for (String shardingKey : entry.getValue()) {
                if (!ZkValidationUtil.isPathValid(shardingKey)) {
                    throw new InvalidRoutingDataException("Sharding key is not a valid Zookeeper path: " + shardingKey);
                }
                if (shardingKey.equals(DELIMITER)) {
                    throw new InvalidRoutingDataException("There exist other sharding keys. Root cannot be a sharding key.");
                }
                int nextDelimiterIndex = shardingKey.indexOf(DELIMITER, 1);
                int prevDelimiterIndex = 0;
                String keySection = shardingKey.substring(prevDelimiterIndex + 1, nextDelimiterIndex > 0 ? nextDelimiterIndex : shardingKey.length());
                TrieNode curNode = this._rootNode;
                TrieNode nextNode = curNode.getChildren().get(keySection);
                while (nextDelimiterIndex > 0) {
                    if (nextNode != null && nextNode.isShardingKey()) {
                        throw new InvalidRoutingDataException(shardingKey + " cannot be a sharding key because " + shardingKey.substring(0, nextDelimiterIndex) + " is its parent key and is also a sharding key.");
                    }
                    if (nextNode == null) {
                        nextNode = new TrieNode(new HashMap<String, TrieNode>(), shardingKey.substring(0, nextDelimiterIndex), false, "");
                        curNode.addChild(keySection, nextNode);
                    }
                    keySection = shardingKey.substring(prevDelimiterIndex + 1, (nextDelimiterIndex = shardingKey.indexOf(DELIMITER, (prevDelimiterIndex = nextDelimiterIndex) + 1)) > 0 ? nextDelimiterIndex : shardingKey.length());
                    curNode = nextNode;
                    nextNode = curNode.getChildren().get(keySection);
                }
                if (nextNode != null) {
                    throw new InvalidRoutingDataException(shardingKey + " cannot be a sharding key because it is a parent key to another sharding key.");
                }
                nextNode = new TrieNode(new HashMap<String, TrieNode>(), shardingKey, true, entry.getKey());
                curNode.addChild(keySection, nextNode);
            }
        }
    }

    private static class TrieNode {
        private Map<String, TrieNode> _children;
        private final boolean _isShardingKey;
        private final String _path;
        private final String _realmAddress;

        TrieNode(Map<String, TrieNode> children, String path, boolean isShardingKey, String realmAddress) {
            this._children = children;
            this._isShardingKey = isShardingKey;
            this._path = path;
            this._realmAddress = realmAddress;
        }

        public Map<String, TrieNode> getChildren() {
            return this._children;
        }

        public boolean isShardingKey() {
            return this._isShardingKey;
        }

        public String getPath() {
            return this._path;
        }

        public String getRealmAddress() {
            return this._realmAddress;
        }

        public void addChild(String key, TrieNode node) {
            this._children.put(key, node);
        }
    }
}

