/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kinesis;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.trino.plugin.kinesis.KinesisColumnHandle;
import io.trino.plugin.kinesis.KinesisConfig;
import io.trino.plugin.kinesis.KinesisInternalFieldDescription;
import io.trino.plugin.kinesis.KinesisStreamDescription;
import io.trino.plugin.kinesis.KinesisStreamFieldDescription;
import io.trino.plugin.kinesis.KinesisStreamFieldGroup;
import io.trino.plugin.kinesis.KinesisTableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.TableNotFoundException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public class KinesisMetadata
implements ConnectorMetadata {
    private final Supplier<Map<SchemaTableName, KinesisStreamDescription>> tableDescriptionSupplier;
    private final Set<KinesisInternalFieldDescription> internalFieldDescriptions;
    private final boolean isHideInternalColumns;

    @Inject
    public KinesisMetadata(KinesisConfig kinesisConfig, Supplier<Map<SchemaTableName, KinesisStreamDescription>> tableDescriptionSupplier, Set<KinesisInternalFieldDescription> internalFieldDescriptions) {
        this.isHideInternalColumns = kinesisConfig.isHideInternalColumns();
        this.tableDescriptionSupplier = Objects.requireNonNull(tableDescriptionSupplier, "tableDescriptionSupplier is null");
        this.internalFieldDescriptions = Objects.requireNonNull(internalFieldDescriptions, "internalFieldDescriptions is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return (List)this.tableDescriptionSupplier.get().keySet().stream().map(SchemaTableName::getSchemaName).collect(ImmutableList.toImmutableList());
    }

    public KinesisTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        KinesisStreamDescription table = this.tableDescriptionSupplier.get().get(schemaTableName);
        if (table == null) {
            throw new TableNotFoundException(schemaTableName);
        }
        return new KinesisTableHandle(schemaTableName.getSchemaName(), schemaTableName.getTableName(), table.getStreamName(), KinesisMetadata.getDataFormat(table.getMessage()), table.getMessage().getCompressionCodec());
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession connectorSession, ConnectorTableHandle tableHandle) {
        return this.getTableMetadata(((KinesisTableHandle)tableHandle).toSchemaTableName());
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        return new ConnectorTableProperties();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SchemaTableName tableName : this.tableDescriptionSupplier.get().keySet()) {
            if (!schemaName.isEmpty() && !tableName.getSchemaName().equals(schemaName.get())) continue;
            builder.add((Object)tableName);
        }
        return builder.build();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession connectorSession, ConnectorTableHandle tableHandle) {
        List<KinesisStreamFieldDescription> fields;
        KinesisTableHandle kinesisTableHandle = (KinesisTableHandle)tableHandle;
        KinesisStreamDescription kinesisStreamDescription = this.tableDescriptionSupplier.get().get(kinesisTableHandle.toSchemaTableName());
        if (kinesisStreamDescription == null) {
            throw new TableNotFoundException(kinesisTableHandle.toSchemaTableName());
        }
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        int index = 0;
        KinesisStreamFieldGroup message = kinesisStreamDescription.getMessage();
        if (message != null && (fields = message.getFields()) != null) {
            for (KinesisStreamFieldDescription kinesisStreamFieldDescription : fields) {
                columnHandles.put((Object)kinesisStreamFieldDescription.getName(), (Object)kinesisStreamFieldDescription.getColumnHandle(index++));
            }
        }
        for (KinesisInternalFieldDescription kinesisInternalFieldDescription : this.internalFieldDescriptions) {
            columnHandles.put((Object)kinesisInternalFieldDescription.getColumnName(), (Object)kinesisInternalFieldDescription.getColumnHandle(index++, this.isHideInternalColumns));
        }
        return columnHandles.buildOrThrow();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession connectorSession, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        KinesisColumnHandle kinesisColumnHandle = (KinesisColumnHandle)columnHandle;
        return kinesisColumnHandle.getColumnMetadata();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        ImmutableList tableNames = prefix.getSchema().isPresent() && prefix.getTable().isPresent() ? ImmutableList.of((Object)new SchemaTableName((String)prefix.getSchema().get(), (String)prefix.getTable().get())) : this.listTables(session, Optional.empty());
        for (SchemaTableName tableName : tableNames) {
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(tableName);
            if (tableMetadata == null) continue;
            columns.put((Object)tableName, (Object)tableMetadata.getColumns());
        }
        return columns.buildOrThrow();
    }

    private static String getDataFormat(KinesisStreamFieldGroup fieldGroup) {
        return fieldGroup == null ? "dummy" : fieldGroup.getDataFormat();
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName schemaTableName) {
        List<KinesisStreamFieldDescription> fields;
        KinesisStreamDescription kinesisStreamDescription = this.tableDescriptionSupplier.get().get(schemaTableName);
        if (kinesisStreamDescription == null) {
            throw new TableNotFoundException(schemaTableName);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        KinesisStreamFieldGroup message = kinesisStreamDescription.getMessage();
        if (message != null && (fields = message.getFields()) != null) {
            for (KinesisStreamFieldDescription fieldDescription : fields) {
                builder.add((Object)fieldDescription.getColumnMetadata());
            }
        }
        for (KinesisInternalFieldDescription fieldDescription : this.internalFieldDescriptions) {
            builder.add((Object)fieldDescription.getColumnMetadata(this.isHideInternalColumns));
        }
        return new ConnectorTableMetadata(schemaTableName, (List)builder.build());
    }
}

