/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kinesis;

import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.trino.plugin.kinesis.KinesisConfig;
import io.trino.plugin.kinesis.KinesisErrorCode;
import io.trino.plugin.kinesis.KinesisStreamDescription;
import io.trino.plugin.kinesis.s3config.S3TableConfigClient;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaTableName;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.PreDestroy;

public class KinesisTableDescriptionSupplier
implements Supplier<Map<SchemaTableName, KinesisStreamDescription>> {
    private static final Logger log = Logger.get(KinesisTableDescriptionSupplier.class);
    private final String tableDescriptionLocation;
    private final String defaultSchema;
    private final JsonCodec<KinesisStreamDescription> streamDescriptionCodec;
    private final S3TableConfigClient s3TableConfigClient;

    @Inject
    public KinesisTableDescriptionSupplier(KinesisConfig kinesisConfig, JsonCodec<KinesisStreamDescription> streamDescriptionCodec, S3TableConfigClient s3TableConfigClient) {
        Objects.requireNonNull(kinesisConfig, "kinesisConfig is null");
        this.tableDescriptionLocation = kinesisConfig.getTableDescriptionLocation();
        this.defaultSchema = kinesisConfig.getDefaultSchema();
        this.streamDescriptionCodec = Objects.requireNonNull(streamDescriptionCodec, "streamDescriptionCodec is null");
        this.s3TableConfigClient = Objects.requireNonNull(s3TableConfigClient, "s3TableConfigClient is null");
    }

    @Override
    public Map<SchemaTableName, KinesisStreamDescription> get() {
        if (this.s3TableConfigClient.isUsingS3()) {
            return this.s3TableConfigClient.getTablesFromS3();
        }
        return this.getTablesFromPath();
    }

    public Map<SchemaTableName, KinesisStreamDescription> getTablesFromPath() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        try {
            for (Path file : KinesisTableDescriptionSupplier.listFiles(Paths.get(this.tableDescriptionLocation, new String[0]))) {
                if (!Files.isRegularFile(file, new LinkOption[0]) || !file.getFileName().toString().endsWith("json")) continue;
                KinesisStreamDescription table = (KinesisStreamDescription)this.streamDescriptionCodec.fromJson(Files.readAllBytes(file));
                String schemaName = (String)MoreObjects.firstNonNull((Object)table.getSchemaName(), (Object)this.defaultSchema);
                log.debug("Kinesis table %s %s %s", new Object[]{schemaName, table.getTableName(), table});
                builder.put((Object)new SchemaTableName(schemaName, table.getTableName()), (Object)table);
            }
            ImmutableMap tableDefinitions = builder.buildOrThrow();
            log.debug("Loaded table definitions: %s", new Object[]{tableDefinitions.keySet()});
            return tableDefinitions;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @PreDestroy
    public void shutdown() {
        this.s3TableConfigClient.run();
    }

    private static List<Path> listFiles(Path path) {
        ImmutableList immutableList;
        block10: {
            if (path == null || !Files.isDirectory(path, new LinkOption[0])) {
                throw new TrinoException((ErrorCodeSupplier)KinesisErrorCode.KINESIS_METADATA_EXCEPTION, "Table description location does not exist or is not a directory");
            }
            DirectoryStream<Path> stream = Files.newDirectoryStream(path);
            try {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Path file : stream) {
                    builder.add((Object)file);
                }
                immutableList = builder.build();
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | DirectoryIteratorException e) {
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return immutableList;
    }
}

