/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.parquet.ChunkReader;
import io.trino.parquet.DiskRange;
import io.trino.parquet.ParquetDataSource;
import io.trino.parquet.ParquetDataSourceId;
import io.trino.parquet.ParquetReaderOptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractParquetDataSource
implements ParquetDataSource {
    private final ParquetDataSourceId id;
    private final long estimatedSize;
    private final ParquetReaderOptions options;
    private long readTimeNanos;
    private long readBytes;

    protected AbstractParquetDataSource(ParquetDataSourceId id, long estimatedSize, ParquetReaderOptions options) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.estimatedSize = estimatedSize;
        this.options = Objects.requireNonNull(options, "options is null");
    }

    protected Slice readTailInternal(int length) throws IOException {
        return this.readFully(this.estimatedSize - (long)length, length);
    }

    protected abstract void readInternal(long var1, byte[] var3, int var4, int var5) throws IOException;

    @Override
    public ParquetDataSourceId getId() {
        return this.id;
    }

    @Override
    public final long getReadBytes() {
        return this.readBytes;
    }

    @Override
    public final long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    @Override
    public final long getEstimatedSize() {
        return this.estimatedSize;
    }

    @Override
    public Slice readTail(int length) throws IOException {
        long start = System.nanoTime();
        Slice tailSlice = this.readTailInternal(length);
        this.readTimeNanos += System.nanoTime() - start;
        this.readBytes += (long)tailSlice.length();
        return tailSlice;
    }

    @Override
    public final Slice readFully(long position, int length) throws IOException {
        byte[] buffer = new byte[length];
        this.readFully(position, buffer, 0, length);
        return Slices.wrappedBuffer((byte[])buffer);
    }

    private void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        long start = System.nanoTime();
        this.readInternal(position, buffer, bufferOffset, bufferLength);
        this.readTimeNanos += System.nanoTime() - start;
        this.readBytes += (long)bufferLength;
    }

    @Override
    public final <K> ListMultimap<K, ChunkReader> planRead(ListMultimap<K, DiskRange> diskRanges) {
        Objects.requireNonNull(diskRanges, "diskRanges is null");
        if (diskRanges.isEmpty()) {
            return ImmutableListMultimap.of();
        }
        ImmutableListMultimap.Builder smallRangesBuilder = ImmutableListMultimap.builder();
        ImmutableListMultimap.Builder largeRangesBuilder = ImmutableListMultimap.builder();
        for (Map.Entry entry : diskRanges.entries()) {
            if ((long)((DiskRange)entry.getValue()).getLength() <= this.options.getMaxBufferSize().toBytes()) {
                smallRangesBuilder.put(entry);
                continue;
            }
            largeRangesBuilder.put(entry);
        }
        ImmutableListMultimap smallRanges = smallRangesBuilder.build();
        ImmutableListMultimap largeRanges = largeRangesBuilder.build();
        ImmutableListMultimap.Builder slices = ImmutableListMultimap.builder();
        slices.putAll(this.readSmallDiskRanges((ListMultimap<K, DiskRange>)smallRanges));
        slices.putAll(this.readLargeDiskRanges((ListMultimap<K, DiskRange>)largeRanges));
        slices.orderValuesBy(Comparator.comparingLong(ChunkReader::getDiskOffset));
        return slices.build();
    }

    private <K> ListMultimap<K, ChunkReader> readSmallDiskRanges(ListMultimap<K, DiskRange> diskRanges) {
        if (diskRanges.isEmpty()) {
            return ImmutableListMultimap.of();
        }
        List<DiskRange> mergedRanges = AbstractParquetDataSource.mergeAdjacentDiskRanges(diskRanges.values(), this.options.getMaxMergeDistance(), this.options.getMaxBufferSize());
        ImmutableListMultimap.Builder slices = ImmutableListMultimap.builder();
        for (final DiskRange mergedRange : mergedRanges) {
            final ReferenceCountedReader mergedRangeLoader = new ReferenceCountedReader(mergedRange);
            for (Map.Entry diskRangeEntry : diskRanges.entries()) {
                final DiskRange diskRange = (DiskRange)diskRangeEntry.getValue();
                if (!mergedRange.contains(diskRange)) continue;
                mergedRangeLoader.addReference();
                slices.put(diskRangeEntry.getKey(), (Object)new ChunkReader(){

                    @Override
                    public long getDiskOffset() {
                        return diskRange.getOffset();
                    }

                    @Override
                    public Slice read() throws IOException {
                        int offset = Math.toIntExact(diskRange.getOffset() - mergedRange.getOffset());
                        return mergedRangeLoader.read().slice(offset, diskRange.getLength());
                    }

                    @Override
                    public void free() {
                        mergedRangeLoader.free();
                    }
                });
            }
            mergedRangeLoader.free();
        }
        ImmutableListMultimap sliceStreams = slices.build();
        Verify.verify((boolean)sliceStreams.keySet().equals(diskRanges.keySet()));
        return sliceStreams;
    }

    private <K> ListMultimap<K, ChunkReader> readLargeDiskRanges(ListMultimap<K, DiskRange> diskRanges) {
        if (diskRanges.isEmpty()) {
            return ImmutableListMultimap.of();
        }
        ImmutableListMultimap.Builder slices = ImmutableListMultimap.builder();
        for (Map.Entry entry : diskRanges.entries()) {
            slices.put(entry.getKey(), (Object)new ReferenceCountedReader((DiskRange)entry.getValue()));
        }
        return slices.build();
    }

    private static List<DiskRange> mergeAdjacentDiskRanges(Collection<DiskRange> diskRanges, DataSize maxMergeDistance, DataSize maxReadSize) {
        ArrayList<DiskRange> ranges = new ArrayList<DiskRange>(diskRanges);
        ranges.sort(Comparator.comparingLong(DiskRange::getOffset));
        long maxReadSizeBytes = maxReadSize.toBytes();
        long maxMergeDistanceBytes = maxMergeDistance.toBytes();
        ImmutableList.Builder result = ImmutableList.builder();
        DiskRange last = (DiskRange)ranges.get(0);
        for (int i = 1; i < ranges.size(); ++i) {
            DiskRange current = (DiskRange)ranges.get(i);
            DiskRange merged = null;
            boolean blockTooLong = false;
            try {
                merged = last.span(current);
            }
            catch (ArithmeticException e) {
                blockTooLong = true;
            }
            if (!blockTooLong && (long)merged.getLength() <= maxReadSizeBytes && last.getEnd() + maxMergeDistanceBytes >= current.getOffset()) {
                last = merged;
                continue;
            }
            result.add((Object)last);
            last = current;
        }
        result.add((Object)last);
        return result.build();
    }

    private class ReferenceCountedReader
    implements ChunkReader {
        private final DiskRange range;
        private Slice data;
        private int referenceCount = 1;

        public ReferenceCountedReader(DiskRange range) {
            this.range = range;
        }

        public void addReference() {
            Preconditions.checkState((this.referenceCount > 0 ? 1 : 0) != 0, (Object)"Chunk reader is already closed");
            ++this.referenceCount;
        }

        @Override
        public long getDiskOffset() {
            return this.range.getOffset();
        }

        @Override
        public Slice read() throws IOException {
            Preconditions.checkState((this.referenceCount > 0 ? 1 : 0) != 0, (Object)"Chunk reader is already closed");
            if (this.data == null) {
                byte[] buffer = new byte[this.range.getLength()];
                AbstractParquetDataSource.this.readFully(this.range.getOffset(), buffer, 0, buffer.length);
                this.data = Slices.wrappedBuffer((byte[])buffer);
            }
            return this.data;
        }

        @Override
        public void free() {
            Preconditions.checkState((this.referenceCount > 0 ? 1 : 0) != 0, (Object)"Reference count is already 0");
            --this.referenceCount;
            if (this.referenceCount == 0) {
                this.data = null;
            }
        }
    }
}

