/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.valuewriter;

import io.airlift.slice.Slice;
import io.trino.parquet.writer.valuewriter.PrimitiveValueWriter;
import io.trino.spi.block.Block;
import io.trino.spi.type.UuidType;
import java.util.Objects;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveType;

public class UuidValueWriter
extends PrimitiveValueWriter {
    private final ValuesWriter valuesWriter;

    public UuidValueWriter(ValuesWriter valuesWriter, PrimitiveType parquetType) {
        super(parquetType, valuesWriter);
        this.valuesWriter = Objects.requireNonNull(valuesWriter, "valuesWriter is null");
    }

    @Override
    public void write(Block block) {
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) continue;
            Slice slice = UuidType.UUID.getSlice(block, i);
            Binary binary = Binary.fromConstantByteArray((byte[])slice.getBytes());
            this.valuesWriter.writeBytes(binary);
            this.getStatistics().updateStats(binary);
        }
    }
}

