/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.com.microsoft.azure.storage.core;

import io.trino.hadoop.$internal.com.microsoft.azure.storage.StorageException;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.core.PathUtility;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class Canonicalizer {
    private static final int ExpectedBlobQueueCanonicalizedStringLength = 300;
    private static final int ExpectedTableCanonicalizedStringLength = 200;
    private static final Pattern CRLF = Pattern.compile("\r\n", 16);

    Canonicalizer() {
    }

    private static void addCanonicalizedHeaders(HttpURLConnection conn, StringBuilder canonicalizedString) {
        Map<String, List<String>> headers = conn.getRequestProperties();
        ArrayList<String> httpStorageHeaderNameArray = new ArrayList<String>();
        for (String key : headers.keySet()) {
            if (!key.toLowerCase(Utility.LOCALE_US).startsWith("x-ms-")) continue;
            httpStorageHeaderNameArray.add(key.toLowerCase(Utility.LOCALE_US));
        }
        Collections.sort(httpStorageHeaderNameArray);
        for (String key : httpStorageHeaderNameArray) {
            StringBuilder canonicalizedElement = new StringBuilder(key);
            String delimiter = ":";
            ArrayList<String> values = Canonicalizer.getHeaderValues(headers, key);
            boolean appendCanonicalizedElement = false;
            for (String value : values) {
                if (value != null) {
                    appendCanonicalizedElement = true;
                }
                String unfoldedValue = CRLF.matcher(value).replaceAll(Matcher.quoteReplacement(""));
                canonicalizedElement.append(delimiter);
                canonicalizedElement.append(unfoldedValue);
                delimiter = ",";
            }
            if (!appendCanonicalizedElement) continue;
            Canonicalizer.appendCanonicalizedElement(canonicalizedString, canonicalizedElement.toString());
        }
    }

    protected static void appendCanonicalizedElement(StringBuilder builder, String element) {
        builder.append("\n");
        builder.append(element);
    }

    protected static String canonicalizeHttpRequest(URL address, String accountName, String method, String contentType, long contentLength, String date, HttpURLConnection conn) throws StorageException {
        StringBuilder canonicalizedString = new StringBuilder(300);
        canonicalizedString.append(conn.getRequestMethod());
        Canonicalizer.appendCanonicalizedElement(canonicalizedString, Utility.getStandardHeaderValue(conn, "Content-Encoding"));
        Canonicalizer.appendCanonicalizedElement(canonicalizedString, Utility.getStandardHeaderValue(conn, "Content-Language"));
        Canonicalizer.appendCanonicalizedElement(canonicalizedString, contentLength <= 0L ? "" : String.valueOf(contentLength));
        Canonicalizer.appendCanonicalizedElement(canonicalizedString, Utility.getStandardHeaderValue(conn, "Content-MD5"));
        Canonicalizer.appendCanonicalizedElement(canonicalizedString, contentType != null ? contentType : "");
        String dateString = Utility.getStandardHeaderValue(conn, "x-ms-date");
        Canonicalizer.appendCanonicalizedElement(canonicalizedString, dateString.equals("") ? date : "");
        Canonicalizer.appendCanonicalizedElement(canonicalizedString, Utility.getStandardHeaderValue(conn, "If-Modified-Since"));
        Canonicalizer.appendCanonicalizedElement(canonicalizedString, Utility.getStandardHeaderValue(conn, "If-Match"));
        Canonicalizer.appendCanonicalizedElement(canonicalizedString, Utility.getStandardHeaderValue(conn, "If-None-Match"));
        Canonicalizer.appendCanonicalizedElement(canonicalizedString, Utility.getStandardHeaderValue(conn, "If-Unmodified-Since"));
        Canonicalizer.appendCanonicalizedElement(canonicalizedString, Utility.getStandardHeaderValue(conn, "Range"));
        Canonicalizer.addCanonicalizedHeaders(conn, canonicalizedString);
        Canonicalizer.appendCanonicalizedElement(canonicalizedString, Canonicalizer.getCanonicalizedResource(address, accountName));
        return canonicalizedString.toString();
    }

    protected static String canonicalizeTableHttpRequest(URL address, String accountName, String method, String contentType, long contentLength, String date, HttpURLConnection conn) throws StorageException {
        StringBuilder canonicalizedString = new StringBuilder(200);
        canonicalizedString.append(conn.getRequestMethod());
        String httpContentMD5Value = Utility.getStandardHeaderValue(conn, "Content-MD5");
        Canonicalizer.appendCanonicalizedElement(canonicalizedString, httpContentMD5Value);
        Canonicalizer.appendCanonicalizedElement(canonicalizedString, contentType);
        String dateString = Utility.getStandardHeaderValue(conn, "x-ms-date");
        Canonicalizer.appendCanonicalizedElement(canonicalizedString, dateString.equals("") ? date : dateString);
        Canonicalizer.appendCanonicalizedElement(canonicalizedString, Canonicalizer.getCanonicalizedResourceLite(address, accountName));
        return canonicalizedString.toString();
    }

    protected static String getCanonicalizedResource(URL address, String accountName) throws StorageException {
        StringBuilder resourcepath = new StringBuilder("/");
        resourcepath.append(accountName);
        resourcepath.append(address.getPath());
        StringBuilder canonicalizedResource = new StringBuilder(resourcepath.toString());
        if (address.getQuery() == null || !address.getQuery().contains("=")) {
            return canonicalizedResource.toString();
        }
        HashMap<String, String[]> queryVariables = PathUtility.parseQueryString(address.getQuery());
        HashMap<String, String> lowercasedKeyNameValue = new HashMap<String, String>();
        for (Map.Entry entry : queryVariables.entrySet()) {
            List<Object> sortedValues = Arrays.asList((Object[])entry.getValue());
            Collections.sort(sortedValues);
            StringBuilder stringValue = new StringBuilder();
            for (String string : sortedValues) {
                if (stringValue.length() > 0) {
                    stringValue.append(",");
                }
                stringValue.append(string);
            }
            lowercasedKeyNameValue.put(entry.getKey() == null ? null : ((String)entry.getKey()).toLowerCase(Utility.LOCALE_US), stringValue.toString());
        }
        ArrayList sortedKeys = new ArrayList(lowercasedKeyNameValue.keySet());
        Collections.sort(sortedKeys);
        for (String key : sortedKeys) {
            StringBuilder queryParamString = new StringBuilder();
            queryParamString.append(key);
            queryParamString.append(":");
            queryParamString.append((String)lowercasedKeyNameValue.get(key));
            Canonicalizer.appendCanonicalizedElement(canonicalizedResource, queryParamString.toString());
        }
        return canonicalizedResource.toString();
    }

    protected static String getCanonicalizedResourceLite(URL address, String accountName) throws StorageException {
        StringBuilder resourcepath = new StringBuilder("/");
        resourcepath.append(accountName);
        resourcepath.append(address.getPath());
        StringBuilder canonicalizedResource = new StringBuilder(resourcepath.toString());
        HashMap<String, String[]> queryVariables = PathUtility.parseQueryString(address.getQuery());
        String[] compVals = (String[])queryVariables.get("comp");
        if (compVals != null) {
            List<String> sortedValues = Arrays.asList(compVals);
            Collections.sort(sortedValues);
            canonicalizedResource.append("?comp=");
            StringBuilder stringValue = new StringBuilder();
            for (String value : sortedValues) {
                if (stringValue.length() > 0) {
                    stringValue.append(",");
                }
                stringValue.append(value);
            }
            canonicalizedResource.append((CharSequence)stringValue);
        }
        return canonicalizedResource.toString();
    }

    private static ArrayList<String> getHeaderValues(Map<String, List<String>> headers, String headerName) {
        ArrayList<String> arrayOfValues = new ArrayList<String>();
        List<String> values = null;
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            if (!entry.getKey().toLowerCase(Utility.LOCALE_US).equals(headerName)) continue;
            values = entry.getValue();
            break;
        }
        if (values != null) {
            for (String value : values) {
                arrayOfValues.add(Utility.trimStart(value));
            }
        }
        return arrayOfValues;
    }

    protected abstract String canonicalize(HttpURLConnection var1, String var2, Long var3) throws StorageException;
}

