/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.htrace.core;

import io.trino.hadoop.$internal.htrace.core.AlwaysSampler;
import io.trino.hadoop.$internal.htrace.core.HTraceConfiguration;
import io.trino.hadoop.$internal.htrace.core.NeverSampler;
import io.trino.hadoop.$internal.htrace.shaded.commons.logging.Log;
import io.trino.hadoop.$internal.htrace.shaded.commons.logging.LogFactory;
import java.lang.reflect.Constructor;

public abstract class Sampler {
    public static final Sampler ALWAYS = AlwaysSampler.INSTANCE;
    public static final Sampler NEVER = NeverSampler.INSTANCE;

    public abstract boolean next();

    public static class Builder {
        private static final Log LOG = LogFactory.getLog(Builder.class);
        private static final String DEFAULT_PACKAGE = "io.trino.hadoop.$internal.htrace.core";
        private final HTraceConfiguration conf;
        private String className;
        private ClassLoader classLoader = Builder.class.getClassLoader();

        public Builder(HTraceConfiguration conf) {
            this.conf = conf;
            this.reset();
        }

        public Builder reset() {
            this.className = null;
            return this;
        }

        public Builder className(String className) {
            this.className = className;
            return this;
        }

        public Builder classLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        private void throwError(String errorStr) {
            LOG.error(errorStr);
            throw new RuntimeException(errorStr);
        }

        private void throwError(String errorStr, Throwable e) {
            LOG.error(errorStr, e);
            throw new RuntimeException(errorStr, e);
        }

        public Sampler build() {
            Sampler sampler = this.newSampler();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Created new sampler of type " + sampler.getClass().getName(), new Exception());
            }
            return sampler;
        }

        private Sampler newSampler() {
            String str;
            if (this.className == null || this.className.isEmpty()) {
                this.throwError("No sampler class specified.");
            }
            if (!(str = this.className).contains(".")) {
                str = "io.trino.hadoop.$internal.htrace.core." + str;
            }
            Class<?> cls = null;
            try {
                cls = this.classLoader.loadClass(str);
            }
            catch (ClassNotFoundException e) {
                this.throwError("Cannot find Sampler class " + str);
            }
            Constructor<?> ctor = null;
            try {
                ctor = cls.getConstructor(HTraceConfiguration.class);
            }
            catch (NoSuchMethodException e) {
                this.throwError("Cannot find a constructor for class " + str + "which takes an HTraceConfiguration.");
            }
            Sampler sampler = null;
            try {
                LOG.debug("Creating new instance of " + str + "...");
                sampler = (Sampler)ctor.newInstance(this.conf);
            }
            catch (ReflectiveOperationException e) {
                this.throwError("Reflection error when constructing " + str + ".", e);
            }
            catch (Throwable t) {
                this.throwError("NewInstance error when constructing " + str + ".", t);
            }
            return sampler;
        }
    }
}

