/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import javax.servlet.ServletContext;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.qjournal.server.GetJournalEditServlet;
import org.apache.hadoop.hdfs.qjournal.server.Journal;
import org.apache.hadoop.hdfs.qjournal.server.JournalNode;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.net.NetUtils;

@InterfaceAudience.Private
public class JournalNodeHttpServer {
    public static final String JN_ATTRIBUTE_KEY = "localjournal";
    private HttpServer2 httpServer;
    private final JournalNode localJournalNode;
    private InetSocketAddress httpAddress;
    private InetSocketAddress httpsAddress;
    private final InetSocketAddress bindAddress;
    private final Configuration conf;

    JournalNodeHttpServer(Configuration conf, JournalNode jn, InetSocketAddress bindAddress) {
        this.conf = conf;
        this.localJournalNode = jn;
        this.bindAddress = bindAddress;
    }

    void start() throws IOException {
        String bindHost;
        InetSocketAddress httpAddr = this.bindAddress;
        String httpsAddrString = this.conf.get("dfs.journalnode.https-address", "0.0.0.0:8481");
        InetSocketAddress httpsAddr = NetUtils.createSocketAddr(httpsAddrString);
        if (httpsAddr != null && (bindHost = this.conf.getTrimmed("dfs.journalnode.https-bind-host")) != null && !bindHost.isEmpty()) {
            httpsAddr = new InetSocketAddress(bindHost, httpsAddr.getPort());
        }
        HttpServer2.Builder builder = DFSUtil.httpServerTemplateForNNAndJN(this.conf, httpAddr, httpsAddr, "journal", "dfs.journalnode.kerberos.internal.spnego.principal", "dfs.journalnode.keytab.file");
        this.httpServer = builder.build();
        this.httpServer.setAttribute(JN_ATTRIBUTE_KEY, this.localJournalNode);
        this.httpServer.setAttribute("current.conf", this.conf);
        this.httpServer.addInternalServlet("getJournal", "/getJournal", GetJournalEditServlet.class, true);
        this.httpServer.start();
        HttpConfig.Policy policy = DFSUtil.getHttpPolicy(this.conf);
        int connIdx = 0;
        if (policy.isHttpEnabled()) {
            this.httpAddress = this.httpServer.getConnectorAddress(connIdx++);
            this.conf.set("dfs.journalnode.http-address", NetUtils.getHostPortString(this.httpAddress));
        }
        if (policy.isHttpsEnabled()) {
            this.httpsAddress = this.httpServer.getConnectorAddress(connIdx);
            this.conf.set("dfs.journalnode.https-address", NetUtils.getHostPortString(this.httpsAddress));
        }
    }

    void stop() throws IOException {
        if (this.httpServer != null) {
            try {
                this.httpServer.stop();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public InetSocketAddress getAddress() {
        assert (this.httpAddress != null || this.httpsAddress != null);
        return this.httpAddress != null ? this.httpAddress : this.httpsAddress;
    }

    public InetSocketAddress getHttpAddress() {
        return this.httpAddress;
    }

    public InetSocketAddress getHttpsAddress() {
        return this.httpsAddress;
    }

    URI getServerURI() {
        InetSocketAddress addr = this.httpServer.getConnectorAddress(0);
        return URI.create(DFSUtil.getHttpClientScheme(this.conf) + "://" + NetUtils.getHostPortString(addr));
    }

    public static Journal getJournalFromContext(ServletContext context, String jid) throws IOException {
        JournalNode jn = (JournalNode)context.getAttribute(JN_ATTRIBUTE_KEY);
        return jn.getOrCreateJournal(jid);
    }

    public static Configuration getConfFromContext(ServletContext context) {
        return (Configuration)context.getAttribute("current.conf");
    }
}

