/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.kudu.KuduClientSession;
import io.trino.plugin.kudu.KuduTableMapping;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.kudu.client.KuduTable;

public class KuduOutputTableHandle
implements ConnectorOutputTableHandle,
KuduTableMapping {
    private final SchemaTableName schemaTableName;
    private final boolean generateUUID;
    private final List<Type> columnTypes;
    private final List<Type> originalColumnTypes;
    private transient KuduTable table;

    @JsonCreator
    public KuduOutputTableHandle(@JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="originalColumnTypes") List<Type> originalColumnTypes, @JsonProperty(value="columnTypes") List<Type> columnTypes, @JsonProperty(value="generateUUID") boolean generateUUID) {
        this(schemaTableName, originalColumnTypes, columnTypes, generateUUID, null);
    }

    public KuduOutputTableHandle(SchemaTableName schemaTableName, List<Type> originalColumnTypes, List<Type> columnTypes, boolean generateUUID, KuduTable table) {
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        this.columnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnTypes, "columnTypes is null"));
        this.originalColumnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(originalColumnTypes, "originalColumnTypes is null"));
        this.generateUUID = generateUUID;
        this.table = table;
    }

    @JsonProperty
    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    @Override
    @JsonProperty
    public boolean isGenerateUUID() {
        return this.generateUUID;
    }

    @Override
    @JsonProperty
    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    @Override
    @JsonProperty
    public List<Type> getOriginalColumnTypes() {
        return this.originalColumnTypes;
    }

    public KuduTable getTable(KuduClientSession session) {
        if (this.table == null) {
            this.table = session.openTable(this.schemaTableName);
        }
        return this.table;
    }
}

