/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import com.google.common.base.Preconditions;
import io.trino.plugin.kudu.KuduClientSession;
import io.trino.plugin.kudu.KuduInsertTableHandle;
import io.trino.plugin.kudu.KuduMergeTableHandle;
import io.trino.plugin.kudu.KuduOutputTableHandle;
import io.trino.plugin.kudu.KuduPageSink;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMergeSink;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import java.util.Objects;
import javax.inject.Inject;

public class KuduPageSinkProvider
implements ConnectorPageSinkProvider {
    private final KuduClientSession clientSession;

    @Inject
    public KuduPageSinkProvider(KuduClientSession clientSession) {
        this.clientSession = Objects.requireNonNull(clientSession, "clientSession is null");
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle) {
        Objects.requireNonNull(outputTableHandle, "outputTableHandle is null");
        Preconditions.checkArgument((boolean)(outputTableHandle instanceof KuduOutputTableHandle), (Object)"outputTableHandle is not an instance of KuduOutputTableHandle");
        KuduOutputTableHandle handle = (KuduOutputTableHandle)outputTableHandle;
        return new KuduPageSink(session, this.clientSession, handle);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle) {
        Objects.requireNonNull(insertTableHandle, "insertTableHandle is null");
        Preconditions.checkArgument((boolean)(insertTableHandle instanceof KuduInsertTableHandle), (Object)"insertTableHandle is not an instance of KuduInsertTableHandle");
        KuduInsertTableHandle handle = (KuduInsertTableHandle)insertTableHandle;
        return new KuduPageSink(session, this.clientSession, handle);
    }

    public ConnectorMergeSink createMergeSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorMergeTableHandle mergeHandle) {
        return new KuduPageSink(session, this.clientSession, (KuduMergeTableHandle)mergeHandle);
    }
}

