/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import io.trino.plugin.kudu.KuduClientSession;
import io.trino.plugin.kudu.KuduRecordSet;
import io.trino.plugin.kudu.KuduSplit;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.RecordSet;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class KuduRecordSetProvider
implements ConnectorRecordSetProvider {
    private final KuduClientSession clientSession;

    @Inject
    public KuduRecordSetProvider(KuduClientSession clientSession) {
        this.clientSession = clientSession;
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<? extends ColumnHandle> columns) {
        Objects.requireNonNull(split, "split is null");
        Objects.requireNonNull(columns, "columns is null");
        KuduSplit kuduSplit = (KuduSplit)split;
        return new KuduRecordSet(this.clientSession, kuduSplit, columns);
    }
}

