/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.base.authentication.CachingKerberosAuthentication;
import io.trino.plugin.base.authentication.KerberosAuthentication;
import io.trino.plugin.base.authentication.KerberosConfiguration;
import io.trino.plugin.base.util.SystemProperties;
import io.trino.plugin.kudu.KerberizedKuduClient;
import io.trino.plugin.kudu.KuduAuthenticationConfig;
import io.trino.plugin.kudu.KuduClientConfig;
import io.trino.plugin.kudu.KuduClientSession;
import io.trino.plugin.kudu.KuduClientWrapper;
import io.trino.plugin.kudu.KuduKerberosConfig;
import io.trino.plugin.kudu.PassthroughKuduClient;
import io.trino.plugin.kudu.schema.NoSchemaEmulation;
import io.trino.plugin.kudu.schema.SchemaEmulation;
import io.trino.plugin.kudu.schema.SchemaEmulationByTableNameConvention;
import java.util.function.Function;
import javax.inject.Singleton;
import org.apache.kudu.client.KuduClient;

public class KuduSecurityModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(KuduAuthenticationConfig.class);
        this.install(ConditionalModule.conditionalModule(KuduAuthenticationConfig.class, authenticationConfig -> authenticationConfig.getAuthenticationType() == KuduAuthenticationConfig.KuduAuthenticationType.NONE, (Module)new NoneAuthenticationModule()));
        this.install(ConditionalModule.conditionalModule(KuduAuthenticationConfig.class, authenticationConfig -> authenticationConfig.getAuthenticationType() == KuduAuthenticationConfig.KuduAuthenticationType.KERBEROS, (Module)new KerberosAuthenticationModule()));
    }

    private static KuduClientSession createKuduClientSession(KuduClientConfig config, Function<KuduClient.KuduClientBuilder, KuduClientWrapper> kuduClientFactory) {
        KuduClient.KuduClientBuilder builder = new KuduClient.KuduClientBuilder(config.getMasterAddresses());
        builder.defaultAdminOperationTimeoutMs(config.getDefaultAdminOperationTimeout().toMillis());
        builder.defaultOperationTimeoutMs(config.getDefaultOperationTimeout().toMillis());
        if (config.isDisableStatistics()) {
            builder.disableStatistics();
        }
        KuduClientWrapper client = kuduClientFactory.apply(builder);
        SchemaEmulation strategy = config.isSchemaEmulationEnabled() ? new SchemaEmulationByTableNameConvention(config.getSchemaEmulationPrefix()) : new NoSchemaEmulation();
        return new KuduClientSession(client, strategy);
    }

    private static class NoneAuthenticationModule
    extends AbstractConfigurationAwareModule {
        private NoneAuthenticationModule() {
        }

        public void setup(Binder binder) {
        }

        @Provides
        @Singleton
        public static KuduClientSession createKuduClientSession(KuduClientConfig config) {
            return KuduSecurityModule.createKuduClientSession(config, builder -> new PassthroughKuduClient(builder.build()));
        }
    }

    private static class KerberosAuthenticationModule
    extends AbstractConfigurationAwareModule {
        private KerberosAuthenticationModule() {
        }

        public void setup(Binder binder) {
            ConfigBinder.configBinder((Binder)binder).bindConfig(KuduKerberosConfig.class);
        }

        @Provides
        @Singleton
        public static KuduClientSession createKuduClientSession(KuduClientConfig config, KuduKerberosConfig kuduKerberosConfig) {
            return KuduSecurityModule.createKuduClientSession(config, (KuduClient.KuduClientBuilder builder) -> {
                kuduKerberosConfig.getKuduPrincipalPrimary().ifPresent(arg_0 -> ((KuduClient.KuduClientBuilder)builder).saslProtocolName(arg_0));
                SystemProperties.setJavaSecurityKrb5Conf((String)kuduKerberosConfig.getConfig().getAbsolutePath());
                KerberosAuthentication kerberosAuthentication = new KerberosAuthentication(new KerberosConfiguration.Builder().withKerberosPrincipal(kuduKerberosConfig.getClientPrincipal()).withKeytabLocation(kuduKerberosConfig.getClientKeytab().getAbsolutePath()).build());
                CachingKerberosAuthentication cachingKerberosAuthentication = new CachingKerberosAuthentication(kerberosAuthentication);
                return new KerberizedKuduClient((KuduClient.KuduClientBuilder)builder, cachingKerberosAuthentication);
            });
        }
    }
}

