/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import io.trino.plugin.kudu.KuduClientSession;
import io.trino.plugin.kudu.KuduSessionProperties;
import io.trino.plugin.kudu.KuduSplit;
import io.trino.plugin.kudu.KuduTableHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class KuduSplitManager
implements ConnectorSplitManager {
    private final KuduClientSession clientSession;

    @Inject
    public KuduSplitManager(KuduClientSession clientSession) {
        this.clientSession = Objects.requireNonNull(clientSession, "clientSession is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, DynamicFilter dynamicFilter, Constraint constraint) {
        long timeoutMillis = KuduSessionProperties.getDynamicFilteringWaitTimeout(session).toMillis();
        if (timeoutMillis == 0L || !dynamicFilter.isAwaitable()) {
            return this.getSplitSource(table, dynamicFilter);
        }
        CompletableFuture<Object> dynamicFilterFuture = KuduSplitManager.whenCompleted(dynamicFilter).completeOnTimeout(null, timeoutMillis, TimeUnit.MILLISECONDS);
        CompletionStage splitSourceFuture = dynamicFilterFuture.thenApply(ignored -> this.getSplitSource(table, dynamicFilter));
        return new KuduDynamicFilteringSplitSource(dynamicFilterFuture, (CompletableFuture<ConnectorSplitSource>)splitSourceFuture);
    }

    private ConnectorSplitSource getSplitSource(ConnectorTableHandle table, DynamicFilter dynamicFilter) {
        KuduTableHandle handle = (KuduTableHandle)table;
        List<KuduSplit> splits = this.clientSession.buildKuduSplits(handle, dynamicFilter);
        return new FixedSplitSource(splits);
    }

    private static CompletableFuture<?> whenCompleted(DynamicFilter dynamicFilter) {
        if (dynamicFilter.isAwaitable()) {
            return dynamicFilter.isBlocked().thenCompose(ignored -> KuduSplitManager.whenCompleted(dynamicFilter));
        }
        return DynamicFilter.NOT_BLOCKED;
    }

    private static class KuduDynamicFilteringSplitSource
    implements ConnectorSplitSource {
        private final CompletableFuture<?> dynamicFilterFuture;
        private final CompletableFuture<ConnectorSplitSource> splitSourceFuture;

        private KuduDynamicFilteringSplitSource(CompletableFuture<?> dynamicFilterFuture, CompletableFuture<ConnectorSplitSource> splitSourceFuture) {
            this.dynamicFilterFuture = Objects.requireNonNull(dynamicFilterFuture, "dynamicFilterFuture is null");
            this.splitSourceFuture = Objects.requireNonNull(splitSourceFuture, "splitSourceFuture is null");
        }

        public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(int maxSize) {
            return this.splitSourceFuture.thenCompose(splitSource -> splitSource.getNextBatch(maxSize));
        }

        public void close() {
            if (!this.dynamicFilterFuture.cancel(true)) {
                this.splitSourceFuture.thenAccept(ConnectorSplitSource::close);
            }
        }

        public boolean isFinished() {
            if (!this.splitSourceFuture.isDone()) {
                return false;
            }
            if (this.splitSourceFuture.isCompletedExceptionally()) {
                return false;
            }
            try {
                return this.splitSourceFuture.get().isFinished();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

