/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.ColumnTypeAttributes;
import org.apache.kudu.Type;
import org.apache.kudu.client.RowResult;

public final class TypeHelper {
    private TypeHelper() {
    }

    public static Type toKuduClientType(io.trino.spi.type.Type type) {
        if (type instanceof VarcharType) {
            return Type.STRING;
        }
        if (type.equals(TimestampType.TIMESTAMP_MILLIS)) {
            return Type.UNIXTIME_MICROS;
        }
        if (type == BigintType.BIGINT) {
            return Type.INT64;
        }
        if (type == IntegerType.INTEGER) {
            return Type.INT32;
        }
        if (type == SmallintType.SMALLINT) {
            return Type.INT16;
        }
        if (type == TinyintType.TINYINT) {
            return Type.INT8;
        }
        if (type == RealType.REAL) {
            return Type.FLOAT;
        }
        if (type == DoubleType.DOUBLE) {
            return Type.DOUBLE;
        }
        if (type == BooleanType.BOOLEAN) {
            return Type.BOOL;
        }
        if (type instanceof VarbinaryType) {
            return Type.BINARY;
        }
        if (type instanceof DecimalType) {
            return Type.DECIMAL;
        }
        if (type == DateType.DATE) {
            return Type.STRING;
        }
        if (type instanceof CharType) {
            return Type.STRING;
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type: " + type);
    }

    public static io.trino.spi.type.Type fromKuduColumn(ColumnSchema column) {
        return TypeHelper.fromKuduClientType(column.getType(), column.getTypeAttributes());
    }

    private static io.trino.spi.type.Type fromKuduClientType(Type ktype, ColumnTypeAttributes attributes) {
        switch (ktype) {
            case STRING: {
                return VarcharType.VARCHAR;
            }
            case UNIXTIME_MICROS: {
                return TimestampType.TIMESTAMP_MILLIS;
            }
            case INT64: {
                return BigintType.BIGINT;
            }
            case INT32: {
                return IntegerType.INTEGER;
            }
            case INT16: {
                return SmallintType.SMALLINT;
            }
            case INT8: {
                return TinyintType.TINYINT;
            }
            case FLOAT: {
                return RealType.REAL;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case BOOL: {
                return BooleanType.BOOLEAN;
            }
            case BINARY: {
                return VarbinaryType.VARBINARY;
            }
            case DECIMAL: {
                return DecimalType.createDecimalType((int)attributes.getPrecision(), (int)attributes.getScale());
            }
        }
        throw new IllegalStateException("Kudu type not implemented for " + ktype);
    }

    public static Object getJavaValue(io.trino.spi.type.Type type, Object nativeValue) {
        if (type instanceof VarcharType) {
            return ((Slice)nativeValue).toStringUtf8();
        }
        if (type.equals(TimestampType.TIMESTAMP_MILLIS)) {
            return nativeValue;
        }
        if (type == BigintType.BIGINT) {
            return nativeValue;
        }
        if (type == IntegerType.INTEGER) {
            return ((Long)nativeValue).intValue();
        }
        if (type == SmallintType.SMALLINT) {
            return ((Long)nativeValue).shortValue();
        }
        if (type == TinyintType.TINYINT) {
            return ((Long)nativeValue).byteValue();
        }
        if (type == DoubleType.DOUBLE) {
            return nativeValue;
        }
        if (type == RealType.REAL) {
            return Float.valueOf(Float.intBitsToFloat(((Long)nativeValue).intValue()));
        }
        if (type == BooleanType.BOOLEAN) {
            return nativeValue;
        }
        if (type instanceof VarbinaryType) {
            return ((Slice)nativeValue).toByteBuffer();
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (decimalType.isShort()) {
                return new BigDecimal(BigInteger.valueOf((Long)nativeValue), decimalType.getScale());
            }
            return new BigDecimal(((Int128)nativeValue).toBigInteger(), decimalType.getScale());
        }
        throw new IllegalStateException("Back conversion not implemented for " + type);
    }

    public static Object getObject(io.trino.spi.type.Type type, RowResult row, int field) {
        if (row.isNull(field)) {
            return null;
        }
        if (type instanceof VarcharType) {
            return row.getString(field);
        }
        if (type.equals(TimestampType.TIMESTAMP_MILLIS)) {
            return Timestamps.truncateEpochMicrosToMillis((long)row.getLong(field));
        }
        if (type == BigintType.BIGINT) {
            return row.getLong(field);
        }
        if (type == IntegerType.INTEGER) {
            return row.getInt(field);
        }
        if (type == SmallintType.SMALLINT) {
            return row.getShort(field);
        }
        if (type == TinyintType.TINYINT) {
            return row.getByte(field);
        }
        if (type == DoubleType.DOUBLE) {
            return row.getDouble(field);
        }
        if (type == RealType.REAL) {
            return Float.valueOf(row.getFloat(field));
        }
        if (type == BooleanType.BOOLEAN) {
            return row.getBoolean(field);
        }
        if (type instanceof VarbinaryType) {
            return Slices.wrappedBuffer((ByteBuffer)row.getBinary(field));
        }
        if (type instanceof DecimalType) {
            return Decimals.encodeScaledValue((BigDecimal)row.getDecimal(field), (int)((DecimalType)type).getScale());
        }
        throw new IllegalStateException("getObject not implemented for " + type);
    }

    public static long getLong(io.trino.spi.type.Type type, RowResult row, int field) {
        if (type.equals(TimestampType.TIMESTAMP_MILLIS)) {
            return Timestamps.truncateEpochMicrosToMillis((long)row.getLong(field));
        }
        if (type == BigintType.BIGINT) {
            return row.getLong(field);
        }
        if (type == IntegerType.INTEGER) {
            return row.getInt(field);
        }
        if (type == SmallintType.SMALLINT) {
            return row.getShort(field);
        }
        if (type == TinyintType.TINYINT) {
            return row.getByte(field);
        }
        if (type == RealType.REAL) {
            return Float.floatToRawIntBits(row.getFloat(field));
        }
        if (type instanceof DecimalType) {
            DecimalType dtype = (DecimalType)type;
            if (dtype.isShort()) {
                return row.getDecimal(field).unscaledValue().longValue();
            }
            throw new IllegalStateException("getLong not supported for long decimal: " + type);
        }
        throw new IllegalStateException("getLong not implemented for " + type);
    }

    public static boolean getBoolean(io.trino.spi.type.Type type, RowResult row, int field) {
        if (type == BooleanType.BOOLEAN) {
            return row.getBoolean(field);
        }
        throw new IllegalStateException("getBoolean not implemented for " + type);
    }

    public static double getDouble(io.trino.spi.type.Type type, RowResult row, int field) {
        if (type == DoubleType.DOUBLE) {
            return row.getDouble(field);
        }
        throw new IllegalStateException("getDouble not implemented for " + type);
    }

    public static Slice getSlice(io.trino.spi.type.Type type, RowResult row, int field) {
        if (type instanceof VarcharType) {
            return Slices.utf8Slice((String)row.getString(field));
        }
        if (type instanceof VarbinaryType) {
            return Slices.wrappedBuffer((ByteBuffer)row.getBinary(field));
        }
        throw new IllegalStateException("getSlice not implemented for " + type);
    }
}

