/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import com.linkedin.coral.org.apache.commons.logging.Log;
import com.linkedin.coral.org.apache.commons.logging.LogFactory;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.commons.dbcp2.BasicDataSource;

public class BasicDataSourceFactory
implements ObjectFactory {
    private static final Log log = LogFactory.getLog(BasicDataSourceFactory.class);
    private static final String PROP_DEFAULT_AUTO_COMMIT = "defaultAutoCommit";
    private static final String PROP_DEFAULT_READ_ONLY = "defaultReadOnly";
    private static final String PROP_DEFAULT_TRANSACTION_ISOLATION = "defaultTransactionIsolation";
    private static final String PROP_DEFAULT_CATALOG = "defaultCatalog";
    private static final String PROP_DEFAULT_SCHEMA = "defaultSchema";
    private static final String PROP_CACHE_STATE = "cacheState";
    private static final String PROP_DRIVER_CLASS_NAME = "driverClassName";
    private static final String PROP_LIFO = "lifo";
    private static final String PROP_MAX_TOTAL = "maxTotal";
    private static final String PROP_MAX_IDLE = "maxIdle";
    private static final String PROP_MIN_IDLE = "minIdle";
    private static final String PROP_INITIAL_SIZE = "initialSize";
    private static final String PROP_MAX_WAIT_MILLIS = "maxWaitMillis";
    private static final String PROP_TEST_ON_CREATE = "testOnCreate";
    private static final String PROP_TEST_ON_BORROW = "testOnBorrow";
    private static final String PROP_TEST_ON_RETURN = "testOnReturn";
    private static final String PROP_TIME_BETWEEN_EVICTION_RUNS_MILLIS = "timeBetweenEvictionRunsMillis";
    private static final String PROP_NUM_TESTS_PER_EVICTION_RUN = "numTestsPerEvictionRun";
    private static final String PROP_MIN_EVICTABLE_IDLE_TIME_MILLIS = "minEvictableIdleTimeMillis";
    private static final String PROP_SOFT_MIN_EVICTABLE_IDLE_TIME_MILLIS = "softMinEvictableIdleTimeMillis";
    private static final String PROP_EVICTION_POLICY_CLASS_NAME = "evictionPolicyClassName";
    private static final String PROP_TEST_WHILE_IDLE = "testWhileIdle";
    private static final String PROP_PASSWORD = "password";
    private static final String PROP_URL = "url";
    private static final String PROP_USER_NAME = "username";
    private static final String PROP_VALIDATION_QUERY = "validationQuery";
    private static final String PROP_VALIDATION_QUERY_TIMEOUT = "validationQueryTimeout";
    private static final String PROP_JMX_NAME = "jmxName";
    private static final String PROP_CONNECTION_INIT_SQLS = "connectionInitSqls";
    private static final String PROP_ACCESS_TO_UNDERLYING_CONNECTION_ALLOWED = "accessToUnderlyingConnectionAllowed";
    private static final String PROP_REMOVE_ABANDONED_ON_BORROW = "removeAbandonedOnBorrow";
    private static final String PROP_REMOVE_ABANDONED_ON_MAINTENANCE = "removeAbandonedOnMaintenance";
    private static final String PROP_REMOVE_ABANDONED_TIMEOUT = "removeAbandonedTimeout";
    private static final String PROP_LOG_ABANDONED = "logAbandoned";
    private static final String PROP_ABANDONED_USAGE_TRACKING = "abandonedUsageTracking";
    private static final String PROP_POOL_PREPARED_STATEMENTS = "poolPreparedStatements";
    private static final String PROP_MAX_OPEN_PREPARED_STATEMENTS = "maxOpenPreparedStatements";
    private static final String PROP_CONNECTION_PROPERTIES = "connectionProperties";
    private static final String PROP_MAX_CONN_LIFETIME_MILLIS = "maxConnLifetimeMillis";
    private static final String PROP_LOG_EXPIRED_CONNECTIONS = "logExpiredConnections";
    private static final String PROP_ROLLBACK_ON_RETURN = "rollbackOnReturn";
    private static final String PROP_ENABLE_AUTO_COMMIT_ON_RETURN = "enableAutoCommitOnReturn";
    private static final String PROP_DEFAULT_QUERY_TIMEOUT = "defaultQueryTimeout";
    private static final String PROP_FAST_FAIL_VALIDATION = "fastFailValidation";
    private static final String PROP_DISCONNECTION_SQL_CODES = "disconnectionSqlCodes";
    private static final String NUPROP_MAX_ACTIVE = "maxActive";
    private static final String NUPROP_REMOVE_ABANDONED = "removeAbandoned";
    private static final String NUPROP_MAXWAIT = "maxWait";
    private static final String SILENT_PROP_FACTORY = "factory";
    private static final String SILENT_PROP_SCOPE = "scope";
    private static final String SILENT_PROP_SINGLETON = "singleton";
    private static final String SILENT_PROP_AUTH = "auth";
    private static final String[] ALL_PROPERTIES = new String[]{"defaultAutoCommit", "defaultReadOnly", "defaultTransactionIsolation", "defaultCatalog", "defaultSchema", "cacheState", "driverClassName", "lifo", "maxTotal", "maxIdle", "minIdle", "initialSize", "maxWaitMillis", "testOnCreate", "testOnBorrow", "testOnReturn", "timeBetweenEvictionRunsMillis", "numTestsPerEvictionRun", "minEvictableIdleTimeMillis", "softMinEvictableIdleTimeMillis", "evictionPolicyClassName", "testWhileIdle", "password", "url", "username", "validationQuery", "validationQueryTimeout", "connectionInitSqls", "accessToUnderlyingConnectionAllowed", "removeAbandonedOnBorrow", "removeAbandonedOnMaintenance", "removeAbandonedTimeout", "logAbandoned", "abandonedUsageTracking", "poolPreparedStatements", "maxOpenPreparedStatements", "connectionProperties", "maxConnLifetimeMillis", "logExpiredConnections", "rollbackOnReturn", "enableAutoCommitOnReturn", "defaultQueryTimeout", "fastFailValidation", "disconnectionSqlCodes", "jmxName"};
    private static final Map<String, String> NUPROP_WARNTEXT = new LinkedHashMap<String, String>();
    private static final List<String> SILENT_PROPERTIES;

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj == null || !(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        if (!"javax.sql.DataSource".equals(ref.getClassName())) {
            return null;
        }
        ArrayList<String> warnings = new ArrayList<String>();
        ArrayList<String> infoMessages = new ArrayList<String>();
        this.validatePropertyNames(ref, name, warnings, infoMessages);
        for (String warning : warnings) {
            log.warn(warning);
        }
        for (String infoMessage : infoMessages) {
            log.info(infoMessage);
        }
        Properties properties = new Properties();
        for (String propertyName : ALL_PROPERTIES) {
            RefAddr ra = ref.get(propertyName);
            if (ra == null) continue;
            String propertyValue = ra.getContent().toString();
            properties.setProperty(propertyName, propertyValue);
        }
        return BasicDataSourceFactory.createDataSource(properties);
    }

    private void validatePropertyNames(Reference ref, Name name, List<String> warnings, List<String> infoMessages) {
        String nameString;
        List<String> allPropsAsList = Arrays.asList(ALL_PROPERTIES);
        String string = nameString = name != null ? "Name = " + name.toString() + " " : "";
        if (NUPROP_WARNTEXT != null && !NUPROP_WARNTEXT.keySet().isEmpty()) {
            for (String propertyName : NUPROP_WARNTEXT.keySet()) {
                RefAddr ra = ref.get(propertyName);
                if (ra == null || allPropsAsList.contains(ra.getType())) continue;
                StringBuilder stringBuilder = new StringBuilder(nameString);
                String propertyValue = ra.getContent().toString();
                stringBuilder.append(NUPROP_WARNTEXT.get(propertyName)).append(" You have set value of \"").append(propertyValue).append("\" for \"").append(propertyName).append("\" property, which is being ignored.");
                warnings.add(stringBuilder.toString());
            }
        }
        Enumeration<RefAddr> allRefAddrs = ref.getAll();
        while (allRefAddrs.hasMoreElements()) {
            RefAddr ra = allRefAddrs.nextElement();
            String propertyName = ra.getType();
            if (allPropsAsList.contains(propertyName) || NUPROP_WARNTEXT.keySet().contains(propertyName) || SILENT_PROPERTIES.contains(propertyName)) continue;
            String propertyValue = ra.getContent().toString();
            StringBuilder stringBuilder = new StringBuilder(nameString);
            stringBuilder.append("Ignoring unknown property: ").append("value of \"").append(propertyValue).append("\" for \"").append(propertyName).append("\" property");
            infoMessages.add(stringBuilder.toString());
        }
    }

    public static BasicDataSource createDataSource(Properties properties) throws Exception {
        BasicDataSource dataSource = new BasicDataSource();
        String value = null;
        value = properties.getProperty(PROP_DEFAULT_AUTO_COMMIT);
        if (value != null) {
            dataSource.setDefaultAutoCommit(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_DEFAULT_READ_ONLY)) != null) {
            dataSource.setDefaultReadOnly(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_DEFAULT_TRANSACTION_ISOLATION)) != null) {
            int level = -1;
            if ("NONE".equalsIgnoreCase(value)) {
                level = 0;
            } else if ("READ_COMMITTED".equalsIgnoreCase(value)) {
                level = 2;
            } else if ("READ_UNCOMMITTED".equalsIgnoreCase(value)) {
                level = 1;
            } else if ("REPEATABLE_READ".equalsIgnoreCase(value)) {
                level = 4;
            } else if ("SERIALIZABLE".equalsIgnoreCase(value)) {
                level = 8;
            } else {
                try {
                    level = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    System.err.println("Could not parse defaultTransactionIsolation: " + value);
                    System.err.println("WARNING: defaultTransactionIsolation not set");
                    System.err.println("using default value of database driver");
                    level = -1;
                }
            }
            dataSource.setDefaultTransactionIsolation(level);
        }
        if ((value = properties.getProperty(PROP_DEFAULT_CATALOG)) != null) {
            dataSource.setDefaultCatalog(value);
        }
        if ((value = properties.getProperty(PROP_DEFAULT_SCHEMA)) != null) {
            dataSource.setDefaultSchema(value);
        }
        if ((value = properties.getProperty(PROP_CACHE_STATE)) != null) {
            dataSource.setCacheState(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_DRIVER_CLASS_NAME)) != null) {
            dataSource.setDriverClassName(value);
        }
        if ((value = properties.getProperty(PROP_LIFO)) != null) {
            dataSource.setLifo(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_MAX_TOTAL)) != null) {
            dataSource.setMaxTotal(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_MAX_IDLE)) != null) {
            dataSource.setMaxIdle(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_MIN_IDLE)) != null) {
            dataSource.setMinIdle(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_INITIAL_SIZE)) != null) {
            dataSource.setInitialSize(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_MAX_WAIT_MILLIS)) != null) {
            dataSource.setMaxWaitMillis(Long.parseLong(value));
        }
        if ((value = properties.getProperty(PROP_TEST_ON_CREATE)) != null) {
            dataSource.setTestOnCreate(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_TEST_ON_BORROW)) != null) {
            dataSource.setTestOnBorrow(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_TEST_ON_RETURN)) != null) {
            dataSource.setTestOnReturn(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_TIME_BETWEEN_EVICTION_RUNS_MILLIS)) != null) {
            dataSource.setTimeBetweenEvictionRunsMillis(Long.parseLong(value));
        }
        if ((value = properties.getProperty(PROP_NUM_TESTS_PER_EVICTION_RUN)) != null) {
            dataSource.setNumTestsPerEvictionRun(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_MIN_EVICTABLE_IDLE_TIME_MILLIS)) != null) {
            dataSource.setMinEvictableIdleTimeMillis(Long.parseLong(value));
        }
        if ((value = properties.getProperty(PROP_SOFT_MIN_EVICTABLE_IDLE_TIME_MILLIS)) != null) {
            dataSource.setSoftMinEvictableIdleTimeMillis(Long.parseLong(value));
        }
        if ((value = properties.getProperty(PROP_EVICTION_POLICY_CLASS_NAME)) != null) {
            dataSource.setEvictionPolicyClassName(value);
        }
        if ((value = properties.getProperty(PROP_TEST_WHILE_IDLE)) != null) {
            dataSource.setTestWhileIdle(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_PASSWORD)) != null) {
            dataSource.setPassword(value);
        }
        if ((value = properties.getProperty(PROP_URL)) != null) {
            dataSource.setUrl(value);
        }
        if ((value = properties.getProperty(PROP_USER_NAME)) != null) {
            dataSource.setUsername(value);
        }
        if ((value = properties.getProperty(PROP_VALIDATION_QUERY)) != null) {
            dataSource.setValidationQuery(value);
        }
        if ((value = properties.getProperty(PROP_VALIDATION_QUERY_TIMEOUT)) != null) {
            dataSource.setValidationQueryTimeout(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_ACCESS_TO_UNDERLYING_CONNECTION_ALLOWED)) != null) {
            dataSource.setAccessToUnderlyingConnectionAllowed(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_REMOVE_ABANDONED_ON_BORROW)) != null) {
            dataSource.setRemoveAbandonedOnBorrow(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_REMOVE_ABANDONED_ON_MAINTENANCE)) != null) {
            dataSource.setRemoveAbandonedOnMaintenance(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_REMOVE_ABANDONED_TIMEOUT)) != null) {
            dataSource.setRemoveAbandonedTimeout(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_LOG_ABANDONED)) != null) {
            dataSource.setLogAbandoned(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_ABANDONED_USAGE_TRACKING)) != null) {
            dataSource.setAbandonedUsageTracking(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_POOL_PREPARED_STATEMENTS)) != null) {
            dataSource.setPoolPreparedStatements(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_MAX_OPEN_PREPARED_STATEMENTS)) != null) {
            dataSource.setMaxOpenPreparedStatements(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_CONNECTION_INIT_SQLS)) != null) {
            dataSource.setConnectionInitSqls(BasicDataSourceFactory.parseList(value, ';'));
        }
        if ((value = properties.getProperty(PROP_CONNECTION_PROPERTIES)) != null) {
            Properties p = BasicDataSourceFactory.getProperties(value);
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                dataSource.addConnectionProperty(propertyName, p.getProperty(propertyName));
            }
        }
        if ((value = properties.getProperty(PROP_MAX_CONN_LIFETIME_MILLIS)) != null) {
            dataSource.setMaxConnLifetimeMillis(Long.parseLong(value));
        }
        if ((value = properties.getProperty(PROP_LOG_EXPIRED_CONNECTIONS)) != null) {
            dataSource.setLogExpiredConnections(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_JMX_NAME)) != null) {
            dataSource.setJmxName(value);
        }
        if ((value = properties.getProperty(PROP_ENABLE_AUTO_COMMIT_ON_RETURN)) != null) {
            dataSource.setAutoCommitOnReturn(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_ROLLBACK_ON_RETURN)) != null) {
            dataSource.setRollbackOnReturn(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_DEFAULT_QUERY_TIMEOUT)) != null) {
            dataSource.setDefaultQueryTimeout(Integer.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_FAST_FAIL_VALIDATION)) != null) {
            dataSource.setFastFailValidation(Boolean.valueOf(value));
        }
        if ((value = properties.getProperty(PROP_DISCONNECTION_SQL_CODES)) != null) {
            dataSource.setDisconnectionSqlCodes(BasicDataSourceFactory.parseList(value, ','));
        }
        if (dataSource.getInitialSize() > 0) {
            dataSource.getLogWriter();
        }
        return dataSource;
    }

    private static Properties getProperties(String propText) throws Exception {
        Properties p = new Properties();
        if (propText != null) {
            p.load(new ByteArrayInputStream(propText.replace(';', '\n').getBytes(StandardCharsets.ISO_8859_1)));
        }
        return p;
    }

    private static Collection<String> parseList(String value, char delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(value, Character.toString(delimiter));
        ArrayList<String> tokens = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens;
    }

    static {
        NUPROP_WARNTEXT.put(NUPROP_MAX_ACTIVE, "Property maxActive is not used in DBCP2, use maxTotal instead. maxTotal default value is 8.");
        NUPROP_WARNTEXT.put(NUPROP_REMOVE_ABANDONED, "Property removeAbandoned is not used in DBCP2, use one or both of removeAbandonedOnBorrow or removeAbandonedOnMaintenance instead. Both have default value set to false.");
        NUPROP_WARNTEXT.put(NUPROP_MAXWAIT, "Property maxWait is not used in DBCP2 , use maxWaitMillis instead. maxWaitMillis default value is -1.");
        SILENT_PROPERTIES = new ArrayList<String>();
        SILENT_PROPERTIES.add(SILENT_PROP_FACTORY);
        SILENT_PROPERTIES.add(SILENT_PROP_SCOPE);
        SILENT_PROPERTIES.add(SILENT_PROP_SINGLETON);
        SILENT_PROPERTIES.add(SILENT_PROP_AUTH);
    }
}

