/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift;

import io.airlift.drift.client.DriftClient;
import io.trino.plugin.thrift.ThriftConnectorConfig;
import io.trino.plugin.thrift.ThriftConnectorIndex;
import io.trino.plugin.thrift.ThriftConnectorStats;
import io.trino.plugin.thrift.ThriftHeaderProvider;
import io.trino.plugin.thrift.ThriftIndexHandle;
import io.trino.plugin.thrift.api.TrinoThriftService;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorIndex;
import io.trino.spi.connector.ConnectorIndexHandle;
import io.trino.spi.connector.ConnectorIndexProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class ThriftIndexProvider
implements ConnectorIndexProvider {
    private final DriftClient<TrinoThriftService> client;
    private final ThriftHeaderProvider thriftHeaderProvider;
    private final long maxBytesPerResponse;
    private final int lookupRequestsConcurrency;
    private final ThriftConnectorStats stats;

    @Inject
    public ThriftIndexProvider(DriftClient<TrinoThriftService> client, ThriftHeaderProvider thriftHeaderProvider, ThriftConnectorStats stats, ThriftConnectorConfig config) {
        this.client = Objects.requireNonNull(client, "client is null");
        this.thriftHeaderProvider = Objects.requireNonNull(thriftHeaderProvider, "thriftHeaderProvider is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.maxBytesPerResponse = config.getMaxResponseSize().toBytes();
        this.lookupRequestsConcurrency = config.getLookupRequestsConcurrency();
    }

    public ConnectorIndex getIndex(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorIndexHandle indexHandle, List<ColumnHandle> lookupSchema, List<ColumnHandle> outputSchema) {
        return new ThriftConnectorIndex(this.client, this.thriftHeaderProvider.getHeaders(session), this.stats, (ThriftIndexHandle)indexHandle, lookupSchema, outputSchema, this.maxBytesPerResponse, this.lookupRequestsConcurrency);
    }
}

