/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift;

import io.airlift.drift.client.DriftClient;
import io.trino.plugin.thrift.ThriftConnectorConfig;
import io.trino.plugin.thrift.ThriftConnectorSplit;
import io.trino.plugin.thrift.ThriftConnectorStats;
import io.trino.plugin.thrift.ThriftHeaderProvider;
import io.trino.plugin.thrift.ThriftPageSource;
import io.trino.plugin.thrift.api.TrinoThriftService;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class ThriftPageSourceProvider
implements ConnectorPageSourceProvider {
    private final DriftClient<TrinoThriftService> client;
    private final ThriftHeaderProvider thriftHeaderProvider;
    private final long maxBytesPerResponse;
    private final ThriftConnectorStats stats;

    @Inject
    public ThriftPageSourceProvider(DriftClient<TrinoThriftService> client, ThriftHeaderProvider thriftHeaderProvider, ThriftConnectorStats stats, ThriftConnectorConfig config) {
        this.client = Objects.requireNonNull(client, "client is null");
        this.thriftHeaderProvider = Objects.requireNonNull(thriftHeaderProvider, "thriftHeaderProvider is null");
        this.maxBytesPerResponse = config.getMaxResponseSize().toBytes();
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        return new ThriftPageSource(this.client, this.thriftHeaderProvider.getHeaders(session), (ThriftConnectorSplit)split, columns, this.stats, this.maxBytesPerResponse);
    }
}

