/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.airlift.drift.client.DriftClient;
import io.trino.plugin.thrift.ThriftColumnHandle;
import io.trino.plugin.thrift.ThriftConnectorSplit;
import io.trino.plugin.thrift.ThriftHeaderProvider;
import io.trino.plugin.thrift.ThriftTableHandle;
import io.trino.plugin.thrift.api.TrinoThriftHostAddress;
import io.trino.plugin.thrift.api.TrinoThriftId;
import io.trino.plugin.thrift.api.TrinoThriftNullableColumnSet;
import io.trino.plugin.thrift.api.TrinoThriftNullableToken;
import io.trino.plugin.thrift.api.TrinoThriftSchemaTableName;
import io.trino.plugin.thrift.api.TrinoThriftService;
import io.trino.plugin.thrift.api.TrinoThriftSplit;
import io.trino.plugin.thrift.api.TrinoThriftTupleDomain;
import io.trino.plugin.thrift.util.ThriftExceptions;
import io.trino.plugin.thrift.util.TupleDomainConversion;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.NotThreadSafe;
import javax.inject.Inject;

public class ThriftSplitManager
implements ConnectorSplitManager {
    private final DriftClient<TrinoThriftService> client;
    private final ThriftHeaderProvider thriftHeaderProvider;

    @Inject
    public ThriftSplitManager(DriftClient<TrinoThriftService> client, ThriftHeaderProvider thriftHeaderProvider) {
        this.client = Objects.requireNonNull(client, "client is null");
        this.thriftHeaderProvider = Objects.requireNonNull(thriftHeaderProvider, "thriftHeaderProvider is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, DynamicFilter dynamicFilter, Constraint constraint) {
        ThriftTableHandle tableHandle = (ThriftTableHandle)table;
        return new ThriftSplitSource((TrinoThriftService)this.client.get(this.thriftHeaderProvider.getHeaders(session)), new TrinoThriftSchemaTableName(tableHandle.getSchemaName(), tableHandle.getTableName()), tableHandle.getDesiredColumns().map(ThriftSplitManager::columnNames), TupleDomainConversion.tupleDomainToThriftTupleDomain(tableHandle.getConstraint()));
    }

    private static Set<String> columnNames(Set<ColumnHandle> columns) {
        return (Set)columns.stream().map(ThriftColumnHandle.class::cast).map(ThriftColumnHandle::getColumnName).collect(ImmutableSet.toImmutableSet());
    }

    @NotThreadSafe
    private static class ThriftSplitSource
    implements ConnectorSplitSource {
        private final TrinoThriftService client;
        private final TrinoThriftSchemaTableName schemaTableName;
        private final Optional<Set<String>> columnNames;
        private final TrinoThriftTupleDomain constraint;
        private final AtomicBoolean hasMoreData;
        private final AtomicReference<TrinoThriftId> nextToken;
        private final AtomicReference<Future<?>> future;

        public ThriftSplitSource(TrinoThriftService client, TrinoThriftSchemaTableName schemaTableName, Optional<Set<String>> columnNames, TrinoThriftTupleDomain constraint) {
            this.client = Objects.requireNonNull(client, "client is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
            this.columnNames = Objects.requireNonNull(columnNames, "columnNames is null");
            this.constraint = Objects.requireNonNull(constraint, "constraint is null");
            this.nextToken = new AtomicReference<Object>(null);
            this.hasMoreData = new AtomicBoolean(true);
            this.future = new AtomicReference<Object>(null);
        }

        public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(int maxSize) {
            Preconditions.checkState((this.future.get() == null || this.future.get().isDone() ? 1 : 0) != 0, (Object)"previous batch not completed");
            Preconditions.checkState((boolean)this.hasMoreData.get(), (Object)"this method cannot be invoked when there's no more data");
            TrinoThriftId currentToken = this.nextToken.get();
            ListenableFuture splitsFuture = this.client.getSplits(this.schemaTableName, new TrinoThriftNullableColumnSet((Set)this.columnNames.orElse(null)), this.constraint, maxSize, new TrinoThriftNullableToken(currentToken));
            ListenableFuture resultFuture = Futures.transform((ListenableFuture)splitsFuture, batch -> {
                Objects.requireNonNull(batch, "batch is null");
                List splits = (List)batch.getSplits().stream().map(ThriftSplitSource::toConnectorSplit).collect(ImmutableList.toImmutableList());
                Preconditions.checkState((boolean)this.nextToken.compareAndSet(currentToken, batch.getNextToken()));
                Preconditions.checkState((boolean)this.hasMoreData.compareAndSet(true, this.nextToken.get() != null));
                return new ConnectorSplitSource.ConnectorSplitBatch(splits, this.isFinished());
            }, (Executor)MoreExecutors.directExecutor());
            resultFuture = ThriftExceptions.catchingThriftException(resultFuture);
            this.future.set((Future<?>)resultFuture);
            return MoreFutures.toCompletableFuture(resultFuture);
        }

        public boolean isFinished() {
            return !this.hasMoreData.get();
        }

        public void close() {
            Future currentFuture = this.future.getAndSet(null);
            if (currentFuture != null) {
                currentFuture.cancel(true);
            }
        }

        private static ThriftConnectorSplit toConnectorSplit(TrinoThriftSplit thriftSplit) {
            return new ThriftConnectorSplit(thriftSplit.getSplitId(), ThriftSplitSource.toHostAddressList(thriftSplit.getHosts()));
        }

        private static List<HostAddress> toHostAddressList(List<TrinoThriftHostAddress> hosts) {
            return (List)hosts.stream().map(TrinoThriftHostAddress::toHostAddress).collect(ImmutableList.toImmutableList());
        }
    }
}

