/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.MoreObjects;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.type.TypeInfo;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.spi.Page;
import io.trino.spi.connector.BucketFunction;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class HiveBucketFunction
implements BucketFunction {
    private final HiveBucketing.BucketingVersion bucketingVersion;
    private final int bucketCount;
    private final List<TypeInfo> typeInfos;

    public HiveBucketFunction(HiveBucketing.BucketingVersion bucketingVersion, int bucketCount, List<HiveType> hiveTypes) {
        this.bucketingVersion = Objects.requireNonNull(bucketingVersion, "bucketingVersion is null");
        this.bucketCount = bucketCount;
        this.typeInfos = hiveTypes.stream().map(HiveType::getTypeInfo).collect(Collectors.toList());
    }

    public int getBucket(Page page, int position) {
        return HiveBucketing.getHiveBucket(this.bucketingVersion, this.bucketCount, this.typeInfos, page, position);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", (Object)this.bucketingVersion).add("bucketCount", this.bucketCount).add("typeInfos", this.typeInfos).toString();
    }
}

