/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.DataSize;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDataSize;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

public class SortingFileWriterConfig {
    private DataSize writerSortBufferSize = DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private int maxOpenSortFiles = 50;

    @MinDataSize(value="1MB")
    @MaxDataSize(value="1GB")
    public @MinDataSize(value="1MB") @MaxDataSize(value="1GB") DataSize getWriterSortBufferSize() {
        return this.writerSortBufferSize;
    }

    @Config(value="writer-sort-buffer-size")
    public SortingFileWriterConfig setWriterSortBufferSize(DataSize writerSortBufferSize) {
        this.writerSortBufferSize = writerSortBufferSize;
        return this;
    }

    @Min(value=2L)
    @Max(value=1000L)
    public @Min(value=2L) @Max(value=1000L) int getMaxOpenSortFiles() {
        return this.maxOpenSortFiles;
    }

    @Config(value="max-open-sort-files")
    @ConfigDescription(value="Maximum number of writer temporary files to read in one pass")
    public SortingFileWriterConfig setMaxOpenSortFiles(int maxOpenSortFiles) {
        this.maxOpenSortFiles = maxOpenSortFiles;
        return this;
    }
}

