/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.avro;

import io.trino.plugin.hive.RecordFileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.avro.AvroGenericRecordWriter;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeException;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;

public class AvroRecordWriter
implements RecordFileWriter.ExtendedRecordWriter {
    private final FileSinkOperator.RecordWriter delegate;
    private final FSDataOutputStream outputStream;

    public AvroRecordWriter(Path path, JobConf jobConf, boolean isCompressed, Properties properties) throws IOException {
        Schema schema;
        try {
            schema = AvroSerdeUtils.determineSchemaOrThrowException((Configuration)jobConf, (Properties)properties);
        }
        catch (AvroSerdeException e) {
            throw new IOException(e);
        }
        GenericDatumWriter genericDatumWriter = new GenericDatumWriter(schema);
        DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)genericDatumWriter);
        if (isCompressed) {
            int level = jobConf.getInt("avro.mapred.deflate.level", -1);
            String codecName = jobConf.get("avro.output.codec", "deflate");
            CodecFactory factory = codecName.equals("deflate") ? CodecFactory.deflateCodec((int)level) : CodecFactory.fromString((String)codecName);
            dataFileWriter.setCodec(factory);
        }
        this.outputStream = path.getFileSystem((Configuration)jobConf).create(path);
        dataFileWriter.create(schema, (OutputStream)this.outputStream);
        this.delegate = new AvroGenericRecordWriter(dataFileWriter);
    }

    @Override
    public long getWrittenBytes() {
        return this.outputStream.getPos();
    }

    public void write(Writable writable) throws IOException {
        this.delegate.write(writable);
    }

    public void close(boolean abort) throws IOException {
        this.delegate.close(abort);
    }
}

