/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.line;

import io.airlift.slice.SizeOf;
import io.trino.hive.formats.line.LineBuffer;
import io.trino.hive.formats.line.LineDeserializer;
import io.trino.hive.formats.line.LineReader;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorPageSource;
import java.io.IOException;
import java.util.Objects;
import java.util.OptionalLong;

public class LinePageSource
implements ConnectorPageSource {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(LinePageSource.class);
    private final LineReader lineReader;
    private final LineDeserializer deserializer;
    private final LineBuffer lineBuffer;
    private final String filePath;
    private PageBuilder pageBuilder;
    private long completedPositions;

    public LinePageSource(LineReader lineReader, LineDeserializer deserializer, LineBuffer lineBuffer, String filePath) {
        this.lineReader = Objects.requireNonNull(lineReader, "lineReader is null");
        this.deserializer = Objects.requireNonNull(deserializer, "deserializer is null");
        this.lineBuffer = Objects.requireNonNull(lineBuffer, "lineBuffer is null");
        this.filePath = Objects.requireNonNull(filePath, "filePath is null");
        this.pageBuilder = new PageBuilder(deserializer.getTypes());
    }

    public Page getNextPage() {
        try {
            while (!this.pageBuilder.isFull() && this.lineReader.readLine(this.lineBuffer)) {
                this.deserializer.deserialize(this.lineBuffer, this.pageBuilder);
            }
            Page page = this.pageBuilder.build();
            this.completedPositions += (long)page.getPositionCount();
            this.pageBuilder = this.pageBuilder.newPageBuilderLike();
            return page;
        }
        catch (TrinoException e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{this});
            throw e;
        }
        catch (IOException | RuntimeException e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{this});
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, String.format("Failed to read file at %s", this.filePath), (Throwable)e);
        }
    }

    public void close() throws IOException {
        this.lineReader.close();
    }

    public boolean isFinished() {
        return this.lineReader.isClosed();
    }

    public long getCompletedBytes() {
        return this.lineReader.getBytesRead();
    }

    public OptionalLong getCompletedPositions() {
        return OptionalLong.of(this.completedPositions);
    }

    public long getReadTimeNanos() {
        return this.lineReader.getReadTimeNanos();
    }

    public long getMemoryUsage() {
        return (long)INSTANCE_SIZE + this.lineReader.getRetainedSize() + this.lineBuffer.getRetainedSize() + this.pageBuilder.getRetainedSizeInBytes();
    }
}

