/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.trino.hive.thrift.metastore.FieldSchema;
import io.trino.hive.thrift.metastore.Table;
import io.trino.plugin.hive.HiveBasicStatistics;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreParameterParserUtils;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.plugin.hive.type.Category;
import io.trino.plugin.hive.type.PrimitiveCategory;
import io.trino.plugin.hive.type.PrimitiveTypeInfo;
import io.trino.plugin.hive.type.TypeInfo;
import java.util.AbstractMap;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalLong;

final class ThriftSparkMetastoreUtil {
    private static final String SPARK_SQL_STATS_PREFIX = "spark.sql.statistics.";
    private static final String COLUMN_STATS_PREFIX = "spark.sql.statistics.colStats.";
    private static final String NUM_FILES = "numFiles";
    private static final String RAW_DATA_SIZE = "rawDataSize";
    private static final String TOTAL_SIZE = "totalSize";
    private static final String COLUMN_MIN = "min";
    private static final String COLUMN_MAX = "max";

    private ThriftSparkMetastoreUtil() {
    }

    public static PartitionStatistics getTableStatistics(Table table) {
        Map parameters = table.getParameters();
        HiveBasicStatistics sparkBasicStatistics = ThriftSparkMetastoreUtil.getSparkBasicStatistics(parameters);
        if (sparkBasicStatistics.getRowCount().isEmpty()) {
            return PartitionStatistics.empty();
        }
        Map columnStatistics = (Map)table.getSd().getCols().stream().map(fieldSchema -> new AbstractMap.SimpleEntry<String, HiveColumnStatistics>(fieldSchema.getName(), ThriftSparkMetastoreUtil.fromMetastoreColumnStatistics(fieldSchema, parameters, sparkBasicStatistics.getRowCount().getAsLong()))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        return new PartitionStatistics(sparkBasicStatistics, columnStatistics);
    }

    public static HiveBasicStatistics getSparkBasicStatistics(Map<String, String> parameters) {
        OptionalLong rowCount = ThriftMetastoreParameterParserUtils.toLong(parameters.get("spark.sql.statistics.numRows"));
        if (rowCount.isEmpty()) {
            return HiveBasicStatistics.createEmptyStatistics();
        }
        OptionalLong fileCount = ThriftMetastoreParameterParserUtils.toLong(parameters.get("spark.sql.statistics.numFiles"));
        OptionalLong inMemoryDataSizeInBytes = ThriftMetastoreParameterParserUtils.toLong(parameters.get("spark.sql.statistics.rawDataSize"));
        OptionalLong onDiskDataSizeInBytes = ThriftMetastoreParameterParserUtils.toLong(parameters.get("spark.sql.statistics.totalSize"));
        return new HiveBasicStatistics(fileCount, rowCount, inMemoryDataSizeInBytes, onDiskDataSizeInBytes);
    }

    @VisibleForTesting
    static HiveColumnStatistics fromMetastoreColumnStatistics(FieldSchema fieldSchema, Map<String, String> columnStatistics, long rowCount) {
        HiveType type = HiveType.valueOf(fieldSchema.getType());
        TypeInfo typeInfo = type.getTypeInfo();
        if (typeInfo.getCategory() != Category.PRIMITIVE) {
            return HiveColumnStatistics.empty();
        }
        String field = COLUMN_STATS_PREFIX + fieldSchema.getName() + ".";
        OptionalLong maxLength = ThriftMetastoreParameterParserUtils.toLong(columnStatistics.get(field + "maxLen"));
        OptionalDouble avgLength = ThriftMetastoreParameterParserUtils.toDouble(columnStatistics.get(field + "avgLen"));
        OptionalLong nullsCount = ThriftMetastoreParameterParserUtils.toLong(columnStatistics.get(field + "nullCount"));
        OptionalLong distinctValuesCount = ThriftMetastoreParameterParserUtils.toLong(columnStatistics.get(field + "distinctCount"));
        return switch (((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory()) {
            default -> throw new IncompatibleClassChangeError();
            case PrimitiveCategory.BOOLEAN -> HiveColumnStatistics.createBooleanColumnStatistics(OptionalLong.empty(), OptionalLong.empty(), nullsCount);
            case PrimitiveCategory.BYTE, PrimitiveCategory.SHORT, PrimitiveCategory.INT, PrimitiveCategory.LONG -> HiveColumnStatistics.createIntegerColumnStatistics(ThriftMetastoreParameterParserUtils.toLong(columnStatistics.get(field + COLUMN_MIN)), ThriftMetastoreParameterParserUtils.toLong(columnStatistics.get(field + COLUMN_MAX)), nullsCount, ThriftSparkMetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount, nullsCount, rowCount));
            case PrimitiveCategory.TIMESTAMP -> HiveColumnStatistics.createIntegerColumnStatistics(OptionalLong.empty(), OptionalLong.empty(), nullsCount, ThriftSparkMetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount, nullsCount, rowCount));
            case PrimitiveCategory.FLOAT, PrimitiveCategory.DOUBLE -> HiveColumnStatistics.createDoubleColumnStatistics(ThriftMetastoreParameterParserUtils.toDouble(columnStatistics.get(field + COLUMN_MIN)), ThriftMetastoreParameterParserUtils.toDouble(columnStatistics.get(field + COLUMN_MAX)), nullsCount, ThriftSparkMetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount, nullsCount, rowCount));
            case PrimitiveCategory.STRING, PrimitiveCategory.VARCHAR, PrimitiveCategory.CHAR -> HiveColumnStatistics.createStringColumnStatistics(maxLength, ThriftMetastoreUtil.getTotalSizeInBytes(avgLength, OptionalLong.of(rowCount), nullsCount), nullsCount, ThriftSparkMetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount, nullsCount, rowCount));
            case PrimitiveCategory.DATE -> HiveColumnStatistics.createDateColumnStatistics(ThriftMetastoreParameterParserUtils.toDate(columnStatistics.get(field + COLUMN_MIN)), ThriftMetastoreParameterParserUtils.toDate(columnStatistics.get(field + COLUMN_MAX)), nullsCount, ThriftSparkMetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount, nullsCount, rowCount));
            case PrimitiveCategory.BINARY -> HiveColumnStatistics.createBinaryColumnStatistics(maxLength, ThriftMetastoreUtil.getTotalSizeInBytes(avgLength, OptionalLong.of(rowCount), nullsCount), nullsCount);
            case PrimitiveCategory.DECIMAL -> HiveColumnStatistics.createDecimalColumnStatistics(ThriftMetastoreParameterParserUtils.toDecimal(columnStatistics.get(field + COLUMN_MIN)), ThriftMetastoreParameterParserUtils.toDecimal(columnStatistics.get(field + COLUMN_MAX)), nullsCount, ThriftSparkMetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount, nullsCount, rowCount));
            case PrimitiveCategory.TIMESTAMPLOCALTZ, PrimitiveCategory.INTERVAL_YEAR_MONTH, PrimitiveCategory.INTERVAL_DAY_TIME, PrimitiveCategory.VOID, PrimitiveCategory.UNKNOWN -> HiveColumnStatistics.empty();
        };
    }

    private static OptionalLong fromMetastoreDistinctValuesCount(OptionalLong distinctValuesCount, OptionalLong nullsCount, long rowCount) {
        if (distinctValuesCount.isPresent() && nullsCount.isPresent()) {
            return OptionalLong.of(ThriftSparkMetastoreUtil.fromMetastoreDistinctValuesCount(distinctValuesCount.getAsLong(), nullsCount.getAsLong(), rowCount));
        }
        return OptionalLong.empty();
    }

    private static long fromMetastoreDistinctValuesCount(long distinctValuesCount, long nullsCount, long rowCount) {
        long nonNullsCount = rowCount - nullsCount;
        if (nonNullsCount > 0L && distinctValuesCount == 0L) {
            distinctValuesCount = 1L;
        }
        return Math.min(distinctValuesCount, nonNullsCount);
    }
}

