/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3select;

import io.trino.plugin.hive.s3select.S3SelectDataType;
import java.util.Map;
import java.util.Optional;

public class S3SelectSerDeDataTypeMapper {
    private static final Map<String, S3SelectDataType> serDeToDataTypeMapping = Map.of("org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe", S3SelectDataType.CSV, "org.apache.hive.hcatalog.data.JsonSerDe", S3SelectDataType.JSON);

    private S3SelectSerDeDataTypeMapper() {
    }

    public static Optional<S3SelectDataType> getDataType(String serdeName) {
        return Optional.ofNullable(serDeToDataTypeMapping.get(serdeName));
    }

    public static boolean doesSerDeExist(String serdeName) {
        return serDeToDataTypeMapping.containsKey(serdeName);
    }
}

