/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.hdfs;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.validation.FileExists;
import io.airlift.units.DataSize;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDataSize;
import java.io.File;
import java.util.List;
import javax.validation.constraints.NotNull;

public class ExchangeHdfsConfig {
    private DataSize hdfsStorageBlockSize = DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private List<File> resourceConfigFiles = ImmutableList.of();

    @NotNull
    @MinDataSize(value="4MB")
    @MaxDataSize(value="256MB")
    public @NotNull @MinDataSize(value="4MB") @MaxDataSize(value="256MB") DataSize getHdfsStorageBlockSize() {
        return this.hdfsStorageBlockSize;
    }

    @Config(value="exchange.hdfs.block-size")
    @ConfigDescription(value="Block size for HDFS storage")
    public ExchangeHdfsConfig setHdfsStorageBlockSize(DataSize hdfsStorageBlockSize) {
        this.hdfsStorageBlockSize = hdfsStorageBlockSize;
        return this;
    }

    public @NotNull List<@FileExists File> getResourceConfigFiles() {
        return this.resourceConfigFiles;
    }

    @Config(value="hdfs.config.resources")
    public ExchangeHdfsConfig setResourceConfigFiles(String files) {
        this.resourceConfigFiles = (List)Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)files).stream().map(File::new).collect(ImmutableList.toImmutableList());
        return this;
    }
}

