/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.spi.fop;

import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.fop.ObjectFactory;
import com.qubole.rubix.spi.fop.ObjectPool;
import com.qubole.rubix.spi.fop.PoolConfig;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.thrift.shaded.transport.TSocket;
import org.apache.thrift.shaded.transport.TTransportException;

public class SocketObjectFactory
implements ObjectFactory<TSocket> {
    private static final Log log = LogFactory.getLog((String)SocketObjectFactory.class.getName());
    private static final String BKS_POOL = "bks-pool";
    private final int port;

    public SocketObjectFactory(int port) {
        this.port = port;
    }

    @Override
    public TSocket create(String host, int socketTimeout, int connectTimeout) {
        log.debug((Object)("bks-pool : Opening connection to host: " + host));
        TSocket socket = null;
        try {
            socket = new TSocket(host, this.port, socketTimeout, connectTimeout);
            socket.open();
        }
        catch (TTransportException e) {
            socket = null;
            log.warn((Object)("Unable to open connection to host " + host), (Throwable)e);
        }
        return socket;
    }

    @Override
    public void destroy(TSocket o) {
        log.debug((Object)("bks-pool : Destroy socket channel: " + o));
        o.close();
    }

    @Override
    public boolean validate(TSocket o) {
        boolean isClosed;
        boolean bl = isClosed = o != null && !o.isOpen();
        if (isClosed && o != null) {
            try {
                o.getSocket().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        log.debug((Object)("bks-pool : Validate socket channel: " + o + " isvalid: " + !isClosed));
        return !isClosed;
    }

    public static ObjectPool<TSocket> createSocketObjectPool(Configuration conf, String host, int port) {
        log.debug((Object)"bks-pool : Creating socket object pool");
        PoolConfig poolConfig = new PoolConfig();
        poolConfig.setMaxSize(CacheConfig.getTranportPoolMaxSize(conf));
        poolConfig.setMinSize(CacheConfig.getTransportPoolMinSize(conf));
        poolConfig.setDelta(CacheConfig.getTransportPoolDeltaSize(conf));
        poolConfig.setMaxWaitMilliseconds(CacheConfig.getTransportPoolMaxWait(conf));
        poolConfig.setScavengeIntervalMilliseconds(CacheConfig.getScavengeInterval(conf));
        poolConfig.setConnectTimeoutMilliseconds(CacheConfig.getServerConnectTimeout(conf));
        poolConfig.setSocketTimeoutMilliseconds(CacheConfig.getServerSocketTimeout(conf));
        SocketObjectFactory factory = new SocketObjectFactory(port);
        ObjectPool<TSocket> pool = new ObjectPool<TSocket>(poolConfig, factory, BKS_POOL);
        pool.registerHost(host);
        return pool;
    }
}

