/*
 * Decompiled with CFR 0.152.
 */
package info.ganglia.gmetric4j.gmetric;

import info.ganglia.gmetric4j.gmetric.GMetricSlope;
import info.ganglia.gmetric4j.gmetric.GMetricType;
import info.ganglia.gmetric4j.gmetric.GangliaException;
import info.ganglia.gmetric4j.gmetric.Protocol;
import info.ganglia.gmetric4j.gmetric.Protocolv30x;
import info.ganglia.gmetric4j.gmetric.Protocolv31x;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.UUID;

public class GMetric {
    private Protocol protocol;

    public GMetric(String group, int port, UDPAddressingMode mode, int ttl) {
        this(group, port, mode, ttl, true);
    }

    public GMetric(String group, int port, UDPAddressingMode mode, int ttl, boolean ganglia311) {
        this(group, port, mode, ttl, ganglia311, null);
    }

    public GMetric(String group, int port, UDPAddressingMode mode, int ttl, boolean ganglia311, UUID uuid) {
        this.protocol = !ganglia311 ? new Protocolv30x(group, port, mode, ttl) : new Protocolv31x(group, port, mode, ttl, 5, uuid);
    }

    public void announce(String name, String value, GMetricType type, String units, GMetricSlope slope, int tmax, int dmax, String group) throws GangliaException {
        try {
            this.protocol.announce(name, value, type, units, slope, tmax, dmax, group);
        }
        catch (Exception ex) {
            throw new GangliaException("Exception announcing metric", ex);
        }
    }

    public void announce(String name, int value, String group) throws GangliaException {
        this.announce(name, Integer.toString(value), GMetricType.INT32, "", GMetricSlope.BOTH, 60, 0, group);
    }

    public void announce(String name, long value, String group) throws GangliaException {
        this.announce(name, Long.toString(value), GMetricType.DOUBLE, "", GMetricSlope.BOTH, 60, 0, group);
    }

    public void announce(String name, float value, String group) throws GangliaException {
        this.announce(name, Float.toString(value), GMetricType.FLOAT, "", GMetricSlope.BOTH, 60, 0, group);
    }

    public void announce(String name, double value, String group) throws GangliaException {
        this.announce(name, Double.toString(value), GMetricType.DOUBLE, "", GMetricSlope.BOTH, 60, 0, group);
    }

    public static void main(String[] args) {
        try {
            GMetric gm = new GMetric("239.2.11.71", 8649, UDPAddressingMode.MULTICAST, 1);
            gm.announce("BOILINGPOINT", "100", GMetricType.STRING, "CELSIUS", GMetricSlope.BOTH, 0, 0, "TESTGROUP");
            gm.announce("INTTEST", Integer.MAX_VALUE, "TESTGROUP");
            gm.announce("LONGTEST", Long.MAX_VALUE, "TESTGROUP");
            gm.announce("FLOATTEST", Float.MAX_VALUE, "TESTGROUP");
            gm.announce("DOUBLETEST", (double)Double.MAX_VALUE, "TESTGROUP");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UDPAddressingMode {
        MULTICAST,
        UNICAST;


        public static UDPAddressingMode getModeForAddress(String addr) throws UnknownHostException {
            InetAddress _addr = InetAddress.getByName(addr);
            if (_addr.isMulticastAddress()) {
                return MULTICAST;
            }
            return UNICAST;
        }
    }
}

