/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index.mutable.provider;

import java.util.Objects;
import org.apache.pinot.segment.spi.memory.PinotDataBufferMemoryManager;
import org.apache.pinot.spi.data.FieldSpec;

public interface MutableIndexContext {
    public PinotDataBufferMemoryManager getMemoryManager();

    public FieldSpec getFieldSpec();

    public String getSegmentName();

    public boolean hasDictionary();

    public int getCapacity();

    public boolean isOffHeap();

    public static Builder builder() {
        return new Builder();
    }

    public static class Text
    extends Wrapper {
        public Text(MutableIndexContext wrapped) {
            super(wrapped);
        }
    }

    public static class Json
    extends Wrapper {
        public Json(MutableIndexContext wrapped) {
            super(wrapped);
        }
    }

    public static class Inverted
    extends Wrapper {
        public Inverted(MutableIndexContext wrapped) {
            super(wrapped);
        }
    }

    public static class Forward
    extends Wrapper {
        private final int _avgNumMultiValues;

        public Forward(MutableIndexContext wrapped, int avgNumMultiValues) {
            super(wrapped);
            this._avgNumMultiValues = avgNumMultiValues;
        }

        public int getAvgNumMultiValues() {
            return this._avgNumMultiValues;
        }
    }

    public static class Dictionary
    extends Wrapper {
        private final int _estimatedColSize;
        private final int _estimatedCardinality;

        public Dictionary(MutableIndexContext wrapped, int estimatedColSize, int estimatedCardinality) {
            super(wrapped);
            this._estimatedColSize = estimatedColSize;
            this._estimatedCardinality = estimatedCardinality;
        }

        public int getEstimatedColSize() {
            return this._estimatedColSize;
        }

        public int getEstimatedCardinality() {
            return this._estimatedCardinality;
        }
    }

    public static class Wrapper
    implements MutableIndexContext {
        private final MutableIndexContext _wrapped;

        public Wrapper(MutableIndexContext wrapped) {
            this._wrapped = wrapped;
        }

        @Override
        public PinotDataBufferMemoryManager getMemoryManager() {
            return this._wrapped.getMemoryManager();
        }

        @Override
        public FieldSpec getFieldSpec() {
            return this._wrapped.getFieldSpec();
        }

        @Override
        public String getSegmentName() {
            return this._wrapped.getSegmentName();
        }

        @Override
        public boolean hasDictionary() {
            return this._wrapped.hasDictionary();
        }

        @Override
        public int getCapacity() {
            return this._wrapped.getCapacity();
        }

        @Override
        public boolean isOffHeap() {
            return this._wrapped.isOffHeap();
        }
    }

    public static final class Common
    implements MutableIndexContext {
        private final int _capacity;
        private final FieldSpec _fieldSpec;
        private final boolean _hasDictionary;
        private final boolean _offHeap;
        private final String _segmentName;
        private final PinotDataBufferMemoryManager _memoryManager;

        public Common(FieldSpec fieldSpec, boolean hasDictionary, String segmentName, PinotDataBufferMemoryManager memoryManager, int capacity, boolean offHeap) {
            this._fieldSpec = fieldSpec;
            this._hasDictionary = hasDictionary;
            this._segmentName = segmentName;
            this._memoryManager = memoryManager;
            this._capacity = capacity;
            this._offHeap = offHeap;
        }

        @Override
        public PinotDataBufferMemoryManager getMemoryManager() {
            return this._memoryManager;
        }

        @Override
        public String getSegmentName() {
            return this._segmentName;
        }

        @Override
        public FieldSpec getFieldSpec() {
            return this._fieldSpec;
        }

        @Override
        public boolean hasDictionary() {
            return this._hasDictionary;
        }

        @Override
        public int getCapacity() {
            return this._capacity;
        }

        @Override
        public boolean isOffHeap() {
            return this._offHeap;
        }

        public Dictionary forDictionary(int estimatedColSize, int estimatedCardinality) {
            return new Dictionary(this, estimatedColSize, estimatedCardinality);
        }

        public Forward forForwardIndex(int avgNumMultiValues) {
            return new Forward(this, avgNumMultiValues);
        }

        public Inverted forInvertedIndex() {
            return new Inverted(this);
        }

        public Json forJsonIndex() {
            return new Json(this);
        }

        public Text forTextIndex() {
            return new Text(this);
        }
    }

    public static class Builder {
        private FieldSpec _fieldSpec;
        private String _segmentName;
        private boolean _hasDictionary = true;
        private boolean _offHeap = true;
        private int _capacity;
        private PinotDataBufferMemoryManager _memoryManager;

        public Builder withMemoryManager(PinotDataBufferMemoryManager memoryManager) {
            this._memoryManager = memoryManager;
            return this;
        }

        public Builder withFieldSpec(FieldSpec fieldSpec) {
            this._fieldSpec = fieldSpec;
            return this;
        }

        public Builder withSegmentName(String segmentName) {
            this._segmentName = segmentName;
            return this;
        }

        public Builder withDictionary(boolean hasDictionary) {
            this._hasDictionary = hasDictionary;
            return this;
        }

        public Builder offHeap(boolean offHeap) {
            this._offHeap = offHeap;
            return this;
        }

        public Builder withCapacity(int capacity) {
            this._capacity = capacity;
            return this;
        }

        public Common build() {
            return new Common(Objects.requireNonNull(this._fieldSpec), this._hasDictionary, Objects.requireNonNull(this._segmentName), Objects.requireNonNull(this._memoryManager), this._capacity, this._offHeap);
        }
    }
}

