/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index.reader;

import java.io.Closeable;
import java.math.BigDecimal;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BigDecimalUtils;

public interface ForwardIndexReader<T extends ForwardIndexReaderContext>
extends Closeable {
    public boolean isDictionaryEncoded();

    public boolean isSingleValue();

    public FieldSpec.DataType getStoredType();

    @Nullable
    default public T createContext() {
        return null;
    }

    default public int getDictId(int docId, T context) {
        throw new UnsupportedOperationException();
    }

    default public void readDictIds(int[] docIds, int length, int[] dictIdBuffer, T context) {
        throw new UnsupportedOperationException();
    }

    default public int getDictIdMV(int docId, int[] dictIdBuffer, T context) {
        throw new UnsupportedOperationException();
    }

    default public int[] getDictIdMV(int docId, T context) {
        throw new UnsupportedOperationException();
    }

    default public void readValuesSV(int[] docIds, int length, int[] values, T context) {
        switch (this.getStoredType()) {
            case INT: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getInt(docIds[i], context);
                }
                break;
            }
            case LONG: {
                for (int i = 0; i < length; ++i) {
                    values[i] = (int)this.getLong(docIds[i], context);
                }
                break;
            }
            case FLOAT: {
                for (int i = 0; i < length; ++i) {
                    values[i] = (int)this.getFloat(docIds[i], context);
                }
                break;
            }
            case DOUBLE: {
                for (int i = 0; i < length; ++i) {
                    values[i] = (int)this.getDouble(docIds[i], context);
                }
                break;
            }
            case BIG_DECIMAL: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getBigDecimal(docIds[i], context).intValue();
                }
                break;
            }
            case STRING: {
                for (int i = 0; i < length; ++i) {
                    values[i] = Integer.parseInt(this.getString(docIds[i], context));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    default public void readValuesSV(int[] docIds, int length, long[] values, T context) {
        switch (this.getStoredType()) {
            case INT: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getInt(docIds[i], context);
                }
                break;
            }
            case LONG: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getLong(docIds[i], context);
                }
                break;
            }
            case FLOAT: {
                for (int i = 0; i < length; ++i) {
                    values[i] = (long)this.getFloat(docIds[i], context);
                }
                break;
            }
            case DOUBLE: {
                for (int i = 0; i < length; ++i) {
                    values[i] = (long)this.getDouble(docIds[i], context);
                }
                break;
            }
            case BIG_DECIMAL: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getBigDecimal(docIds[i], context).longValue();
                }
                break;
            }
            case STRING: {
                for (int i = 0; i < length; ++i) {
                    values[i] = Long.parseLong(this.getString(docIds[i], context));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    default public void readValuesSV(int[] docIds, int length, float[] values, T context) {
        switch (this.getStoredType()) {
            case INT: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getInt(docIds[i], context);
                }
                break;
            }
            case LONG: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getLong(docIds[i], context);
                }
                break;
            }
            case FLOAT: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getFloat(docIds[i], context);
                }
                break;
            }
            case DOUBLE: {
                for (int i = 0; i < length; ++i) {
                    values[i] = (float)this.getDouble(docIds[i], context);
                }
                break;
            }
            case BIG_DECIMAL: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getBigDecimal(docIds[i], context).floatValue();
                }
                break;
            }
            case STRING: {
                for (int i = 0; i < length; ++i) {
                    values[i] = Float.parseFloat(this.getString(docIds[i], context));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    default public void readValuesSV(int[] docIds, int length, double[] values, T context) {
        switch (this.getStoredType()) {
            case INT: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getInt(docIds[i], context);
                }
                break;
            }
            case LONG: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getLong(docIds[i], context);
                }
                break;
            }
            case FLOAT: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getFloat(docIds[i], context);
                }
                break;
            }
            case DOUBLE: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getDouble(docIds[i], context);
                }
                break;
            }
            case BIG_DECIMAL: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getBigDecimal(docIds[i], context).doubleValue();
                }
                break;
            }
            case STRING: {
                for (int i = 0; i < length; ++i) {
                    values[i] = Double.parseDouble(this.getString(docIds[i], context));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    default public void readValuesSV(int[] docIds, int length, BigDecimal[] values, T context) {
        switch (this.getStoredType()) {
            case INT: {
                for (int i = 0; i < length; ++i) {
                    values[i] = BigDecimal.valueOf(this.getInt(docIds[i], context));
                }
                break;
            }
            case LONG: {
                for (int i = 0; i < length; ++i) {
                    values[i] = BigDecimal.valueOf(this.getLong(docIds[i], context));
                }
                break;
            }
            case FLOAT: {
                for (int i = 0; i < length; ++i) {
                    values[i] = BigDecimal.valueOf(this.getFloat(docIds[i], context));
                }
                break;
            }
            case DOUBLE: {
                for (int i = 0; i < length; ++i) {
                    values[i] = BigDecimal.valueOf(this.getDouble(docIds[i], context));
                }
                break;
            }
            case STRING: {
                for (int i = 0; i < length; ++i) {
                    values[i] = new BigDecimal(this.getString(docIds[i], context));
                }
                break;
            }
            case BIG_DECIMAL: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getBigDecimal(docIds[i], context);
                }
                break;
            }
            case BYTES: {
                for (int i = 0; i < length; ++i) {
                    values[i] = BigDecimalUtils.deserialize((byte[])this.getBytes(docIds[i], context));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    default public int getInt(int docId, T context) {
        throw new UnsupportedOperationException();
    }

    default public long getLong(int docId, T context) {
        throw new UnsupportedOperationException();
    }

    default public float getFloat(int docId, T context) {
        throw new UnsupportedOperationException();
    }

    default public double getDouble(int docId, T context) {
        throw new UnsupportedOperationException();
    }

    default public BigDecimal getBigDecimal(int docId, T context) {
        throw new UnsupportedOperationException();
    }

    default public String getString(int docId, T context) {
        throw new UnsupportedOperationException();
    }

    default public byte[] getBytes(int docId, T context) {
        throw new UnsupportedOperationException();
    }

    default public void readValuesMV(int[] docIds, int length, int maxNumValuesPerMVEntry, int[][] values, T context) {
        switch (this.getStoredType()) {
            case INT: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getIntMV(docIds[i], context);
                }
                break;
            }
            case LONG: {
                long[] longValueBuffer = new long[maxNumValuesPerMVEntry];
                for (int i = 0; i < length; ++i) {
                    int numValues = this.getLongMV(docIds[i], longValueBuffer, context);
                    values[i] = new int[numValues];
                    for (int j = 0; j < numValues; ++j) {
                        values[i][j] = (int)longValueBuffer[j];
                    }
                }
                break;
            }
            case FLOAT: {
                float[] floatValueBuffer = new float[maxNumValuesPerMVEntry];
                for (int i = 0; i < length; ++i) {
                    int numValues = this.getFloatMV(docIds[i], floatValueBuffer, context);
                    values[i] = new int[numValues];
                    for (int j = 0; j < numValues; ++j) {
                        values[i][j] = (int)floatValueBuffer[j];
                    }
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValueBuffer = new double[maxNumValuesPerMVEntry];
                for (int i = 0; i < length; ++i) {
                    int numValues = this.getDoubleMV(docIds[i], doubleValueBuffer, context);
                    values[i] = new int[numValues];
                    for (int j = 0; j < numValues; ++j) {
                        values[i][j] = (int)doubleValueBuffer[j];
                    }
                }
                break;
            }
            case STRING: {
                String[] stringValueBuffer = new String[maxNumValuesPerMVEntry];
                for (int i = 0; i < length; ++i) {
                    int numValues = this.getStringMV(docIds[i], stringValueBuffer, context);
                    values[i] = new int[numValues];
                    for (int j = 0; j < numValues; ++j) {
                        values[i][j] = Integer.parseInt(stringValueBuffer[j]);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("readValuesMV not supported for type " + this.getStoredType());
            }
        }
    }

    default public void readValuesMV(int[] docIds, int length, int maxNumValuesPerMVEntry, long[][] values, T context) {
        switch (this.getStoredType()) {
            case INT: {
                int[] intValueBuffer = new int[maxNumValuesPerMVEntry];
                for (int i = 0; i < length; ++i) {
                    int numValues = this.getIntMV(docIds[i], intValueBuffer, context);
                    values[i] = new long[numValues];
                    for (int j = 0; j < numValues; ++j) {
                        values[i][j] = intValueBuffer[j];
                    }
                }
                break;
            }
            case LONG: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getLongMV(docIds[i], context);
                }
                break;
            }
            case FLOAT: {
                float[] floatValueBuffer = new float[maxNumValuesPerMVEntry];
                for (int i = 0; i < length; ++i) {
                    int numValues = this.getFloatMV(docIds[i], floatValueBuffer, context);
                    values[i] = new long[numValues];
                    for (int j = 0; j < numValues; ++j) {
                        values[i][j] = (long)floatValueBuffer[j];
                    }
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValueBuffer = new double[maxNumValuesPerMVEntry];
                for (int i = 0; i < length; ++i) {
                    int numValues = this.getDoubleMV(docIds[i], doubleValueBuffer, context);
                    values[i] = new long[numValues];
                    for (int j = 0; j < numValues; ++j) {
                        values[i][j] = (long)doubleValueBuffer[j];
                    }
                }
                break;
            }
            case STRING: {
                String[] stringValueBuffer = new String[maxNumValuesPerMVEntry];
                for (int i = 0; i < length; ++i) {
                    int numValues = this.getStringMV(docIds[i], stringValueBuffer, context);
                    values[i] = new long[numValues];
                    for (int j = 0; j < numValues; ++j) {
                        values[i][j] = Long.parseLong(stringValueBuffer[j]);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("readValuesMV not supported for type " + this.getStoredType());
            }
        }
    }

    default public void readValuesMV(int[] docIds, int length, int maxNumValuesPerMVEntry, float[][] values, T context) {
        switch (this.getStoredType()) {
            case INT: {
                int[] intValueBuffer = new int[maxNumValuesPerMVEntry];
                for (int i = 0; i < length; ++i) {
                    int numValues = this.getIntMV(docIds[i], intValueBuffer, context);
                    values[i] = new float[numValues];
                    for (int j = 0; j < numValues; ++j) {
                        values[i][j] = intValueBuffer[j];
                    }
                }
                break;
            }
            case LONG: {
                long[] longValueBuffer = new long[maxNumValuesPerMVEntry];
                for (int i = 0; i < length; ++i) {
                    int numValues = this.getLongMV(docIds[i], longValueBuffer, context);
                    values[i] = new float[numValues];
                    for (int j = 0; j < numValues; ++j) {
                        values[i][j] = longValueBuffer[j];
                    }
                }
                break;
            }
            case FLOAT: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getFloatMV(docIds[i], context);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValueBuffer = new double[maxNumValuesPerMVEntry];
                for (int i = 0; i < length; ++i) {
                    int numValues = this.getDoubleMV(docIds[i], doubleValueBuffer, context);
                    values[i] = new float[numValues];
                    for (int j = 0; j < numValues; ++j) {
                        values[i][j] = (float)doubleValueBuffer[j];
                    }
                }
                break;
            }
            case STRING: {
                String[] stringValueBuffer = new String[maxNumValuesPerMVEntry];
                for (int i = 0; i < length; ++i) {
                    int numValues = this.getStringMV(docIds[i], stringValueBuffer, context);
                    values[i] = new float[numValues];
                    for (int j = 0; j < numValues; ++j) {
                        values[i][j] = Float.parseFloat(stringValueBuffer[j]);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("readValuesMV not supported for type " + this.getStoredType());
            }
        }
    }

    default public void readValuesMV(int[] docIds, int length, int maxNumValuesPerMVEntry, double[][] values, T context) {
        switch (this.getStoredType()) {
            case INT: {
                int[] intValueBuffer = new int[maxNumValuesPerMVEntry];
                for (int i = 0; i < length; ++i) {
                    int numValues = this.getIntMV(docIds[i], intValueBuffer, context);
                    values[i] = new double[numValues];
                    for (int j = 0; j < numValues; ++j) {
                        values[i][j] = intValueBuffer[j];
                    }
                }
                break;
            }
            case LONG: {
                long[] longValueBuffer = new long[maxNumValuesPerMVEntry];
                for (int i = 0; i < length; ++i) {
                    int numValues = this.getLongMV(docIds[i], longValueBuffer, context);
                    values[i] = new double[numValues];
                    for (int j = 0; j < numValues; ++j) {
                        values[i][j] = longValueBuffer[j];
                    }
                }
                break;
            }
            case FLOAT: {
                float[] floatValueBuffer = new float[maxNumValuesPerMVEntry];
                for (int i = 0; i < length; ++i) {
                    int numValues = this.getFloatMV(docIds[i], floatValueBuffer, context);
                    values[i] = new double[numValues];
                    for (int j = 0; j < numValues; ++j) {
                        values[i][j] = floatValueBuffer[j];
                    }
                }
                break;
            }
            case DOUBLE: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getDoubleMV(docIds[i], context);
                }
                break;
            }
            case STRING: {
                String[] stringValueBuffer = new String[maxNumValuesPerMVEntry];
                for (int i = 0; i < length; ++i) {
                    int numValues = this.getStringMV(docIds[i], stringValueBuffer, context);
                    values[i] = new double[numValues];
                    for (int j = 0; j < numValues; ++j) {
                        values[i][j] = Double.parseDouble(stringValueBuffer[j]);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("readValuesMV not supported for type " + this.getStoredType());
            }
        }
    }

    default public void readValuesMV(int[] docIds, int length, int maxNumValuesPerMVEntry, String[][] values, T context) {
        switch (this.getStoredType()) {
            case INT: {
                int[] intValueBuffer = new int[maxNumValuesPerMVEntry];
                for (int i = 0; i < length; ++i) {
                    int numValues = this.getIntMV(docIds[i], intValueBuffer, context);
                    values[i] = new String[numValues];
                    for (int j = 0; j < numValues; ++j) {
                        values[i][j] = String.valueOf(intValueBuffer[j]);
                    }
                }
                break;
            }
            case LONG: {
                long[] longValueBuffer = new long[maxNumValuesPerMVEntry];
                for (int i = 0; i < length; ++i) {
                    int numValues = this.getLongMV(docIds[i], longValueBuffer, context);
                    values[i] = new String[numValues];
                    for (int j = 0; j < numValues; ++j) {
                        values[i][j] = String.valueOf(longValueBuffer[j]);
                    }
                }
                break;
            }
            case FLOAT: {
                float[] floatValueBuffer = new float[maxNumValuesPerMVEntry];
                for (int i = 0; i < length; ++i) {
                    int numValues = this.getFloatMV(docIds[i], floatValueBuffer, context);
                    values[i] = new String[numValues];
                    for (int j = 0; j < numValues; ++j) {
                        values[i][j] = String.valueOf(floatValueBuffer[j]);
                    }
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValueBuffer = new double[maxNumValuesPerMVEntry];
                for (int i = 0; i < length; ++i) {
                    int numValues = this.getDoubleMV(docIds[i], doubleValueBuffer, context);
                    values[i] = new String[numValues];
                    for (int j = 0; j < numValues; ++j) {
                        values[i][j] = String.valueOf(doubleValueBuffer[j]);
                    }
                }
                break;
            }
            case STRING: {
                for (int i = 0; i < length; ++i) {
                    values[i] = this.getStringMV(docIds[i], context);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("readValuesMV not supported for type " + this.getStoredType());
            }
        }
    }

    default public int getIntMV(int docId, int[] valueBuffer, T context) {
        throw new UnsupportedOperationException();
    }

    default public int[] getIntMV(int docId, T context) {
        throw new UnsupportedOperationException();
    }

    default public int getLongMV(int docId, long[] valueBuffer, T context) {
        throw new UnsupportedOperationException();
    }

    default public long[] getLongMV(int docId, T context) {
        throw new UnsupportedOperationException();
    }

    default public int getFloatMV(int docId, float[] valueBuffer, T context) {
        throw new UnsupportedOperationException();
    }

    default public float[] getFloatMV(int docId, T context) {
        throw new UnsupportedOperationException();
    }

    default public int getDoubleMV(int docId, double[] valueBuffer, T context) {
        throw new UnsupportedOperationException();
    }

    default public double[] getDoubleMV(int docId, T context) {
        throw new UnsupportedOperationException();
    }

    default public int getStringMV(int docId, String[] valueBuffer, T context) {
        throw new UnsupportedOperationException();
    }

    default public String[] getStringMV(int docId, T context) {
        throw new UnsupportedOperationException();
    }

    default public int getBytesMV(int docId, byte[][] valueBuffer, T context) {
        throw new UnsupportedOperationException();
    }

    default public byte[][] getBytesMV(int docId, T context) {
        throw new UnsupportedOperationException();
    }

    default public int getNumValuesMV(int docId, T context) {
        throw new UnsupportedOperationException();
    }
}

