/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.exception.HoodieException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ReflectionUtils {
    private static final Logger LOG = LogManager.getLogger(ReflectionUtils.class);
    private static final Map<String, Class<?>> CLAZZ_CACHE = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> getClass(String clazzName) {
        Map<String, Class<?>> map = CLAZZ_CACHE;
        synchronized (map) {
            if (!CLAZZ_CACHE.containsKey(clazzName)) {
                try {
                    Class<?> clazz = Class.forName(clazzName);
                    CLAZZ_CACHE.put(clazzName, clazz);
                }
                catch (ClassNotFoundException e) {
                    throw new HoodieException("Unable to load class", e);
                }
            }
        }
        return CLAZZ_CACHE.get(clazzName);
    }

    public static <T> T loadClass(String className) {
        try {
            return (T)ReflectionUtils.getClass(className).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new HoodieException("Could not load class " + className, e);
        }
    }

    public static <T extends HoodieRecordPayload> T loadPayload(String recordPayloadClass, Object[] payloadArgs, Class<?> ... constructorArgTypes) {
        try {
            return (T)((HoodieRecordPayload)ReflectionUtils.getClass(recordPayloadClass).getConstructor(constructorArgTypes).newInstance(payloadArgs));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new HoodieException("Unable to instantiate payload class ", e);
        }
    }

    public static Object loadClass(String clazz, Class<?>[] constructorArgTypes, Object ... constructorArgs) {
        try {
            return ReflectionUtils.getClass(clazz).getConstructor(constructorArgTypes).newInstance(constructorArgs);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new HoodieException("Unable to instantiate class " + clazz, e);
        }
    }

    public static boolean hasConstructor(String clazz, Class<?>[] constructorArgTypes) {
        try {
            ReflectionUtils.getClass(clazz).getConstructor(constructorArgTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            LOG.warn((Object)("Unable to instantiate class " + clazz), (Throwable)e);
            return false;
        }
    }

    public static Object loadClass(String clazz, Object ... constructorArgs) {
        Class[] constructorArgTypes = (Class[])Arrays.stream(constructorArgs).map(Object::getClass).toArray(Class[]::new);
        return ReflectionUtils.loadClass(clazz, constructorArgTypes, constructorArgs);
    }

    public static Stream<String> getTopLevelClassesInClasspath(Class<?> clazz) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String packageName = clazz.getPackage().getName();
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = null;
        try {
            resources = classLoader.getResources(path);
        }
        catch (IOException e) {
            LOG.error((Object)("Unable to fetch Resources in package " + e.getMessage()));
        }
        ArrayList<File> directories = new ArrayList<File>();
        while (Objects.requireNonNull(resources).hasMoreElements()) {
            URL resource = resources.nextElement();
            try {
                directories.add(new File(resource.toURI()));
            }
            catch (URISyntaxException e) {
                LOG.error((Object)("Unable to get " + e.getMessage()));
            }
        }
        ArrayList<String> classes = new ArrayList<String>();
        for (File directory : directories) {
            classes.addAll(ReflectionUtils.findClasses(directory, packageName));
        }
        return classes.stream();
    }

    private static List<String> findClasses(File directory, String packageName) {
        ArrayList<String> classes = new ArrayList<String>();
        if (!directory.exists()) {
            return classes;
        }
        File[] files = directory.listFiles();
        for (File file : Objects.requireNonNull(files)) {
            if (file.isDirectory()) {
                classes.addAll(ReflectionUtils.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(packageName + '.' + file.getName().substring(0, file.getName().length() - 6));
        }
        return classes;
    }

    public static boolean isSameClass(Comparable<?> v, Comparable<?> o) {
        return v.getClass() == o.getClass();
    }
}

