/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.avro.AvroTypeException;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.ConvertingGenericData;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieColumnRangeMetadata;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieDeltaWriteStat;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ParquetUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.metadata.MetadataRecordsGenerationParams;
import org.apache.hudi.util.Lazy;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieTableMetadataUtil {
    private static final Logger LOG = LogManager.getLogger(HoodieTableMetadataUtil.class);
    public static final String PARTITION_NAME_FILES = "files";
    public static final String PARTITION_NAME_COLUMN_STATS = "column_stats";
    public static final String PARTITION_NAME_BLOOM_FILTERS = "bloom_filters";

    public static boolean isFilesPartitionAvailable(HoodieTableMetaClient metaClient) {
        return metaClient.getTableConfig().getMetadataPartitions().contains(PARTITION_NAME_FILES);
    }

    public static Map<String, HoodieColumnRangeMetadata<Comparable>> collectColumnRangeMetadata(List<IndexedRecord> records, List<Schema.Field> targetFields, String filePath) {
        class ColumnStats {
            Object minValue;
            Object maxValue;
            long nullCount;
            long valueCount;

            ColumnStats() {
            }
        }
        HashMap allColumnStats = new HashMap();
        records.forEach(record -> targetFields.forEach(field -> {
            ColumnStats colStats = allColumnStats.computeIfAbsent(field.name(), ignored -> new ColumnStats());
            GenericRecord genericRecord = (GenericRecord)record;
            Object fieldVal = HoodieAvroUtils.convertValueForSpecificDataTypes(field.schema(), genericRecord.get(field.name()), false);
            Schema fieldSchema = HoodieAvroUtils.getNestedFieldSchemaFromWriteSchema(genericRecord.getSchema(), field.name());
            if (fieldVal != null && HoodieTableMetadataUtil.canCompare(fieldSchema)) {
                if (colStats.minValue == null || ConvertingGenericData.INSTANCE.compare(fieldVal, colStats.minValue, fieldSchema) < 0) {
                    colStats.minValue = fieldVal;
                }
                if (colStats.maxValue == null || ConvertingGenericData.INSTANCE.compare(fieldVal, colStats.maxValue, fieldSchema) > 0) {
                    colStats.maxValue = fieldVal;
                }
                ++colStats.valueCount;
            } else {
                ++colStats.nullCount;
            }
        }));
        Collector collector = Collectors.toMap(colRangeMetadata -> colRangeMetadata.getColumnName(), Function.identity());
        return targetFields.stream().map(field -> {
            ColumnStats colStats = (ColumnStats)allColumnStats.get(field.name());
            return HoodieColumnRangeMetadata.create(filePath, field.name(), colStats == null ? null : HoodieTableMetadataUtil.coerceToComparable(field.schema(), colStats.minValue), colStats == null ? null : HoodieTableMetadataUtil.coerceToComparable(field.schema(), colStats.maxValue), colStats == null ? 0L : colStats.nullCount, colStats == null ? 0L : colStats.valueCount, 0L, 0L);
        }).collect(collector);
    }

    public static HoodieColumnRangeMetadata<Comparable> convertColumnStatsRecordToColumnRangeMetadata(HoodieMetadataColumnStats columnStats) {
        return HoodieColumnRangeMetadata.create(columnStats.getFileName(), columnStats.getColumnName(), HoodieMetadataPayload.unwrapStatisticValueWrapper(columnStats.getMinValue()), HoodieMetadataPayload.unwrapStatisticValueWrapper(columnStats.getMaxValue()), columnStats.getNullCount(), columnStats.getValueCount(), columnStats.getTotalSize(), columnStats.getTotalUncompressedSize());
    }

    public static void deleteMetadataTable(String basePath, HoodieEngineContext context) {
        String metadataTablePathStr = HoodieTableMetadata.getMetadataTableBasePath(basePath);
        FileSystem fs = FSUtils.getFs(metadataTablePathStr, context.getHadoopConf().get());
        try {
            Path metadataTablePath = new Path(metadataTablePathStr);
            if (fs.exists(metadataTablePath)) {
                fs.delete(metadataTablePath, true);
            }
        }
        catch (Exception e) {
            throw new HoodieMetadataException("Failed to remove metadata table from path " + metadataTablePathStr, e);
        }
    }

    public static void deleteMetadataPartition(String basePath, HoodieEngineContext context, MetadataPartitionType partitionType) {
        String metadataTablePath = HoodieTableMetadata.getMetadataTableBasePath(basePath);
        FileSystem fs = FSUtils.getFs(metadataTablePath, context.getHadoopConf().get());
        try {
            fs.delete(new Path(metadataTablePath, partitionType.getPartitionPath()), true);
        }
        catch (Exception e) {
            throw new HoodieMetadataException(String.format("Failed to remove metadata partition %s from path %s", new Object[]{partitionType, metadataTablePath}), e);
        }
    }

    public static boolean metadataPartitionExists(String basePath, HoodieEngineContext context, MetadataPartitionType partitionType) {
        String metadataTablePath = HoodieTableMetadata.getMetadataTableBasePath(basePath);
        FileSystem fs = FSUtils.getFs(metadataTablePath, context.getHadoopConf().get());
        try {
            return fs.exists(new Path(metadataTablePath, partitionType.getPartitionPath()));
        }
        catch (Exception e) {
            throw new HoodieIOException(String.format("Failed to check metadata partition %s exists.", partitionType.getPartitionPath()));
        }
    }

    public static Map<MetadataPartitionType, HoodieData<HoodieRecord>> convertMetadataToRecords(HoodieEngineContext context, HoodieCommitMetadata commitMetadata, String instantTime, MetadataRecordsGenerationParams recordsGenerationParams) {
        HashMap<MetadataPartitionType, HoodieData<HoodieRecord>> partitionToRecordsMap = new HashMap<MetadataPartitionType, HoodieData<HoodieRecord>>();
        HoodieData<HoodieRecord> filesPartitionRecordsRDD = context.parallelize(HoodieTableMetadataUtil.convertMetadataToFilesPartitionRecords(commitMetadata, instantTime), 1);
        partitionToRecordsMap.put(MetadataPartitionType.FILES, filesPartitionRecordsRDD);
        if (recordsGenerationParams.getEnabledPartitionTypes().contains((Object)MetadataPartitionType.BLOOM_FILTERS)) {
            HoodieData<HoodieRecord> metadataBloomFilterRecords = HoodieTableMetadataUtil.convertMetadataToBloomFilterRecords(context, commitMetadata, instantTime, recordsGenerationParams);
            partitionToRecordsMap.put(MetadataPartitionType.BLOOM_FILTERS, metadataBloomFilterRecords);
        }
        if (recordsGenerationParams.getEnabledPartitionTypes().contains((Object)MetadataPartitionType.COLUMN_STATS)) {
            HoodieData<HoodieRecord> metadataColumnStatsRDD = HoodieTableMetadataUtil.convertMetadataToColumnStatsRecords(commitMetadata, context, recordsGenerationParams);
            partitionToRecordsMap.put(MetadataPartitionType.COLUMN_STATS, metadataColumnStatsRDD);
        }
        return partitionToRecordsMap;
    }

    public static List<HoodieRecord> convertMetadataToFilesPartitionRecords(HoodieCommitMetadata commitMetadata, String instantTime) {
        ArrayList<HoodieRecord> records = new ArrayList<HoodieRecord>(commitMetadata.getPartitionToWriteStats().size());
        List<String> partitionsAdded = HoodieTableMetadataUtil.getPartitionsAdded(commitMetadata);
        List<String> partitionsDeleted = HoodieTableMetadataUtil.getPartitionsDeleted(commitMetadata);
        records.add(HoodieMetadataPayload.createPartitionListRecord(partitionsAdded, partitionsDeleted));
        List updatedPartitionFilesRecords = commitMetadata.getPartitionToWriteStats().entrySet().stream().map(entry -> {
            String partitionStatName = (String)entry.getKey();
            List writeStats = (List)entry.getValue();
            String partition = HoodieTableMetadataUtil.getPartitionIdentifier(partitionStatName);
            HashMap updatedFilesToSizesMapping = writeStats.stream().reduce(new HashMap(writeStats.size()), (map, stat) -> {
                String pathWithPartition = stat.getPath();
                if (pathWithPartition == null) {
                    LOG.warn((Object)("Unable to find path in write stat to update metadata table " + stat));
                    return map;
                }
                String fileName = FSUtils.getFileName(pathWithPartition, partitionStatName);
                map.merge(fileName, stat.getFileSizeInBytes(), Math::max);
                return map;
            }, CollectionUtils::combine);
            return HoodieMetadataPayload.createPartitionFilesRecord(partition, Option.of(updatedFilesToSizesMapping), Option.empty());
        }).collect(Collectors.toList());
        records.addAll(updatedPartitionFilesRecords);
        LOG.info((Object)("Updating at " + instantTime + " from Commit/" + (Object)((Object)commitMetadata.getOperationType()) + ". #partitions_updated=" + records.size()));
        return records;
    }

    private static List<String> getPartitionsAdded(HoodieCommitMetadata commitMetadata) {
        return commitMetadata.getPartitionToWriteStats().keySet().stream().map(HoodieTableMetadataUtil::getPartitionIdentifier).collect(Collectors.toList());
    }

    private static List<String> getPartitionsDeleted(HoodieCommitMetadata commitMetadata) {
        if (commitMetadata instanceof HoodieReplaceCommitMetadata && WriteOperationType.DELETE_PARTITION.equals((Object)commitMetadata.getOperationType())) {
            Map<String, List<String>> partitionToReplaceFileIds = ((HoodieReplaceCommitMetadata)commitMetadata).getPartitionToReplaceFileIds();
            return partitionToReplaceFileIds.keySet().stream().map(HoodieTableMetadataUtil::getPartitionIdentifier).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static HoodieData<HoodieRecord> convertMetadataToBloomFilterRecords(HoodieEngineContext context, HoodieCommitMetadata commitMetadata, String instantTime, MetadataRecordsGenerationParams recordsGenerationParams) {
        List allWriteStats = commitMetadata.getPartitionToWriteStats().values().stream().flatMap(entry -> entry.stream()).collect(Collectors.toList());
        if (allWriteStats.isEmpty()) {
            return context.emptyHoodieData();
        }
        int parallelism = Math.max(Math.min(allWriteStats.size(), recordsGenerationParams.getBloomIndexParallelism()), 1);
        HoodieData<HoodieWriteStat> allWriteStatsRDD = context.parallelize(allWriteStats, parallelism);
        return allWriteStatsRDD.flatMap(hoodieWriteStat -> {
            String partition = hoodieWriteStat.getPartitionPath();
            if (hoodieWriteStat instanceof HoodieDeltaWriteStat) {
                return Collections.emptyListIterator();
            }
            String pathWithPartition = hoodieWriteStat.getPath();
            if (pathWithPartition == null) {
                LOG.error((Object)("Failed to find path in write stat to update metadata table " + hoodieWriteStat));
                return Collections.emptyListIterator();
            }
            String fileName = FSUtils.getFileName(pathWithPartition, partition);
            if (!FSUtils.isBaseFile(new Path(fileName))) {
                return Collections.emptyListIterator();
            }
            Path writeFilePath = new Path(recordsGenerationParams.getDataMetaClient().getBasePath(), pathWithPartition);
            try {
                Throwable throwable = null;
                try (HoodieFileReader fileReader = HoodieFileReaderFactory.getFileReader(recordsGenerationParams.getDataMetaClient().getHadoopConf(), writeFilePath);){
                    BloomFilter fileBloomFilter;
                    block29: {
                        fileBloomFilter = fileReader.readBloomFilter();
                        if (fileBloomFilter != null) break block29;
                        LOG.error((Object)("Failed to read bloom filter for " + writeFilePath));
                        ListIterator listIterator = Collections.emptyListIterator();
                        fileReader.close();
                        return listIterator;
                    }
                    try {
                        ByteBuffer bloomByteBuffer = ByteBuffer.wrap(fileBloomFilter.serializeToString().getBytes());
                        HoodieRecord<HoodieMetadataPayload> record = HoodieMetadataPayload.createBloomFilterMetadataRecord(partition, fileName, instantTime, recordsGenerationParams.getBloomFilterType(), bloomByteBuffer, false);
                        Iterator<HoodieRecord<HoodieMetadataPayload>> iterator = Collections.singletonList(record).iterator();
                        fileReader.close();
                        return iterator;
                    }
                    catch (Exception e) {
                        ListIterator listIterator;
                        block30: {
                            block31: {
                                LOG.error((Object)("Failed to read bloom filter for " + writeFilePath));
                                listIterator = Collections.emptyListIterator();
                                fileReader.close();
                                if (fileReader == null) break block30;
                                if (throwable == null) break block31;
                                try {
                                    fileReader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block30;
                            }
                            fileReader.close();
                        }
                        return listIterator;
                        {
                            catch (Throwable throwable3) {
                                try {
                                    fileReader.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable = throwable4;
                                    throw throwable4;
                                }
                            }
                        }
                    }
                }
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to get bloom filter for file: " + writeFilePath + ", write stat: " + hoodieWriteStat));
                return Collections.emptyListIterator();
            }
        });
    }

    public static Map<MetadataPartitionType, HoodieData<HoodieRecord>> convertMetadataToRecords(HoodieEngineContext engineContext, HoodieCleanMetadata cleanMetadata, MetadataRecordsGenerationParams recordsGenerationParams, String instantTime) {
        HashMap<MetadataPartitionType, HoodieData<HoodieRecord>> partitionToRecordsMap = new HashMap<MetadataPartitionType, HoodieData<HoodieRecord>>();
        HoodieData<HoodieRecord> filesPartitionRecordsRDD = engineContext.parallelize(HoodieTableMetadataUtil.convertMetadataToFilesPartitionRecords(cleanMetadata, instantTime), 1);
        partitionToRecordsMap.put(MetadataPartitionType.FILES, filesPartitionRecordsRDD);
        if (recordsGenerationParams.getEnabledPartitionTypes().contains((Object)MetadataPartitionType.BLOOM_FILTERS)) {
            HoodieData<HoodieRecord> metadataBloomFilterRecordsRDD = HoodieTableMetadataUtil.convertMetadataToBloomFilterRecords(cleanMetadata, engineContext, instantTime, recordsGenerationParams);
            partitionToRecordsMap.put(MetadataPartitionType.BLOOM_FILTERS, metadataBloomFilterRecordsRDD);
        }
        if (recordsGenerationParams.getEnabledPartitionTypes().contains((Object)MetadataPartitionType.COLUMN_STATS)) {
            HoodieData<HoodieRecord> metadataColumnStatsRDD = HoodieTableMetadataUtil.convertMetadataToColumnStatsRecords(cleanMetadata, engineContext, recordsGenerationParams);
            partitionToRecordsMap.put(MetadataPartitionType.COLUMN_STATS, metadataColumnStatsRDD);
        }
        return partitionToRecordsMap;
    }

    public static List<HoodieRecord> convertMetadataToFilesPartitionRecords(HoodieCleanMetadata cleanMetadata, String instantTime) {
        LinkedList<HoodieRecord> records = new LinkedList<HoodieRecord>();
        int[] fileDeleteCount = new int[]{0};
        ArrayList<String> deletedPartitions = new ArrayList<String>();
        cleanMetadata.getPartitionMetadata().forEach((partitionName, partitionMetadata) -> {
            String partition = HoodieTableMetadataUtil.getPartitionIdentifier(partitionName);
            List<String> deletedFiles = partitionMetadata.getDeletePathPatterns();
            HoodieRecord<HoodieMetadataPayload> record = HoodieMetadataPayload.createPartitionFilesRecord(partition, Option.empty(), Option.of(new ArrayList<String>(deletedFiles)));
            records.add(record);
            fileDeleteCount[0] = fileDeleteCount[0] + deletedFiles.size();
            boolean isPartitionDeleted = partitionMetadata.getIsPartitionDeleted();
            if (isPartitionDeleted) {
                deletedPartitions.add((String)partitionName);
            }
        });
        if (!deletedPartitions.isEmpty()) {
            records.add(HoodieMetadataPayload.createPartitionListRecord(deletedPartitions, true));
        }
        LOG.info((Object)("Updating at " + instantTime + " from Clean. #partitions_updated=" + records.size() + ", #files_deleted=" + fileDeleteCount[0] + ", #partitions_deleted=" + deletedPartitions.size()));
        return records;
    }

    public static HoodieData<HoodieRecord> convertMetadataToBloomFilterRecords(HoodieCleanMetadata cleanMetadata, HoodieEngineContext engineContext, String instantTime, MetadataRecordsGenerationParams recordsGenerationParams) {
        ArrayList deleteFileList = new ArrayList();
        cleanMetadata.getPartitionMetadata().forEach((partition, partitionMetadata) -> {
            List<String> deletedFiles = partitionMetadata.getDeletePathPatterns();
            deletedFiles.forEach(entry -> {
                Path deletedFilePath = new Path(entry);
                if (FSUtils.isBaseFile(deletedFilePath)) {
                    deleteFileList.add(Pair.of(partition, deletedFilePath.getName()));
                }
            });
        });
        int parallelism = Math.max(Math.min(deleteFileList.size(), recordsGenerationParams.getBloomIndexParallelism()), 1);
        HoodieData deleteFileListRDD = engineContext.parallelize(deleteFileList, parallelism);
        return deleteFileListRDD.map(deleteFileInfoPair -> HoodieMetadataPayload.createBloomFilterMetadataRecord((String)deleteFileInfoPair.getLeft(), (String)deleteFileInfoPair.getRight(), instantTime, "", ByteBuffer.allocate(0), true));
    }

    public static HoodieData<HoodieRecord> convertMetadataToColumnStatsRecords(HoodieCleanMetadata cleanMetadata, HoodieEngineContext engineContext, MetadataRecordsGenerationParams recordsGenerationParams) {
        ArrayList deleteFileList = new ArrayList();
        cleanMetadata.getPartitionMetadata().forEach((partition, partitionMetadata) -> {
            List<String> deletedFiles = partitionMetadata.getDeletePathPatterns();
            deletedFiles.forEach(entry -> deleteFileList.add(Pair.of(partition, entry)));
        });
        HoodieTableMetaClient dataTableMetaClient = recordsGenerationParams.getDataMetaClient();
        List<String> columnsToIndex = HoodieTableMetadataUtil.getColumnsToIndex(recordsGenerationParams, Lazy.lazily(() -> HoodieTableMetadataUtil.tryResolveSchemaForTable(dataTableMetaClient)));
        if (columnsToIndex.isEmpty()) {
            return engineContext.emptyHoodieData();
        }
        int parallelism = Math.max(Math.min(deleteFileList.size(), recordsGenerationParams.getColumnStatsIndexParallelism()), 1);
        return engineContext.parallelize(deleteFileList, parallelism).flatMap(deleteFileInfoPair -> {
            String partitionPath = (String)deleteFileInfoPair.getLeft();
            String filePath = (String)deleteFileInfoPair.getRight();
            if (filePath.endsWith(HoodieFileFormat.PARQUET.getFileExtension())) {
                return HoodieTableMetadataUtil.getColumnStatsRecords(partitionPath, filePath, dataTableMetaClient, columnsToIndex, true).iterator();
            }
            return Collections.emptyListIterator();
        });
    }

    public static Map<MetadataPartitionType, HoodieData<HoodieRecord>> convertMetadataToRecords(HoodieEngineContext engineContext, HoodieActiveTimeline metadataTableTimeline, HoodieRestoreMetadata restoreMetadata, MetadataRecordsGenerationParams recordsGenerationParams, String instantTime, Option<String> lastSyncTs) {
        HashMap<MetadataPartitionType, HoodieData<HoodieRecord>> partitionToRecordsMap = new HashMap<MetadataPartitionType, HoodieData<HoodieRecord>>();
        HashMap<String, Map<String, Long>> partitionToAppendedFiles = new HashMap<String, Map<String, Long>>();
        HashMap<String, List<String>> partitionToDeletedFiles = new HashMap<String, List<String>>();
        HoodieTableMetadataUtil.processRestoreMetadata(metadataTableTimeline, restoreMetadata, partitionToAppendedFiles, partitionToDeletedFiles, lastSyncTs);
        HoodieData<HoodieRecord> filesPartitionRecordsRDD = engineContext.parallelize(HoodieTableMetadataUtil.convertFilesToFilesPartitionRecords(partitionToDeletedFiles, partitionToAppendedFiles, instantTime, "Restore"), 1);
        partitionToRecordsMap.put(MetadataPartitionType.FILES, filesPartitionRecordsRDD);
        if (recordsGenerationParams.getEnabledPartitionTypes().contains((Object)MetadataPartitionType.BLOOM_FILTERS)) {
            HoodieData<HoodieRecord> metadataBloomFilterRecordsRDD = HoodieTableMetadataUtil.convertFilesToBloomFilterRecords(engineContext, partitionToDeletedFiles, partitionToAppendedFiles, recordsGenerationParams, instantTime);
            partitionToRecordsMap.put(MetadataPartitionType.BLOOM_FILTERS, metadataBloomFilterRecordsRDD);
        }
        if (recordsGenerationParams.getEnabledPartitionTypes().contains((Object)MetadataPartitionType.COLUMN_STATS)) {
            HoodieData<HoodieRecord> metadataColumnStatsRDD = HoodieTableMetadataUtil.convertFilesToColumnStatsRecords(engineContext, partitionToDeletedFiles, partitionToAppendedFiles, recordsGenerationParams);
            partitionToRecordsMap.put(MetadataPartitionType.COLUMN_STATS, metadataColumnStatsRDD);
        }
        return partitionToRecordsMap;
    }

    private static void processRestoreMetadata(HoodieActiveTimeline metadataTableTimeline, HoodieRestoreMetadata restoreMetadata, Map<String, Map<String, Long>> partitionToAppendedFiles, Map<String, List<String>> partitionToDeletedFiles, Option<String> lastSyncTs) {
        restoreMetadata.getHoodieRestoreMetadata().values().forEach(rms -> rms.forEach(rm -> HoodieTableMetadataUtil.processRollbackMetadata(metadataTableTimeline, rm, partitionToDeletedFiles, partitionToAppendedFiles, lastSyncTs)));
    }

    public static Map<MetadataPartitionType, HoodieData<HoodieRecord>> convertMetadataToRecords(HoodieEngineContext engineContext, HoodieActiveTimeline metadataTableTimeline, HoodieRollbackMetadata rollbackMetadata, MetadataRecordsGenerationParams recordsGenerationParams, String instantTime, Option<String> lastSyncTs, boolean wasSynced) {
        HashMap<MetadataPartitionType, HoodieData<HoodieRecord>> partitionToRecordsMap = new HashMap<MetadataPartitionType, HoodieData<HoodieRecord>>();
        HashMap<String, List<String>> partitionToDeletedFiles = new HashMap<String, List<String>>();
        HashMap<String, Map<String, Long>> partitionToAppendedFiles = new HashMap<String, Map<String, Long>>();
        List<HoodieRecord> filesPartitionRecords = HoodieTableMetadataUtil.convertMetadataToRollbackRecords(metadataTableTimeline, rollbackMetadata, partitionToDeletedFiles, partitionToAppendedFiles, instantTime, lastSyncTs, wasSynced);
        HoodieData<HoodieRecord> rollbackRecordsRDD = engineContext.parallelize(filesPartitionRecords, 1);
        partitionToRecordsMap.put(MetadataPartitionType.FILES, rollbackRecordsRDD);
        if (recordsGenerationParams.getEnabledPartitionTypes().contains((Object)MetadataPartitionType.BLOOM_FILTERS)) {
            HoodieData<HoodieRecord> metadataBloomFilterRecordsRDD = HoodieTableMetadataUtil.convertFilesToBloomFilterRecords(engineContext, partitionToDeletedFiles, partitionToAppendedFiles, recordsGenerationParams, instantTime);
            partitionToRecordsMap.put(MetadataPartitionType.BLOOM_FILTERS, metadataBloomFilterRecordsRDD);
        }
        if (recordsGenerationParams.getEnabledPartitionTypes().contains((Object)MetadataPartitionType.COLUMN_STATS)) {
            HoodieData<HoodieRecord> metadataColumnStatsRDD = HoodieTableMetadataUtil.convertFilesToColumnStatsRecords(engineContext, partitionToDeletedFiles, partitionToAppendedFiles, recordsGenerationParams);
            partitionToRecordsMap.put(MetadataPartitionType.COLUMN_STATS, metadataColumnStatsRDD);
        }
        return partitionToRecordsMap;
    }

    private static List<HoodieRecord> convertMetadataToRollbackRecords(HoodieActiveTimeline metadataTableTimeline, HoodieRollbackMetadata rollbackMetadata, Map<String, List<String>> partitionToDeletedFiles, Map<String, Map<String, Long>> partitionToAppendedFiles, String instantTime, Option<String> lastSyncTs, boolean wasSynced) {
        HoodieTableMetadataUtil.processRollbackMetadata(metadataTableTimeline, rollbackMetadata, partitionToDeletedFiles, partitionToAppendedFiles, lastSyncTs);
        if (!wasSynced) {
            partitionToDeletedFiles.clear();
        }
        return HoodieTableMetadataUtil.convertFilesToFilesPartitionRecords(partitionToDeletedFiles, partitionToAppendedFiles, instantTime, "Rollback");
    }

    private static void processRollbackMetadata(HoodieActiveTimeline metadataTableTimeline, HoodieRollbackMetadata rollbackMetadata, Map<String, List<String>> partitionToDeletedFiles, Map<String, Map<String, Long>> partitionToAppendedFiles, Option<String> lastSyncTs) {
        rollbackMetadata.getPartitionMetadata().values().forEach(pm -> {
            boolean shouldSkip;
            String instantToRollback = rollbackMetadata.getCommitsRollback().get(0);
            boolean hasRollbackLogFiles = pm.getRollbackLogFiles() != null && !pm.getRollbackLogFiles().isEmpty();
            boolean hasNonZeroRollbackLogFiles = hasRollbackLogFiles && pm.getRollbackLogFiles().values().stream().mapToLong(Long::longValue).sum() > 0L;
            boolean bl = shouldSkip = lastSyncTs.isPresent() && HoodieTimeline.compareTimestamps(instantToRollback, HoodieTimeline.GREATER_THAN, (String)lastSyncTs.get());
            if (!hasNonZeroRollbackLogFiles && shouldSkip) {
                LOG.info((Object)String.format("Skipping syncing of rollbackMetadata at %s, given metadata table is already synced upto to %s", instantToRollback, lastSyncTs.get()));
                return;
            }
            HoodieInstant syncedInstant = new HoodieInstant(false, "deltacommit", instantToRollback);
            if (metadataTableTimeline.getCommitsTimeline().isBeforeTimelineStarts(syncedInstant.getTimestamp())) {
                throw new HoodieMetadataException(String.format("The instant %s required to sync rollback of %s has been archived", syncedInstant, instantToRollback));
            }
            boolean bl2 = shouldSkip = !metadataTableTimeline.containsInstant(syncedInstant);
            if (!hasNonZeroRollbackLogFiles && shouldSkip) {
                LOG.info((Object)String.format("Skipping syncing of rollbackMetadata at %s, since this instant was never committed to Metadata Table", instantToRollback));
                return;
            }
            String partition = pm.getPartitionPath();
            if (!(pm.getSuccessDeleteFiles().isEmpty() && pm.getFailedDeleteFiles().isEmpty() || shouldSkip)) {
                if (!partitionToDeletedFiles.containsKey(partition)) {
                    partitionToDeletedFiles.put(partition, new ArrayList());
                }
                List deletedFiles = pm.getSuccessDeleteFiles().stream().map(p -> new Path(p).getName()).collect(Collectors.toList());
                if (!pm.getFailedDeleteFiles().isEmpty()) {
                    deletedFiles.addAll(pm.getFailedDeleteFiles().stream().map(p -> new Path(p).getName()).collect(Collectors.toList()));
                }
                ((List)partitionToDeletedFiles.get(partition)).addAll(deletedFiles);
            }
            BiFunction<Long, Long, Long> fileMergeFn = (oldSize, newSizeCopy) -> oldSize > newSizeCopy ? oldSize : newSizeCopy;
            if (hasRollbackLogFiles) {
                if (!partitionToAppendedFiles.containsKey(partition)) {
                    partitionToAppendedFiles.put(partition, new HashMap());
                }
                pm.getRollbackLogFiles().forEach((path, size) -> ((Map)partitionToAppendedFiles.get(partition)).merge(new Path(path).getName(), size, fileMergeFn));
            }
        });
    }

    private static List<HoodieRecord> convertFilesToFilesPartitionRecords(Map<String, List<String>> partitionToDeletedFiles, Map<String, Map<String, Long>> partitionToAppendedFiles, String instantTime, String operation) {
        LinkedList<HoodieRecord> records = new LinkedList<HoodieRecord>();
        int[] fileChangeCount = new int[]{0, 0};
        partitionToDeletedFiles.forEach((partitionName, deletedFiles) -> {
            fileChangeCount[0] = fileChangeCount[0] + deletedFiles.size();
            String partition = HoodieTableMetadataUtil.getPartitionIdentifier(partitionName);
            Option<Map<String, Long>> filesAdded = Option.empty();
            if (partitionToAppendedFiles.containsKey(partitionName)) {
                filesAdded = Option.of(partitionToAppendedFiles.remove(partitionName));
            }
            HoodieRecord<HoodieMetadataPayload> record = HoodieMetadataPayload.createPartitionFilesRecord(partition, filesAdded, Option.of(new ArrayList(deletedFiles)));
            records.add(record);
        });
        partitionToAppendedFiles.forEach((partitionName, appendedFileMap) -> {
            String partition = HoodieTableMetadataUtil.getPartitionIdentifier(partitionName);
            fileChangeCount[1] = fileChangeCount[1] + appendedFileMap.size();
            ValidationUtils.checkState(!appendedFileMap.keySet().removeAll(partitionToDeletedFiles.getOrDefault(partition, Collections.emptyList())), "Rollback file cannot both be appended and deleted");
            HoodieRecord<HoodieMetadataPayload> record = HoodieMetadataPayload.createPartitionFilesRecord(partition, Option.of(appendedFileMap), Option.empty());
            records.add(record);
        });
        LOG.info((Object)("Found at " + instantTime + " from " + operation + ". #partitions_updated=" + records.size() + ", #files_deleted=" + fileChangeCount[0] + ", #files_appended=" + fileChangeCount[1]));
        return records;
    }

    public static String getPartitionIdentifier(@Nonnull String relativePartitionPath) {
        return "".equals(relativePartitionPath) ? "." : relativePartitionPath;
    }

    public static HoodieData<HoodieRecord> convertFilesToBloomFilterRecords(HoodieEngineContext engineContext, Map<String, List<String>> partitionToDeletedFiles, Map<String, Map<String, Long>> partitionToAppendedFiles, MetadataRecordsGenerationParams recordsGenerationParams, String instantTime) {
        HoodieData<HoodieRecord> allRecordsRDD = engineContext.emptyHoodieData();
        List partitionToDeletedFilesList = partitionToDeletedFiles.entrySet().stream().map(e -> Pair.of(e.getKey(), e.getValue())).collect(Collectors.toList());
        int parallelism = Math.max(Math.min(partitionToDeletedFilesList.size(), recordsGenerationParams.getBloomIndexParallelism()), 1);
        HoodieData<Pair> partitionToDeletedFilesRDD = engineContext.parallelize(partitionToDeletedFilesList, parallelism);
        HoodieData deletedFilesRecordsRDD = partitionToDeletedFilesRDD.flatMap(partitionToDeletedFilesPair -> {
            String partitionName = (String)partitionToDeletedFilesPair.getLeft();
            List deletedFileList = (List)partitionToDeletedFilesPair.getRight();
            return deletedFileList.stream().flatMap(deletedFile -> {
                if (!FSUtils.isBaseFile(new Path(deletedFile))) {
                    return Stream.empty();
                }
                String partition = HoodieTableMetadataUtil.getPartitionIdentifier(partitionName);
                return Stream.of(HoodieMetadataPayload.createBloomFilterMetadataRecord(partition, deletedFile, instantTime, "", ByteBuffer.allocate(0), true));
            }).iterator();
        });
        allRecordsRDD = allRecordsRDD.union(deletedFilesRecordsRDD);
        List partitionToAppendedFilesList = partitionToAppendedFiles.entrySet().stream().map(entry -> Pair.of(entry.getKey(), entry.getValue())).collect(Collectors.toList());
        parallelism = Math.max(Math.min(partitionToAppendedFilesList.size(), recordsGenerationParams.getBloomIndexParallelism()), 1);
        HoodieData<Pair> partitionToAppendedFilesRDD = engineContext.parallelize(partitionToAppendedFilesList, parallelism);
        HoodieData appendedFilesRecordsRDD = partitionToAppendedFilesRDD.flatMap(partitionToAppendedFilesPair -> {
            String partitionName = (String)partitionToAppendedFilesPair.getLeft();
            Map appendedFileMap = (Map)partitionToAppendedFilesPair.getRight();
            String partition = HoodieTableMetadataUtil.getPartitionIdentifier(partitionName);
            return appendedFileMap.entrySet().stream().flatMap(appendedFileLengthPairEntry -> {
                String appendedFile = (String)appendedFileLengthPairEntry.getKey();
                if (!FSUtils.isBaseFile(new Path(appendedFile))) {
                    return Stream.empty();
                }
                String pathWithPartition = partitionName + "/" + appendedFile;
                Path appendedFilePath = new Path(recordsGenerationParams.getDataMetaClient().getBasePath(), pathWithPartition);
                try (HoodieFileReader fileReader = HoodieFileReaderFactory.getFileReader(recordsGenerationParams.getDataMetaClient().getHadoopConf(), appendedFilePath);){
                    BloomFilter fileBloomFilter = fileReader.readBloomFilter();
                    if (fileBloomFilter == null) {
                        LOG.error((Object)("Failed to read bloom filter for " + appendedFilePath));
                        Stream stream2 = Stream.empty();
                        return stream2;
                    }
                    ByteBuffer bloomByteBuffer = ByteBuffer.wrap(fileBloomFilter.serializeToString().getBytes());
                    HoodieRecord<HoodieMetadataPayload> record = HoodieMetadataPayload.createBloomFilterMetadataRecord(partition, appendedFile, instantTime, recordsGenerationParams.getBloomFilterType(), bloomByteBuffer, false);
                    Stream<HoodieRecord<HoodieMetadataPayload>> stream = Stream.of(record);
                    return stream;
                }
                catch (IOException e) {
                    LOG.error((Object)("Failed to get bloom filter for file: " + appendedFilePath));
                    return Stream.empty();
                }
            }).iterator();
        });
        allRecordsRDD = allRecordsRDD.union(appendedFilesRecordsRDD);
        return allRecordsRDD;
    }

    public static HoodieData<HoodieRecord> convertFilesToColumnStatsRecords(HoodieEngineContext engineContext, Map<String, List<String>> partitionToDeletedFiles, Map<String, Map<String, Long>> partitionToAppendedFiles, MetadataRecordsGenerationParams recordsGenerationParams) {
        HoodieData<HoodieRecord> allRecordsRDD = engineContext.emptyHoodieData();
        HoodieTableMetaClient dataTableMetaClient = recordsGenerationParams.getDataMetaClient();
        List<String> columnsToIndex = HoodieTableMetadataUtil.getColumnsToIndex(recordsGenerationParams, Lazy.lazily(() -> HoodieTableMetadataUtil.tryResolveSchemaForTable(dataTableMetaClient)));
        if (columnsToIndex.isEmpty()) {
            return engineContext.emptyHoodieData();
        }
        List partitionToDeletedFilesList = partitionToDeletedFiles.entrySet().stream().map(e -> Pair.of(e.getKey(), e.getValue())).collect(Collectors.toList());
        int deletedFilesTargetParallelism = Math.max(Math.min(partitionToDeletedFilesList.size(), recordsGenerationParams.getColumnStatsIndexParallelism()), 1);
        HoodieData<Pair> partitionToDeletedFilesRDD = engineContext.parallelize(partitionToDeletedFilesList, deletedFilesTargetParallelism);
        HoodieData deletedFilesRecordsRDD = partitionToDeletedFilesRDD.flatMap(partitionToDeletedFilesPair -> {
            String partitionPath = (String)partitionToDeletedFilesPair.getLeft();
            String partitionId = HoodieTableMetadataUtil.getPartitionIdentifier(partitionPath);
            List deletedFileList = (List)partitionToDeletedFilesPair.getRight();
            return deletedFileList.stream().flatMap(deletedFile -> {
                String filePathWithPartition = partitionPath + "/" + deletedFile;
                return HoodieTableMetadataUtil.getColumnStatsRecords(partitionId, filePathWithPartition, dataTableMetaClient, columnsToIndex, true);
            }).iterator();
        });
        allRecordsRDD = allRecordsRDD.union(deletedFilesRecordsRDD);
        List partitionToAppendedFilesList = partitionToAppendedFiles.entrySet().stream().map(entry -> Pair.of(entry.getKey(), entry.getValue())).collect(Collectors.toList());
        int appendedFilesTargetParallelism = Math.max(Math.min(partitionToAppendedFilesList.size(), recordsGenerationParams.getColumnStatsIndexParallelism()), 1);
        HoodieData<Pair> partitionToAppendedFilesRDD = engineContext.parallelize(partitionToAppendedFilesList, appendedFilesTargetParallelism);
        HoodieData appendedFilesRecordsRDD = partitionToAppendedFilesRDD.flatMap(partitionToAppendedFilesPair -> {
            String partitionPath = (String)partitionToAppendedFilesPair.getLeft();
            String partitionId = HoodieTableMetadataUtil.getPartitionIdentifier(partitionPath);
            Map appendedFileMap = (Map)partitionToAppendedFilesPair.getRight();
            return appendedFileMap.entrySet().stream().flatMap(appendedFileNameLengthEntry -> {
                if (!FSUtils.isBaseFile(new Path((String)appendedFileNameLengthEntry.getKey())) || !((String)appendedFileNameLengthEntry.getKey()).endsWith(HoodieFileFormat.PARQUET.getFileExtension())) {
                    return Stream.empty();
                }
                String filePathWithPartition = partitionPath + "/" + (String)appendedFileNameLengthEntry.getKey();
                return HoodieTableMetadataUtil.getColumnStatsRecords(partitionId, filePathWithPartition, dataTableMetaClient, columnsToIndex, false);
            }).iterator();
        });
        allRecordsRDD = allRecordsRDD.union(appendedFilesRecordsRDD);
        return allRecordsRDD;
    }

    public static int mapRecordKeyToFileGroupIndex(String recordKey, int numFileGroups) {
        int h = 0;
        for (int i = 0; i < recordKey.length(); ++i) {
            h = 31 * h + recordKey.charAt(i);
        }
        return Math.abs(Math.abs(h) % numFileGroups);
    }

    public static List<FileSlice> getPartitionLatestMergedFileSlices(HoodieTableMetaClient metaClient, HoodieTableFileSystemView fsView, String partition) {
        LOG.info((Object)("Loading latest merged file slices for metadata table partition " + partition));
        return HoodieTableMetadataUtil.getPartitionFileSlices(metaClient, Option.of(fsView), partition, true);
    }

    public static List<FileSlice> getPartitionLatestFileSlices(HoodieTableMetaClient metaClient, Option<HoodieTableFileSystemView> fsView, String partition) {
        LOG.info((Object)("Loading latest file slices for metadata table partition " + partition));
        return HoodieTableMetadataUtil.getPartitionFileSlices(metaClient, fsView, partition, false);
    }

    public static HoodieTableFileSystemView getFileSystemView(HoodieTableMetaClient metaClient) {
        HoodieDefaultTimeline timeline = metaClient.getActiveTimeline();
        if (timeline.empty()) {
            HoodieInstant instant = new HoodieInstant(false, "deltacommit", HoodieActiveTimeline.createNewInstantTime());
            timeline = new HoodieDefaultTimeline(Stream.of(instant), metaClient.getActiveTimeline()::getInstantDetails);
        }
        return new HoodieTableFileSystemView(metaClient, timeline);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<FileSlice> getPartitionFileSlices(HoodieTableMetaClient metaClient, Option<HoodieTableFileSystemView> fileSystemView, String partition, boolean mergeFileSlices) {
        Stream<FileSlice> fileSliceStream;
        HoodieTableFileSystemView fsView = fileSystemView.orElse(HoodieTableMetadataUtil.getFileSystemView(metaClient));
        if (mergeFileSlices) {
            if (!metaClient.getActiveTimeline().filterCompletedInstants().lastInstant().isPresent()) return Collections.EMPTY_LIST;
            fileSliceStream = fsView.getLatestMergedFileSlicesBeforeOrOn(partition, metaClient.getActiveTimeline().filterCompletedInstants().lastInstant().get().getTimestamp());
            return fileSliceStream.sorted(Comparator.comparing(FileSlice::getFileId)).collect(Collectors.toList());
        } else {
            fileSliceStream = fsView.getLatestFileSlices(partition);
        }
        return fileSliceStream.sorted(Comparator.comparing(FileSlice::getFileId)).collect(Collectors.toList());
    }

    public static List<FileSlice> getPartitionLatestFileSlicesIncludingInflight(HoodieTableMetaClient metaClient, Option<HoodieTableFileSystemView> fileSystemView, String partition) {
        HoodieTableFileSystemView fsView = fileSystemView.orElse(HoodieTableMetadataUtil.getFileSystemView(metaClient));
        Stream<FileSlice> fileSliceStream = fsView.fetchLatestFileSlicesIncludingInflight(partition);
        return fileSliceStream.sorted(Comparator.comparing(FileSlice::getFileId)).collect(Collectors.toList());
    }

    public static HoodieData<HoodieRecord> convertMetadataToColumnStatsRecords(HoodieCommitMetadata commitMetadata, HoodieEngineContext engineContext, MetadataRecordsGenerationParams recordsGenerationParams) {
        List allWriteStats = commitMetadata.getPartitionToWriteStats().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (allWriteStats.isEmpty()) {
            return engineContext.emptyHoodieData();
        }
        try {
            Option<Schema> writerSchema = Option.ofNullable(commitMetadata.getMetadata("schema")).flatMap(writerSchemaStr -> StringUtils.isNullOrEmpty(writerSchemaStr) ? Option.empty() : Option.of(new Schema.Parser().parse(writerSchemaStr)));
            HoodieTableMetaClient dataTableMetaClient = recordsGenerationParams.getDataMetaClient();
            HoodieTableConfig tableConfig = dataTableMetaClient.getTableConfig();
            Option<Schema> tableSchema = writerSchema.map(schema -> tableConfig.populateMetaFields() ? HoodieAvroUtils.addMetadataFields(schema) : schema);
            List<String> columnsToIndex = HoodieTableMetadataUtil.getColumnsToIndex(recordsGenerationParams, Lazy.eagerly(tableSchema));
            if (columnsToIndex.isEmpty()) {
                return engineContext.emptyHoodieData();
            }
            int parallelism = Math.max(Math.min(allWriteStats.size(), recordsGenerationParams.getColumnStatsIndexParallelism()), 1);
            return engineContext.parallelize(allWriteStats, parallelism).flatMap(writeStat -> HoodieTableMetadataUtil.translateWriteStatToColumnStats(writeStat, dataTableMetaClient, columnsToIndex).iterator());
        }
        catch (Exception e) {
            throw new HoodieException("Failed to generate column stats records for metadata table", e);
        }
    }

    private static List<String> getColumnsToIndex(MetadataRecordsGenerationParams recordsGenParams, Lazy<Option<Schema>> lazyWriterSchemaOpt) {
        ValidationUtils.checkState(recordsGenParams.isColumnStatsIndexEnabled());
        List<String> targetColumns = recordsGenParams.getTargetColumnsForColumnStatsIndex();
        if (!targetColumns.isEmpty()) {
            return targetColumns;
        }
        Option<Schema> writerSchemaOpt = lazyWriterSchemaOpt.get();
        return writerSchemaOpt.map(writerSchema -> writerSchema.getFields().stream().map(Schema.Field::name).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private static Stream<HoodieRecord> translateWriteStatToColumnStats(HoodieWriteStat writeStat, HoodieTableMetaClient datasetMetaClient, List<String> columnsToIndex) {
        if (writeStat instanceof HoodieDeltaWriteStat && ((HoodieDeltaWriteStat)writeStat).getColumnStats().isPresent()) {
            Map<String, HoodieColumnRangeMetadata<Comparable>> columnRangeMap = ((HoodieDeltaWriteStat)writeStat).getColumnStats().get();
            Collection<HoodieColumnRangeMetadata<Comparable>> columnRangeMetadataList = columnRangeMap.values();
            return HoodieMetadataPayload.createColumnStatsRecords(writeStat.getPartitionPath(), columnRangeMetadataList, false);
        }
        return HoodieTableMetadataUtil.getColumnStatsRecords(writeStat.getPartitionPath(), writeStat.getPath(), datasetMetaClient, columnsToIndex, false);
    }

    private static Stream<HoodieRecord> getColumnStatsRecords(String partitionPath, String filePath, HoodieTableMetaClient datasetMetaClient, List<String> columnsToIndex, boolean isDeleted) {
        String filePartitionPath = filePath.startsWith("/") ? filePath.substring(1) : filePath;
        String fileName = FSUtils.getFileName(filePath, partitionPath);
        if (isDeleted) {
            List<HoodieColumnRangeMetadata<Comparable>> columnRangeMetadataList = columnsToIndex.stream().map(entry -> HoodieColumnRangeMetadata.stub(fileName, entry)).collect(Collectors.toList());
            return HoodieMetadataPayload.createColumnStatsRecords(partitionPath, columnRangeMetadataList, true);
        }
        List<HoodieColumnRangeMetadata<Comparable>> columnRangeMetadata = HoodieTableMetadataUtil.readColumnRangeMetadataFrom(filePartitionPath, datasetMetaClient, columnsToIndex);
        return HoodieMetadataPayload.createColumnStatsRecords(partitionPath, columnRangeMetadata, false);
    }

    private static List<HoodieColumnRangeMetadata<Comparable>> readColumnRangeMetadataFrom(String filePath, HoodieTableMetaClient datasetMetaClient, List<String> columnsToIndex) {
        try {
            if (filePath.endsWith(HoodieFileFormat.PARQUET.getFileExtension())) {
                Path fullFilePath = new Path(datasetMetaClient.getBasePath(), filePath);
                List<HoodieColumnRangeMetadata<Comparable>> columnRangeMetadataList = new ParquetUtils().readRangeFromParquetMetadata(datasetMetaClient.getHadoopConf(), fullFilePath, columnsToIndex);
                return columnRangeMetadataList;
            }
            LOG.warn((Object)("Column range index not supported for: " + filePath));
            return Collections.emptyList();
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to fetch column range metadata for: " + filePath));
            return Collections.emptyList();
        }
    }

    public static int getPartitionFileGroupCount(MetadataPartitionType partitionType, Option<HoodieTableMetaClient> metaClient, Option<HoodieTableFileSystemView> fsView, HoodieMetadataConfig metadataConfig, boolean isBootstrapCompleted) {
        if (isBootstrapCompleted) {
            List<FileSlice> latestFileSlices = HoodieTableMetadataUtil.getPartitionLatestFileSlices(metaClient.get(), fsView, partitionType.getPartitionPath());
            if (latestFileSlices.size() == 0 && !partitionType.getPartitionPath().equals(MetadataPartitionType.FILES.getPartitionPath())) {
                return HoodieTableMetadataUtil.getFileGroupCount(partitionType, metadataConfig);
            }
            return Math.max(latestFileSlices.size(), 1);
        }
        return HoodieTableMetadataUtil.getFileGroupCount(partitionType, metadataConfig);
    }

    private static int getFileGroupCount(MetadataPartitionType partitionType, HoodieMetadataConfig metadataConfig) {
        switch (partitionType) {
            case BLOOM_FILTERS: {
                return metadataConfig.getBloomFilterIndexFileGroupCount();
            }
            case COLUMN_STATS: {
                return metadataConfig.getColumnStatsIndexFileGroupCount();
            }
        }
        return 1;
    }

    public static BigDecimal tryUpcastDecimal(BigDecimal value, LogicalTypes.Decimal decimal) {
        int scale = decimal.getScale();
        int valueScale = value.scale();
        boolean scaleAdjusted = false;
        if (valueScale != scale) {
            try {
                value = value.setScale(scale, RoundingMode.UNNECESSARY);
                scaleAdjusted = true;
            }
            catch (ArithmeticException aex) {
                throw new AvroTypeException("Cannot encode decimal with scale " + valueScale + " as scale " + scale + " without rounding");
            }
        }
        int precision = decimal.getPrecision();
        int valuePrecision = value.precision();
        if (valuePrecision > precision) {
            if (scaleAdjusted) {
                throw new AvroTypeException("Cannot encode decimal with precision " + valuePrecision + " as max precision " + precision + ". This is after safely adjusting scale from " + valueScale + " to required " + scale);
            }
            throw new AvroTypeException("Cannot encode decimal with precision " + valuePrecision + " as max precision " + precision);
        }
        return value;
    }

    private static Option<Schema> tryResolveSchemaForTable(HoodieTableMetaClient dataTableMetaClient) {
        if (dataTableMetaClient.getCommitsTimeline().filterCompletedInstants().countInstants() == 0) {
            return Option.empty();
        }
        try {
            TableSchemaResolver schemaResolver = new TableSchemaResolver(dataTableMetaClient);
            return Option.of(schemaResolver.getTableAvroSchema());
        }
        catch (Exception e) {
            throw new HoodieException("Failed to get latest columns for " + dataTableMetaClient.getBasePath(), e);
        }
    }

    private static Comparable<?> coerceToComparable(Schema schema, Object val) {
        if (val == null) {
            return null;
        }
        switch (schema.getType()) {
            case UNION: {
                return HoodieTableMetadataUtil.coerceToComparable(AvroSchemaUtils.resolveNullableSchema(schema), val);
            }
            case FIXED: 
            case BYTES: {
                if (schema.getLogicalType() instanceof LogicalTypes.Decimal) {
                    return (Comparable)val;
                }
                return (ByteBuffer)val;
            }
            case INT: {
                if (schema.getLogicalType() == LogicalTypes.date() || schema.getLogicalType() == LogicalTypes.timeMillis()) {
                    return (Comparable)val;
                }
                return (Integer)val;
            }
            case LONG: {
                if (schema.getLogicalType() == LogicalTypes.timeMicros() || schema.getLogicalType() == LogicalTypes.timestampMicros() || schema.getLogicalType() == LogicalTypes.timestampMillis()) {
                    return (Comparable)val;
                }
                return (Long)val;
            }
            case STRING: {
                return val.toString();
            }
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                return (Comparable)val;
            }
            case ENUM: 
            case MAP: 
            case NULL: 
            case RECORD: 
            case ARRAY: {
                return null;
            }
        }
        throw new IllegalStateException("Unexpected type: " + schema.getType());
    }

    private static boolean canCompare(Schema schema) {
        return schema.getType() != Schema.Type.MAP;
    }

    public static Set<String> getInflightMetadataPartitions(HoodieTableConfig tableConfig) {
        return new HashSet<String>(tableConfig.getMetadataPartitionsInflight());
    }

    public static Set<String> getInflightAndCompletedMetadataPartitions(HoodieTableConfig tableConfig) {
        Set<String> inflightAndCompletedPartitions = HoodieTableMetadataUtil.getInflightMetadataPartitions(tableConfig);
        inflightAndCompletedPartitions.addAll(tableConfig.getMetadataPartitions());
        return inflightAndCompletedPartitions;
    }
}

