/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.distribution;

import io.trino.tpcds.distribution.StringValuesDistribution;
import io.trino.tpcds.random.RandomNumberStream;

public final class EnglishDistributions {
    private static final StringValuesDistribution ADJECTIVES_DISTRIBUTION = StringValuesDistribution.buildStringValuesDistribution("adjectives.dst", 1, 1);
    private static final StringValuesDistribution ADVERBS_DISTRIBUTION = StringValuesDistribution.buildStringValuesDistribution("adverbs.dst", 1, 1);
    private static final StringValuesDistribution ARTICLES_DISTRIBUTION = StringValuesDistribution.buildStringValuesDistribution("articles.dst", 1, 1);
    private static final StringValuesDistribution AUXILIARIES_DISTRIBUTION = StringValuesDistribution.buildStringValuesDistribution("auxiliaries.dst", 1, 1);
    private static final StringValuesDistribution PREPOSITIONS_DISTRIBUTION = StringValuesDistribution.buildStringValuesDistribution("prepositions.dst", 1, 1);
    private static final StringValuesDistribution NOUNS_DISTRIBUTION = StringValuesDistribution.buildStringValuesDistribution("nouns.dst", 1, 1);
    private static final StringValuesDistribution SENTENCES_DISTRIBUTION = StringValuesDistribution.buildStringValuesDistribution("sentences.dst", 1, 1);
    public static final StringValuesDistribution SYLLABLES_DISTRIBUTION = StringValuesDistribution.buildStringValuesDistribution("syllables.dst", 1, 1);
    private static final StringValuesDistribution TERMINATORS_DISTRIBUTION = StringValuesDistribution.buildStringValuesDistribution("terminators.dst", 1, 1);
    private static final StringValuesDistribution VERBS_DISTRIBUTION = StringValuesDistribution.buildStringValuesDistribution("verbs.dst", 1, 1);

    private EnglishDistributions() {
    }

    public static String pickRandomAdjective(RandomNumberStream stream) {
        return ADJECTIVES_DISTRIBUTION.pickRandomValue(0, 0, stream);
    }

    public static String pickRandomAdverb(RandomNumberStream stream) {
        return ADVERBS_DISTRIBUTION.pickRandomValue(0, 0, stream);
    }

    public static String pickRandomArticle(RandomNumberStream stream) {
        return ARTICLES_DISTRIBUTION.pickRandomValue(0, 0, stream);
    }

    public static String pickRandomAuxiliary(RandomNumberStream stream) {
        return AUXILIARIES_DISTRIBUTION.pickRandomValue(0, 0, stream);
    }

    public static String pickRandomNoun(RandomNumberStream stream) {
        return NOUNS_DISTRIBUTION.pickRandomValue(0, 0, stream);
    }

    public static String pickRandomPreposition(RandomNumberStream stream) {
        return PREPOSITIONS_DISTRIBUTION.pickRandomValue(0, 0, stream);
    }

    public static String pickRandomSentence(RandomNumberStream stream) {
        return SENTENCES_DISTRIBUTION.pickRandomValue(0, 0, stream);
    }

    public static String pickRandomTerminator(RandomNumberStream stream) {
        return TERMINATORS_DISTRIBUTION.pickRandomValue(0, 0, stream);
    }

    public static String pickRandomVerb(RandomNumberStream stream) {
        return VERBS_DISTRIBUTION.pickRandomValue(0, 0, stream);
    }
}

