/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.row;

import io.trino.tpcds.generator.GeneratorColumn;
import io.trino.tpcds.row.TableRow;
import io.trino.tpcds.type.Date;

public abstract class TableRowWithNulls
implements TableRow {
    private long nullBitMap;
    private GeneratorColumn firstColumn;

    protected TableRowWithNulls(long nullBitMap, GeneratorColumn firstColumn) {
        this.nullBitMap = nullBitMap;
        this.firstColumn = firstColumn;
    }

    private boolean isNull(GeneratorColumn column) {
        long kBitMask = 1L << column.getGlobalColumnNumber() - this.firstColumn.getGlobalColumnNumber();
        return (this.nullBitMap & kBitMask) != 0L;
    }

    protected <T> String getStringOrNull(T value, GeneratorColumn column) {
        return this.isNull(column) ? null : value.toString();
    }

    protected <T> String getStringOrNullForKey(long value, GeneratorColumn column) {
        return this.isNull(column) || value == -1L ? null : Long.toString(value);
    }

    protected <T> String getStringOrNullForBoolean(boolean value, GeneratorColumn column) {
        if (this.isNull(column)) {
            return null;
        }
        return value ? "Y" : "N";
    }

    protected <T> String getDateStringOrNullFromJulianDays(long value, GeneratorColumn column) {
        return this.isNull(column) || value < 0L ? null : Date.fromJulianDays((int)value).toString();
    }
}

